/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.machine;

import github.kasuminova.mmce.common.util.Sides;
import github.kasuminova.novaeng.client.gui.GuiGeocentricDrill;
import github.kasuminova.novaeng.common.machine.GeocentricDrill;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class GeocentricDrillController
extends TileMachineController {
    protected final Set<String> accelerateOres = new ObjectLinkedOpenHashSet();
    protected boolean accelerateOresChanged = false;
    protected float depth = 0.0f;
    protected int targetDepth = 1000;

    public GeocentricDrillController() {
    }

    public GeocentricDrillController(IBlockState state) {
        super(state);
    }

    public boolean diveOrAscend() {
        if (this.depth < (float)this.targetDepth) {
            this.depth += 0.1f;
            return true;
        }
        if (this.depth > (float)this.targetDepth) {
            this.depth = Math.max(this.depth - 1.0f, (float)this.targetDepth);
            return false;
        }
        return false;
    }

    public void setTargetDepth(int targetDepth) {
        this.targetDepth = MathHelper.func_76125_a((int)targetDepth, (int)1000, (int)10000);
        this.markNoUpdateSync();
    }

    public float getDepth() {
        return this.depth;
    }

    public int getTargetDepth() {
        return this.targetDepth;
    }

    @Nullable
    public RecipeCraftingContext.CraftingCheckResult checkPreStartResult(RecipeCraftingContext context) {
        context.getActiveRecipe().setMaxParallelism(MathHelper.func_76125_a((int)((int)(this.depth / 16.0f)), (int)1, (int)625));
        return super.checkPreStartResult(context);
    }

    public Set<String> getAccelerateOres() {
        return this.accelerateOres;
    }

    public synchronized void addAccelerateOre(String accelerateOre) {
        if (GeocentricDrill.GEOCENTRIC_DRILL.getRawOres().containsKey(accelerateOre)) {
            this.accelerateOres.add(accelerateOre);
            this.accelerateOresChanged = true;
            this.markNoUpdateSync();
        }
    }

    public synchronized void removeAccelerateOre(String accelerateOre) {
        if (this.accelerateOres.remove(accelerateOre)) {
            this.accelerateOresChanged = true;
            this.markNoUpdateSync();
        }
    }

    public synchronized RecipeCraftingContext createContext(ActiveMachineRecipe activeRecipe) {
        MachineRecipe newRecipe = GeocentricDrill.GEOCENTRIC_DRILL.rebuildRecipe(activeRecipe.getRecipe(), this.accelerateOres);
        ActiveMachineRecipe modifiedRecipe = new ActiveMachineRecipe(newRecipe, activeRecipe.getMaxParallelism());
        modifiedRecipe.setTick(activeRecipe.getTick());
        modifiedRecipe.setTotalTick(activeRecipe.getTotalTick());
        modifiedRecipe.setParallelism(activeRecipe.getParallelism());
        modifiedRecipe.setMaxParallelism(activeRecipe.getMaxParallelism());
        return super.createContext(modifiedRecipe);
    }

    public synchronized RecipeCraftingContext.CraftingCheckResult onRestartCheck(RecipeCraftingContext context) {
        if (this.accelerateOresChanged) {
            this.accelerateOresChanged = false;
            RecipeCraftingContext.CraftingCheckResult failure = new RecipeCraftingContext.CraftingCheckResult();
            failure.addError("\u91cd\u65b0\u52a0\u8f7d\u914d\u65b9\uff01");
            return failure;
        }
        return super.onRestartCheck(context);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagList accelerateOresList = new NBTTagList();
        for (String ore : this.accelerateOres) {
            accelerateOresList.func_74742_a((NBTBase)new NBTTagString(ore));
        }
        compound.func_74782_a("accelerateOres", (NBTBase)accelerateOresList);
        compound.func_74776_a("depth", this.depth);
        compound.func_74768_a("targetDepth", this.targetDepth);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.accelerateOres.clear();
        NBTTagList accelerateOresList = compound.func_150295_c("accelerateOres", 8);
        for (int i = 0; i < accelerateOresList.func_74745_c(); ++i) {
            this.accelerateOres.add(accelerateOresList.func_150307_f(i));
        }
        if (compound.func_74764_b("depth")) {
            this.depth = compound.func_74760_g("depth");
        }
        if (compound.func_74764_b("targetDepth")) {
            this.targetDepth = compound.func_74762_e("targetDepth");
        }
        if (Sides.isRunningOnClient()) {
            this.notifyClientGUIUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void notifyClientGUIUpdate() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        if (guiScreen instanceof GuiGeocentricDrill) {
            GuiGeocentricDrill geocentricDrill = (GuiGeocentricDrill)guiScreen;
            geocentricDrill.updateData();
        }
    }
}

