/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.estorage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStoragePart;
import hellfirepvp.modularmachinery.ModularMachinery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EStorageMEChannel
extends EStoragePart
implements ICellContainer,
IActionHost,
IGridProxyable,
IAEPowerStorage {
    protected final AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "channel", EStorageMEChannel.getVisualItemStack(), true);
    protected final IActionSource source = new MachineSource((IActionHost)this);
    protected int priority = 0;
    private boolean wasActive = false;

    public EStorageMEChannel() {
        this.proxy.setIdlePowerUsage(1.0);
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL, GridFlags.DENSE_CAPACITY});
    }

    public IActionSource getSource() {
        return this.source;
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel<?> channel) {
        if (this.partController != null) {
            return ((EStorageController)this.partController).getCellDrives().stream().map(drive -> drive.getHandler(channel)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public int getPriority() {
        return this.priority;
    }

    public static ItemStack getVisualItemStack() {
        return new ItemStack(Item.func_150898_a((Block)BlockEStorageMEChannel.INSTANCE), 1, 0);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.postCellArrayUpdateEvent();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.postCellArrayUpdateEvent();
    }

    protected void postCellArrayUpdateEvent() {
        boolean currentActive = this.proxy.isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public double injectAEPower(double amt, @Nonnull Actionable mode) {
        if (this.partController == null) {
            return 0.0;
        }
        if (amt < 1.0E-6) {
            return 0.0;
        }
        if (mode == Actionable.MODULATE && this.getAECurrentPower() < 0.01 && amt > 0.0) {
            this.proxy.getNode().getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        return ((EStorageController)this.partController).injectPower(amt, mode);
    }

    public double extractAEPower(double amt, @Nonnull Actionable mode, @Nonnull PowerMultiplier multiplier) {
        if (this.partController == null) {
            return 0.0;
        }
        if (mode == Actionable.MODULATE) {
            boolean wasFull;
            boolean bl = wasFull = this.getAECurrentPower() >= this.getAEMaxPower() - 0.001;
            if (wasFull && amt > 0.0) {
                try {
                    this.proxy.getGrid().postEvent((MENetworkEvent)new MENetworkPowerStorage((IAEPowerStorage)this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        }
        return multiplier.divide(((EStorageController)this.partController).extractPower(multiplier.multiply(amt), mode));
    }

    public double getAEMaxPower() {
        if (this.partController == null) {
            return 0.0;
        }
        return ((EStorageController)this.partController).getMaxEnergyStore();
    }

    public double getAECurrentPower() {
        if (this.partController == null) {
            return 0.0;
        }
        return ((EStorageController)this.partController).getEnergyStored();
    }

    public boolean isAEPublicPowerStorage() {
        return true;
    }

    @Nonnull
    public AccessRestriction getPowerFlow() {
        return AccessRestriction.READ_WRITE;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    @Nonnull
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        return this.proxy.getNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void securityBreak() {
        this.func_145831_w().func_175655_b(this.func_174877_v(), true);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.proxy.readFromNBT(compound);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.proxy.writeToNBT(compound);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.proxy.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.proxy.invalidate();
    }

    @Override
    public void onAssembled() {
        super.onAssembled();
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            this.proxy.onReady();
            ((EStorageController)this.partController).recalculateEnergyUsage();
            List<EStorageCellDrive> cellDrives = ((EStorageController)this.partController).getCellDrives();
            if (!cellDrives.isEmpty()) {
                try {
                    this.proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                }
                catch (GridAccessException gridAccessException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onDisassembled() {
        super.onDisassembled();
        this.proxy.invalidate();
    }

    public void blinkCell(int slot) {
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
    }
}

