/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.estorage;

import appeng.api.config.Actionable;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageEnergyCell;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.EnergyCellStatus;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStoragePart;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EStorageEnergyCell
extends EStoragePart
implements Comparable<EStorageEnergyCell> {
    protected double energyStored = 0.0;
    protected double maxEnergyStore = 0.0;
    protected boolean recalculateCap = false;
    protected EnergyCellStatus currentStatus = EnergyCellStatus.EMPTY;

    public EStorageEnergyCell() {
    }

    public EStorageEnergyCell(double maxEnergyStore) {
        this.maxEnergyStore = maxEnergyStore;
    }

    public void recalculateCapacity() {
        this.recalculateCap = false;
        double fillFactor = this.getFillFactor();
        EnergyCellStatus newStatus = EStorageEnergyCell.getStatusFromFillFactor(fillFactor);
        if (newStatus == this.currentStatus) {
            return;
        }
        this.currentStatus = newStatus;
        if (this.field_145850_b == null) {
            return;
        }
        this.markForUpdateSync();
    }

    public double injectPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            double fakeBattery = this.energyStored + amt;
            if (fakeBattery > this.maxEnergyStore) {
                return fakeBattery - this.maxEnergyStore;
            }
            return 0.0;
        }
        if (amt < 1.0E-6) {
            return 0.0;
        }
        if (this.energyStored >= this.maxEnergyStore) {
            return amt;
        }
        double maxCanInsert = this.maxEnergyStore - this.energyStored;
        double toInsert = Math.min(amt, maxCanInsert);
        this.energyStored += toInsert;
        this.recalculateCap = true;
        return amt - toInsert;
    }

    public double extractPower(double amt, Actionable mode) {
        if (mode == Actionable.SIMULATE) {
            return Math.min(this.energyStored, amt);
        }
        if (this.energyStored <= 0.0) {
            return 0.0;
        }
        double maxCanExtract = this.energyStored;
        double toExtract = Math.min(amt, maxCanExtract);
        this.energyStored -= toExtract;
        this.recalculateCap = true;
        return toExtract;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double energyStored) {
        this.energyStored = energyStored;
    }

    public double getMaxEnergyStore() {
        return this.maxEnergyStore;
    }

    public double getFillFactor() {
        return this.maxEnergyStore == 0.0 ? 0.0 : this.energyStored / this.maxEnergyStore;
    }

    public boolean shouldRecalculateCap() {
        return this.recalculateCap;
    }

    public void readCustomNBT(NBTTagCompound tag) {
        IBlockState current;
        super.readCustomNBT(tag);
        this.energyStored = tag.func_74769_h("energyStored");
        this.maxEnergyStore = tag.func_74769_h("maxEnergyStore");
        this.currentStatus = EStorageEnergyCell.getStatusFromFillFactor(this.getFillFactor());
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.field_145850_b != null && (current = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockEStorageEnergyCell) {
            this.field_145850_b.func_175656_a(this.field_174879_c, current.func_177226_a(EnergyCellStatus.STATUS, (Comparable)((Object)EStorageEnergyCell.getStatusFromFillFactor(this.getFillFactor()))));
        }
    }

    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        tag.func_74780_a("energyStored", this.energyStored);
        tag.func_74780_a("maxEnergyStore", this.maxEnergyStore);
    }

    @Override
    public int compareTo(EStorageEnergyCell o) {
        return Double.compare(o.energyStored, this.energyStored);
    }

    public static EnergyCellStatus getStatusFromFillFactor(double fillFactor) {
        EnergyCellStatus status = fillFactor >= 0.9 ? EnergyCellStatus.FULL : (fillFactor >= 0.7 ? EnergyCellStatus.HIGH : (fillFactor >= 0.5 ? EnergyCellStatus.MID : (fillFactor >= 0.05 ? EnergyCellStatus.LOW : EnergyCellStatus.EMPTY)));
        return status;
    }
}

