/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.estorage;

import appeng.api.config.Actionable;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import github.kasuminova.novaeng.client.util.BlockModelHider;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageController;
import github.kasuminova.novaeng.common.estorage.ECellDriveWatcher;
import github.kasuminova.novaeng.common.tile.ecotech.EPartController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageEnergyCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStoragePart;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.bus.EStorageBus;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EStorageController
extends EPartController<EStoragePart> {
    public static final List<BlockPos> HIDE_POS_LIST = Arrays.asList(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(1, 1, 0), new BlockPos(1, 0, 0), new BlockPos(1, -1, 0), new BlockPos(0, 1, 1), new BlockPos(0, 0, 1), new BlockPos(0, -1, 1), new BlockPos(1, 1, 1), new BlockPos(1, 0, 1), new BlockPos(1, -1, 1));
    protected final Queue<EStorageEnergyCell> energyCellsMin = new PriorityQueue(Comparator.reverseOrder());
    protected final Queue<EStorageEnergyCell> energyCellsMax = new PriorityQueue<EStorageEnergyCell>();
    protected BlockEStorageController parentController = null;
    protected double idleDrain = 64.0;
    protected EStorageMEChannel channel = null;

    public EStorageController(ResourceLocation machineRegistryName) {
        this.workMode = TileMultiblockMachineController.WorkMode.SYNC;
        this.parentMachine = MachineRegistry.getRegistry().getMachine(machineRegistryName);
        this.parentController = BlockEStorageController.REGISTRY.get(new ResourceLocation("novaeng_core", machineRegistryName.func_110623_a()));
    }

    public EStorageController() {
        this.workMode = TileMultiblockMachineController.WorkMode.SYNC;
    }

    @Override
    protected boolean onSyncTick() {
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            this.getCellDrives().forEach(EStorageCellDrive::updateWriteState);
            this.energyCellsMax.forEach(cell -> {
                if (cell.shouldRecalculateCap()) {
                    cell.recalculateCapacity();
                }
            });
        }
        return false;
    }

    @Override
    protected void onAddPart(EStoragePart part) {
        if (part instanceof EStorageEnergyCell) {
            EStorageEnergyCell energyCell = (EStorageEnergyCell)part;
            this.energyCellsMax.add(energyCell);
            this.energyCellsMin.add(energyCell);
        } else if (part instanceof EStorageMEChannel) {
            EStorageMEChannel channel;
            this.channel = channel = (EStorageMEChannel)part;
        }
    }

    @Override
    protected void clearParts() {
        super.clearParts();
        this.energyCellsMax.clear();
        this.energyCellsMin.clear();
        this.channel = null;
    }

    public double injectPower(double amt, Actionable mode) {
        EStorageEnergyCell cell;
        double toInject = amt;
        if (mode == Actionable.SIMULATE) {
            for (EStorageEnergyCell cell2 : this.energyCellsMin) {
                double prev = toInject;
                if (!((toInject -= toInject - cell2.injectPower(toInject, mode)) <= 0.0) && prev != toInject) continue;
                break;
            }
            return toInject;
        }
        LinkedList<EStorageEnergyCell> toReInsert = new LinkedList<EStorageEnergyCell>();
        while ((cell = this.energyCellsMin.poll()) != null) {
            double prev = toInject;
            toInject -= toInject - cell.injectPower(toInject, mode);
            toReInsert.add(cell);
            if (!(toInject <= 0.0) && !(prev < toInject)) continue;
            break;
        }
        if (!toReInsert.isEmpty()) {
            this.energyCellsMin.addAll(toReInsert);
        }
        return toInject;
    }

    public double extractPower(double amt, Actionable mode) {
        EStorageEnergyCell cell;
        double extracted = 0.0;
        if (mode == Actionable.SIMULATE) {
            for (EStorageEnergyCell cell2 : this.energyCellsMax) {
                double prev = extracted;
                if (!((extracted += cell2.extractPower(amt - extracted, mode)) >= amt) && !(prev >= extracted)) continue;
                break;
            }
            return extracted;
        }
        LinkedList<EStorageEnergyCell> toReInsert = new LinkedList<EStorageEnergyCell>();
        while ((cell = this.energyCellsMax.poll()) != null) {
            double prev = extracted;
            extracted += cell.extractPower(amt - extracted, mode);
            toReInsert.add(cell);
            if (!(extracted >= amt) && prev != extracted) continue;
            break;
        }
        if (!toReInsert.isEmpty()) {
            this.energyCellsMax.addAll(toReInsert);
        }
        return extracted;
    }

    public void recalculateEnergyUsage() {
        double newIdleDrain = 64.0;
        for (EStorageCellDrive drive : this.getCellDrives()) {
            ICellInventory cellInv;
            ICellInventoryHandler cellInventory;
            ECellDriveWatcher<IAEItemStack> watcher = drive.getWatcher();
            if (watcher == null || (cellInventory = (ICellInventoryHandler)watcher.getInternal()) == null || (cellInv = cellInventory.getCellInv()) == null) continue;
            newIdleDrain += cellInv.getIdleDrain();
        }
        this.idleDrain = newIdleDrain;
        if (this.channel != null) {
            this.channel.getProxy().setIdlePowerUsage(this.idleDrain);
        }
    }

    @Override
    protected Class<? extends Block> getControllerBlock() {
        return BlockEStorageController.class;
    }

    public double getEnergyStored() {
        EStorageEnergyCell cell;
        double stored;
        double energyStored = 0.0;
        Iterator iterator = this.energyCellsMax.iterator();
        while (iterator.hasNext() && !((stored = (cell = (EStorageEnergyCell)iterator.next()).getEnergyStored()) <= 1.0E-6)) {
            energyStored += stored;
        }
        return energyStored;
    }

    public double getMaxEnergyStore() {
        double maxEnergyStore = 0.0;
        for (EStorageEnergyCell energyCell : this.energyCellsMax) {
            maxEnergyStore += energyCell.getMaxEnergyStore();
        }
        return maxEnergyStore;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ClientProxy.clientScheduler.addRunnable(() -> {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
            this.notifyStructureFormedState(this.isStructureFormed());
        }, 0);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ClientProxy.clientScheduler.addRunnable(() -> {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
            this.notifyStructureFormedState(this.isStructureFormed());
        }, 0);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        boolean prevLoaded = this.loaded;
        this.loaded = false;
        super.readCustomNBT(compound);
        this.loaded = prevLoaded;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientProxy.clientScheduler.addRunnable(() -> {
                BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
                this.notifyStructureFormedState(this.isStructureFormed());
            }, 0);
        }
    }

    @Override
    protected void readMachineNBT(NBTTagCompound compound) {
        super.readMachineNBT(compound);
        if (compound.func_74764_b("parentMachine")) {
            ResourceLocation rl = new ResourceLocation(compound.func_74779_i("parentMachine"));
            this.parentMachine = MachineRegistry.getRegistry().getMachine(rl);
            if (this.parentMachine != null) {
                this.parentController = BlockEStorageController.REGISTRY.get(new ResourceLocation("novaeng_core", this.parentMachine.getRegistryName().func_110623_a()));
            } else {
                ModularMachinery.log.info("Couldn't find machine named " + rl + " for controller at " + this.func_174877_v());
            }
        }
    }

    public double getEnergyConsumePerTick() {
        return this.idleDrain;
    }

    public List<EStorageBus> getStorageBuses() {
        return this.parts.getParts(EStorageBus.class);
    }

    public List<EStorageCellDrive> getCellDrives() {
        return this.parts.getParts(EStorageCellDrive.class);
    }

    @Nullable
    public EStorageMEChannel getChannel() {
        return this.channel;
    }

    public BlockEStorageController getParentController() {
        return this.parentController;
    }
}

