/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.estorage;

import appeng.api.AEApi;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.helpers.ItemStackHelper;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngCellInventory;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageController;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageCapacity;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import github.kasuminova.novaeng.common.estorage.ECellDriveWatcher;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import github.kasuminova.novaeng.common.item.estorage.EStorageCell;
import github.kasuminova.novaeng.common.item.estorage.EStorageCellFluid;
import github.kasuminova.novaeng.common.item.estorage.EStorageCellItem;
import github.kasuminova.novaeng.common.network.PktCellDriveStatusUpdate;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStoragePart;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EStorageCellDrive
extends EStoragePart
implements ISaveProvider,
IAEAppEngInventory {
    protected final AppEngCellInventory driveInv = new AppEngCellInventory((IAEAppEngInventory)this, 1);
    protected final Map<IStorageChannel<? extends IAEStack<?>>, IMEInventoryHandler<?>> inventoryHandlers = new Reference2ObjectOpenHashMap();
    protected EStorageCellHandler cellHandler = null;
    protected ECellDriveWatcher<IAEItemStack> watcher = null;
    protected boolean isCached = false;
    protected long lastWriteTick = 0L;
    protected boolean writing = false;

    public EStorageCellDrive() {
        this.driveInv.setFilter((IAEItemFilter)CellInvFilter.INSTANCE);
    }

    public static int getMaxTypes(EStorageCellData data) {
        int n;
        switch (data.type()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                n = 0;
                break;
            }
            case ITEM: {
                n = 315;
                break;
            }
            case FLUID: {
                n = 25;
            }
        }
        return n;
    }

    public static long getMaxBytes(EStorageCellData data) {
        long l;
        DriveStorageType type = data.type();
        DriveStorageLevel level = data.level();
        block0 : switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                l = 0L;
                break;
            }
            case ITEM: {
                switch (level) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EMPTY: {
                        l = 0L;
                        break block0;
                    }
                    case A: {
                        l = EStorageCellItem.LEVEL_A.getBytes(ItemStack.field_190927_a);
                        break block0;
                    }
                    case B: {
                        l = EStorageCellItem.LEVEL_B.getBytes(ItemStack.field_190927_a);
                        break block0;
                    }
                    case C: 
                }
                l = EStorageCellItem.LEVEL_C.getBytes(ItemStack.field_190927_a);
                break;
            }
            case FLUID: {
                switch (level) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case EMPTY: {
                        l = 0L;
                        break block0;
                    }
                    case A: {
                        l = EStorageCellFluid.LEVEL_A.getBytes(ItemStack.field_190927_a);
                        break block0;
                    }
                    case B: {
                        l = EStorageCellFluid.LEVEL_B.getBytes(ItemStack.field_190927_a);
                        break block0;
                    }
                    case C: 
                }
                l = EStorageCellFluid.LEVEL_C.getBytes(ItemStack.field_190927_a);
            }
        }
        return l;
    }

    public void updateWriteState() {
        long totalWorldTime = this.field_145850_b.func_82737_E();
        boolean changed = false;
        if (totalWorldTime - this.lastWriteTick >= 40L) {
            if (this.writing) {
                this.writing = false;
                changed = true;
            }
        } else if (!this.writing) {
            this.writing = true;
            changed = true;
        }
        if (this.cellHandler == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            BlockPos pos = this.func_174877_v();
            NovaEngineeringCore.NET_CHANNEL.sendToAllTracking((IMessage)new PktCellDriveStatusUpdate(this.func_174877_v(), this.writing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), -1.0));
        } else if (changed) {
            BlockPos pos = this.func_174877_v();
            NovaEngineeringCore.NET_CHANNEL.sendToAllAround((IMessage)new PktCellDriveStatusUpdate(this.func_174877_v(), this.writing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 16.0));
        }
    }

    protected void updateHandler(boolean refreshState) {
        if (this.isCached) {
            return;
        }
        this.watcher = null;
        this.cellHandler = null;
        this.inventoryHandlers.clear();
        this.isCached = true;
        ItemStack stack = this.driveInv.getStackInSlot(0);
        if (stack.func_190926_b()) {
            this.updateDriveBlockState();
            return;
        }
        this.cellHandler = EStorageCellHandler.getHandler(stack);
        if (this.cellHandler == null) {
            return;
        }
        ICellInventoryHandler cellInventory = null;
        Collection storageChannels = AEApi.instance().storage().storageChannels();
        for (IStorageChannel channel : storageChannels) {
            cellInventory = this.cellHandler.getCellInventory(stack, this, channel);
            if (cellInventory == null) continue;
            this.driveInv.setHandler(0, cellInventory);
            this.watcher = new ECellDriveWatcher(cellInventory, channel, this);
            if (this.partController != null) {
                this.watcher.setPriority(((EStorageController)this.partController).getChannel().getPriority());
            }
            this.inventoryHandlers.put((IStorageChannel<IAEStack<?>>)channel, (IMEInventoryHandler<?>)this.watcher);
            break;
        }
        if (this.partController != null) {
            ((EStorageController)this.partController).recalculateEnergyUsage();
        }
        if (cellInventory == null || !refreshState) {
            return;
        }
        this.updateDriveBlockState();
    }

    public boolean isCellSupported(DriveStorageLevel level) {
        if (this.partController == null) {
            return false;
        }
        if (level == DriveStorageLevel.A) {
            BlockEStorageController parent = ((EStorageController)this.partController).getParentController();
            return parent == BlockEStorageController.L4 || parent == BlockEStorageController.L6 || parent == BlockEStorageController.L9;
        }
        if (level == DriveStorageLevel.B) {
            BlockEStorageController parent = ((EStorageController)this.partController).getParentController();
            return parent == BlockEStorageController.L6 || parent == BlockEStorageController.L9;
        }
        if (level == DriveStorageLevel.C) {
            BlockEStorageController parent = ((EStorageController)this.partController).getParentController();
            return parent == BlockEStorageController.L9;
        }
        return false;
    }

    public void updateDriveBlockState() {
        if (this.field_145850_b == null) {
            return;
        }
        this.markForUpdate();
    }

    public static DriveStorageType getCellType(EStorageCell<?> cell) {
        DriveStorageType type;
        if (cell instanceof EStorageCellItem) {
            type = DriveStorageType.ITEM;
        } else if (cell instanceof EStorageCellFluid) {
            type = DriveStorageType.FLUID;
        } else {
            return null;
        }
        return type;
    }

    public static DriveStorageCapacity getCapacity(ICellInventoryHandler cellInvHandler) {
        if (cellInvHandler == null) {
            return DriveStorageCapacity.EMPTY;
        }
        ICellInventory cellInv = cellInvHandler.getCellInv();
        if (cellInv == null) {
            return DriveStorageCapacity.EMPTY;
        }
        long totalTypes = cellInv.getTotalItemTypes();
        long storedTypes = cellInv.getStoredItemTypes();
        if (storedTypes == 0L) {
            return DriveStorageCapacity.EMPTY;
        }
        if (cellInv.getFreeBytes() <= 0L) {
            return DriveStorageCapacity.FULL;
        }
        if (storedTypes >= totalTypes) {
            return DriveStorageCapacity.TYPE_MAX;
        }
        return DriveStorageCapacity.EMPTY;
    }

    public <T extends IAEStack<T>> IMEInventoryHandler<T> getHandler(IStorageChannel<T> channel) {
        EStorageCell cell;
        this.updateHandler(false);
        Item item = this.driveInv.getStackInSlot(0).func_77973_b();
        if (item instanceof EStorageCell && this.isCellSupported((cell = (EStorageCell)item).getLevel())) {
            IMEInventoryHandler<?> handler = this.inventoryHandlers.get(channel);
            return handler == null ? null : handler;
        }
        return null;
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        this.isCached = false;
        this.updateHandler(true);
        this.markForUpdateSync();
        EStorageController controller = (EStorageController)((Object)this.getController());
        if (controller == null) {
            return;
        }
        EStorageMEChannel channel = controller.getChannel();
        AENetworkProxy proxy = channel.getProxy();
        IActionSource source = channel.getSource();
        try {
            if (proxy.isActive()) {
                IStorageGrid gs = proxy.getStorage();
                this.postChanges(gs, removed, added, source);
            }
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onAssembled() {
        super.onAssembled();
        if (this.watcher != null) {
            this.watcher.setPriority(((EStorageController)this.partController).getChannel().getPriority());
        }
    }

    @Override
    public void onDisassembled() {
        super.onDisassembled();
        EStorageController controller = (EStorageController)((Object)this.getController());
        if (controller == null) {
            return;
        }
        EStorageMEChannel channel = controller.getChannel();
        if (channel == null) {
            return;
        }
        AENetworkProxy proxy = channel.getProxy();
        IActionSource source = channel.getSource();
        try {
            if (proxy.isActive()) {
                ItemStack removed = this.driveInv.getStackInSlot(0);
                IStorageGrid gs = proxy.getStorage();
                this.postChanges(gs, removed, ItemStack.field_190927_a, source);
            }
            proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void postChanges(IStorageGrid gs, ItemStack removed, ItemStack added, IActionSource src) {
        if (this.cellHandler == null) {
            return;
        }
        for (IStorageChannel chan : AEApi.instance().storage().storageChannels()) {
            ICellInventoryHandler myInv;
            IItemList myChanges = chan.createList();
            if (!removed.func_190926_b() && (myInv = this.cellHandler.getCellInventory(removed, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
                for (IAEStack is : myChanges) {
                    is.setStackSize(-is.getStackSize());
                }
            }
            if (!added.func_190926_b() && (myInv = this.cellHandler.getCellInventory(added, null, chan)) != null) {
                myInv.getAvailableItems(myChanges);
            }
            gs.postAlterationOfStoredItems(chan, (Iterable)myChanges, src);
        }
    }

    public AppEngCellInventory getDriveInv() {
        return this.driveInv;
    }

    public ECellDriveWatcher<IAEItemStack> getWatcher() {
        return this.watcher;
    }

    public void onWriting() {
        this.lastWriteTick = this.field_145850_b.func_82737_E();
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.driveInv);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void readCustomNBT(NBTTagCompound tag) {
        super.readCustomNBT(tag);
        NBTTagCompound opt = tag.func_74775_l("driveInv");
        for (int x = 0; x < this.driveInv.getSlots(); ++x) {
            NBTTagCompound item = opt.func_74775_l("item" + x);
            ItemHandlerUtil.setStackInSlot((IItemHandler)this.driveInv, (int)x, (ItemStack)ItemStackHelper.stackFromNBT((NBTTagCompound)item));
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.notifyUpdate();
        }
    }

    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        NBTTagCompound opt = new NBTTagCompound();
        for (int x = 0; x < this.driveInv.getSlots(); ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = this.driveInv.getStackInSlot(x);
            if (!is.func_190926_b()) {
                ItemStackHelper.stackWriteToNBT((ItemStack)is, (NBTTagCompound)itemNBT);
            }
            opt.func_74782_a("item" + x, (NBTBase)itemNBT);
        }
        tag.func_74782_a("driveInv", (NBTBase)opt);
    }

    public void saveChanges(@Nullable ICellInventory<?> cellInventory) {
        this.saveChanges();
    }

    public void saveChanges() {
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.markChunkDirty();
    }

    private static class CellInvFilter
    implements IAEItemFilter {
        private static final CellInvFilter INSTANCE = new CellInvFilter();

        private CellInvFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && EStorageCellHandler.getHandler(stack) != null;
        }
    }
}

