/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.efabricator;

import appeng.api.storage.data.IAEItemStack;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.prop.WorkerStatus;
import github.kasuminova.novaeng.common.network.PktEFabricatorWorkerStatusUpdate;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPart;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EFabricatorWorker
extends EFabricatorPart {
    public static final int MAX_ENERGY_CACHE = 500000;
    public static final int MAX_QUEUE_DEPTH = 32;
    public static final int ENERGY_USAGE = 100;
    public static final int COOLANT_USAGE = 5;
    protected final CraftingQueue queue = new CraftingQueue();
    protected WorkerStatus status = WorkerStatus.OFF;
    protected int queueDepth = 32;
    protected int energyCache = 0;
    protected long lastUpdateTick = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doWork() {
        int completed;
        ItemList outputBuffer;
        EFabricatorController controller = (EFabricatorController)this.partController;
        int coolantCache = controller.getCoolantCache();
        int energyUsage = controller.isOverclocked() && !controller.isActiveCooling() ? controller.getLevel().applyOverclockEnergyUsage(100) : 100;
        int parallelism = Math.min(Math.max(controller.getAvailableParallelism(), 1), this.energyCache / energyUsage);
        if (controller.isActiveCooling()) {
            parallelism = Math.min(parallelism, coolantCache / 5);
        }
        ItemList itemList = outputBuffer = controller.getOutputBuffer();
        synchronized (itemList) {
            CraftWork craftWork;
            for (completed = 0; parallelism > completed && (craftWork = this.queue.poll()) != null; ++completed) {
                for (ItemStack remain : craftWork.getRemaining()) {
                    if (remain.func_190926_b()) continue;
                    outputBuffer.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)remain));
                }
                outputBuffer.add((IAEItemStack)AEItemStack.fromItemStack((ItemStack)craftWork.getOutput()));
            }
        }
        if (completed > 0) {
            this.energyCache -= energyUsage * completed;
            if (controller.isActiveCooling()) {
                controller.consumeCoolant(5 * completed);
            }
        }
        return completed;
    }

    public void supplyEnergy(int energy) {
        this.energyCache += energy;
    }

    public int getEnergyCache() {
        return this.energyCache;
    }

    public int getMaxEnergyCache() {
        return 500000;
    }

    public int getQueueDepth() {
        EFabricatorController controller = (EFabricatorController)((Object)this.getController());
        if (controller != null && controller.isOverclocked()) {
            return controller.getLevel().applyOverclockQueueDepth(this.queueDepth);
        }
        return this.queueDepth;
    }

    public void offerWork(CraftWork craftWork) {
        this.queue.add(craftWork);
    }

    public boolean hasWork() {
        return !this.queue.isEmpty();
    }

    public boolean isFull() {
        return this.queue.size() >= this.getQueueDepth();
    }

    public CraftingQueue getQueue() {
        return this.queue;
    }

    @Override
    public void onAssembled() {
        this.updateStatus(true);
        super.onAssembled();
    }

    @Override
    public void onDisassembled() {
        this.updateStatus(true);
        super.onDisassembled();
    }

    public void updateStatus(boolean force) {
        long prevUpdateTick = this.lastUpdateTick;
        long updateTick = this.func_145831_w().func_82737_E();
        if (!force && this.status == WorkerStatus.RUN && prevUpdateTick + 20L >= updateTick) {
            if (this.hasWork()) {
                this.lastUpdateTick = updateTick;
            }
            return;
        }
        if (this.getController() == null) {
            if (this.status != WorkerStatus.OFF) {
                this.setStatus(WorkerStatus.OFF);
            }
        } else if (this.hasWork()) {
            if (this.status != WorkerStatus.RUN) {
                this.setStatus(WorkerStatus.RUN);
            }
        } else if (this.status != WorkerStatus.ON) {
            this.setStatus(WorkerStatus.ON);
        }
        this.lastUpdateTick = updateTick;
    }

    public WorkerStatus getStatus() {
        return this.status;
    }

    public void setStatus(WorkerStatus status) {
        this.status = status;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.markNoUpdateSync();
        }
    }

    public void markNoUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            NovaEngineeringCore.NET_CHANNEL.sendToAllTracking((IMessage)new PktEFabricatorWorkerStatusUpdate(this.func_174877_v(), this.status), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), -1.0));
        }
        super.markNoUpdate();
    }

    public void readCustomNBT(NBTTagCompound compound) {
        this.queue.readFromNBT(compound);
        this.energyCache = compound.func_74762_e("energyCache");
        this.status = WorkerStatus.values()[compound.func_74771_c("status")];
        super.readCustomNBT(compound);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        this.queue.writeToNBT(compound);
        compound.func_74768_a("energyCache", this.energyCache);
        compound.func_74774_a("status", (byte)this.status.ordinal());
        super.writeCustomNBT(compound);
    }

    public static class CraftingQueue {
        private static final String QUEUE_TAG = "Q";
        private static final String STACK_SET_TAG = "SS";
        private static final String STACK_SET_TAG_ID_PREFIX = "S#";
        private static final String STACK_SET_SIZE_TAG = "SSS";
        private static final String REPEAT_TAG = "R";
        private final Deque<CraftWork> queue = new ArrayDeque<CraftWork>();

        public int size() {
            return this.queue.size();
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void add(CraftWork craftWork) {
            this.queue.add(craftWork);
        }

        public CraftWork poll() {
            return this.queue.poll();
        }

        public CraftWork peek() {
            return this.queue.peek();
        }

        public Deque<CraftWork> getQueue() {
            return this.queue;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.queue.isEmpty()) {
                return nbt;
            }
            ArrayList<ItemStack> stackSet = new ArrayList<ItemStack>();
            NBTTagList queueTag = new NBTTagList();
            CraftWork prev = null;
            int repeat = 0;
            for (CraftWork craftWork : this.queue) {
                if (prev != null && prev.equals(craftWork)) {
                    ++repeat;
                    continue;
                }
                if (repeat > 0) {
                    queueTag.func_150305_b(queueTag.func_74745_c() - 1).func_74777_a(REPEAT_TAG, (short)repeat);
                    repeat = 0;
                }
                queueTag.func_74742_a((NBTBase)craftWork.writeToNBT(stackSet));
                prev = craftWork;
            }
            if (repeat > 0) {
                queueTag.func_150305_b(queueTag.func_74745_c() - 1).func_74777_a(REPEAT_TAG, (short)repeat);
            }
            nbt.func_74782_a(QUEUE_TAG, (NBTBase)queueTag);
            NBTTagCompound stackSetTag = new NBTTagCompound();
            for (int i = 0; i < stackSet.size(); ++i) {
                ItemStack stack = (ItemStack)stackSet.get(i);
                if (stack.func_190926_b()) continue;
                stackSetTag.func_74782_a(STACK_SET_TAG_ID_PREFIX + i, (NBTBase)stack.serializeNBT());
            }
            nbt.func_74782_a(STACK_SET_TAG, (NBTBase)stackSetTag);
            nbt.func_74768_a(STACK_SET_SIZE_TAG, stackSet.size());
            return nbt;
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.queue.clear();
            ArrayList<ItemStack> stackSet = new ArrayList<ItemStack>();
            NBTTagCompound stackSetTag = nbt.func_74775_l(STACK_SET_TAG);
            for (int i = 0; i < nbt.func_74762_e(STACK_SET_SIZE_TAG); ++i) {
                stackSet.add(new ItemStack(stackSetTag.func_74775_l(STACK_SET_TAG_ID_PREFIX + i)));
            }
            NBTTagList queueTag = nbt.func_150295_c(QUEUE_TAG, 10);
            for (int i = 0; i < queueTag.func_74745_c(); ++i) {
                NBTTagCompound tagAt = queueTag.func_150305_b(i);
                CraftWork work = new CraftWork(tagAt, stackSet);
                this.queue.add(work);
                short repeat = tagAt.func_74765_d(REPEAT_TAG);
                for (short r = 0; r < repeat; r = (short)(r + 1)) {
                    this.queue.add(work.copy());
                }
            }
        }
    }

    public static class CraftWork {
        private static final String REMAIN_TAG_PREFIX = "R#";
        private static final String REMAIN_SIZE_TAG = "R#S";
        private static final String OUTPUT_TAG = "O";
        private final ItemStack[] remaining;
        private final ItemStack output;

        public CraftWork(ItemStack[] remaining, ItemStack output) {
            this.remaining = remaining;
            this.output = output;
        }

        public CraftWork(NBTTagCompound nbt, List<ItemStack> stackSet) {
            this.remaining = new ItemStack[nbt.func_74771_c(REMAIN_SIZE_TAG)];
            for (int remainIdx = 0; remainIdx < this.remaining.length; ++remainIdx) {
                int setIdx = nbt.func_74764_b(REMAIN_TAG_PREFIX + remainIdx) ? nbt.func_74762_e(REMAIN_TAG_PREFIX + remainIdx) : -1;
                this.remaining[remainIdx] = setIdx == -1 ? ItemStack.field_190927_a : stackSet.get(setIdx);
            }
            this.output = stackSet.get(nbt.func_74762_e(OUTPUT_TAG));
        }

        public NBTTagCompound writeToNBT(List<ItemStack> stackSet) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a(REMAIN_SIZE_TAG, (byte)this.remaining.length);
            block0: for (int remainIdx = 0; remainIdx < this.remaining.length; ++remainIdx) {
                ItemStack remain = this.remaining[remainIdx];
                if (remain.func_190926_b()) continue;
                for (int setIdx = 0; setIdx < stackSet.size(); ++setIdx) {
                    if (!CraftWork.matchStacksStrict(remain, stackSet.get(setIdx))) continue;
                    nbt.func_74777_a(REMAIN_TAG_PREFIX + remainIdx, (short)setIdx);
                    continue block0;
                }
                stackSet.add(remain);
                nbt.func_74777_a(REMAIN_TAG_PREFIX + remainIdx, (short)(stackSet.size() - 1));
            }
            for (int setIdx = 0; setIdx < stackSet.size(); ++setIdx) {
                if (!CraftWork.matchStacksStrict(this.output, stackSet.get(setIdx))) continue;
                nbt.func_74777_a(OUTPUT_TAG, (short)setIdx);
                return nbt;
            }
            stackSet.add(this.output);
            nbt.func_74777_a(OUTPUT_TAG, (short)(stackSet.size() - 1));
            return nbt;
        }

        public CraftWork copy() {
            ItemStack[] remaining = (ItemStack[])Arrays.stream(this.remaining).map(ItemStack::func_77946_l).toArray(ItemStack[]::new);
            return new CraftWork(remaining, this.output.func_77946_l());
        }

        public boolean equals(Object obj) {
            if (obj instanceof CraftWork) {
                CraftWork craftWork = (CraftWork)obj;
                for (int i = 0; i < this.remaining.length; ++i) {
                    if (CraftWork.matchStacksStrict(this.remaining[i], craftWork.remaining[i])) continue;
                    return false;
                }
                return CraftWork.matchStacksStrict(this.output, craftWork.output);
            }
            return false;
        }

        private static boolean matchStacksStrict(ItemStack stack1, ItemStack stack2) {
            return ItemUtils.matchStacks((ItemStack)stack1, (ItemStack)stack2) && stack1.func_190916_E() == stack2.func_190916_E();
        }

        public ItemStack[] getRemaining() {
            return this.remaining;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

