/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.efabricator;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.me.GridAccessException;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.filter.IAEItemFilter;
import com.glodblock.github.util.FluidCraftingPatternDetails;
import github.kasuminova.mmce.common.util.PatternItemFilter;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPart;
import hellfirepvp.modularmachinery.ModularMachinery;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EFabricatorPatternBus
extends EFabricatorPart
implements IAEAppEngInventory {
    public static final int PATTERN_SLOTS = 72;
    protected final AppEngInternalInventory patterns = new AppEngInternalInventory((IAEAppEngInventory)this, 72, 1, (IAEItemFilter)PatternItemFilter.INSTANCE);
    protected final List<ICraftingPatternDetails> details = new ObjectArrayList(72);

    public EFabricatorPatternBus() {
        IntStream.range(0, 72).mapToObj(i -> null).forEach(this.details::add);
    }

    protected void refreshPatterns() {
        for (int i = 0; i < 72; ++i) {
            this.refreshPattern(i);
        }
        this.notifyPatternChanged();
    }

    protected void refreshPattern(int slot) {
        this.details.set(slot, null);
        ItemStack pattern = this.patterns.getStackInSlot(slot);
        Item item = pattern.func_77973_b();
        if (pattern.func_190926_b() || !(item instanceof ICraftingPatternItem)) {
            return;
        }
        ICraftingPatternItem patternItem = (ICraftingPatternItem)item;
        ICraftingPatternDetails detail = patternItem.getPatternForItem(pattern, this.func_145831_w());
        if (detail != null && (detail.isCraftable() || detail instanceof FluidCraftingPatternDetails)) {
            this.details.set(slot, detail);
        }
    }

    public AppEngInternalInventory getPatterns() {
        return this.patterns;
    }

    public List<ICraftingPatternDetails> getDetails() {
        return this.details.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void saveChanges() {
        this.markNoUpdateSync();
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.refreshPattern(slot);
        this.notifyPatternChanged();
    }

    private void notifyPatternChanged() {
        if (this.partController == null) {
            return;
        }
        try {
            EFabricatorMEChannel channel = ((EFabricatorController)this.partController).getChannel();
            if (channel != null && channel.getProxy().isActive()) {
                channel.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)channel, channel.getProxy().getNode()));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(this::refreshPatterns);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Capability cap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        if (capability == cap) {
            return (T)cap.cast((Object)this.patterns);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.patterns.readFromNBT(compound.func_74775_l("patterns"));
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.patterns.writeToNBT(compound, "patterns");
    }
}

