/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.efabricator;

import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EFabricatorParallelProc
extends EFabricatorPart {
    protected final List<Modifier> modifiers = new ArrayList<Modifier>();
    protected final List<Modifier> overclockModifiers = new ArrayList<Modifier>();

    public EFabricatorParallelProc() {
    }

    public EFabricatorParallelProc(List<Modifier> modifiers, List<Modifier> overclockModifiers) {
        this.modifiers.addAll(modifiers);
        this.overclockModifiers.addAll(overclockModifiers);
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<Modifier> getOverclockModifiers() {
        return this.overclockModifiers;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.modifiers.clear();
        compound.func_150295_c("modifiers", 10).forEach(tag -> this.modifiers.add(Modifier.readFromNBT((NBTTagCompound)tag)));
        this.overclockModifiers.clear();
        compound.func_150295_c("overclockModifiers", 10).forEach(tag -> this.overclockModifiers.add(Modifier.readFromNBT((NBTTagCompound)tag)));
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagList modifiersTag = new NBTTagList();
        this.modifiers.forEach(modifier -> modifiersTag.func_74742_a((NBTBase)modifier.writeToNBT()));
        compound.func_74782_a("modifiers", (NBTBase)modifiersTag);
        NBTTagList overclockModifiersTag = new NBTTagList();
        this.overclockModifiers.forEach(modifier -> overclockModifiersTag.func_74742_a((NBTBase)modifier.writeToNBT()));
        compound.func_74782_a("overclockModifiers", (NBTBase)overclockModifiersTag);
    }

    public static final class Modifier {
        private final Type type;
        private final double value;
        private final boolean debuff;

        public Modifier(Type type, double value, boolean debuff) {
            this.type = type;
            this.value = value;
            this.debuff = debuff;
        }

        public Type getType() {
            return this.type;
        }

        public double apply(double parallelism) {
            return this.type.apply(this.value, parallelism);
        }

        public boolean isBuff() {
            return !this.debuff;
        }

        public boolean isDebuff() {
            return this.debuff;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("type", (byte)this.type.ordinal());
            tag.func_74780_a("value", this.value);
            tag.func_74757_a("debuff", this.debuff);
            return tag;
        }

        public static Modifier readFromNBT(NBTTagCompound tag) {
            return new Modifier(Type.values()[tag.func_74771_c("type")], tag.func_74769_h("value"), tag.func_74767_n("debuff"));
        }

        @SideOnly(value=Side.CLIENT)
        public String getDesc() {
            switch (this.type) {
                case ADD: {
                    return this.isBuff() ? I18n.func_135052_a((String)"novaeng.efabricator_parallel_proc.modifier.add", (Object[])new Object[]{this.value}) : I18n.func_135052_a((String)"novaeng.efabricator_parallel_proc.modifier.sub", (Object[])new Object[]{Math.abs(this.value)});
                }
                case MULTIPLY: {
                    return this.isBuff() ? I18n.func_135052_a((String)"novaeng.efabricator_parallel_proc.modifier.mul", (Object[])new Object[]{NovaEngUtils.formatDouble((1.0 - this.value) * 100.0, 1)}) : I18n.func_135052_a((String)"novaeng.efabricator_parallel_proc.modifier.mul.debuff", (Object[])new Object[]{NovaEngUtils.formatDouble(Math.abs(1.0 - this.value) * 100.0, 1)});
                }
            }
            return "";
        }
    }

    public static enum Type {
        ADD(0),
        MULTIPLY(1);

        final int priority;

        private Type(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }

        public double apply(double value, double parallelism) {
            double d;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case ADD: {
                    d = value + parallelism;
                    break;
                }
                case MULTIPLY: {
                    d = value * parallelism;
                }
            }
            return d;
        }
    }
}

