/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.efabricator;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.glodblock.github.util.FluidCraftingPatternDetails;
import github.kasuminova.mmce.common.util.PatternItemFilter;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPart;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPatternBus;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorWorker;
import hellfirepvp.modularmachinery.ModularMachinery;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class EFabricatorMEChannel
extends EFabricatorPart
implements ICraftingProvider,
IActionHost,
IGridProxyable {
    protected final AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "channel", EFabricatorMEChannel.getVisualItemStack(), true);
    protected final IActionSource source = new MachineSource((IActionHost)this);
    private boolean wasActive = false;

    public EFabricatorMEChannel() {
        this.proxy.setIdlePowerUsage(1.0);
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL, GridFlags.DENSE_CAPACITY});
    }

    public IActionSource getSource() {
        return this.source;
    }

    public static ItemStack getVisualItemStack() {
        return new ItemStack(Item.func_150898_a((Block)BlockEFabricatorMEChannel.INSTANCE), 1, 0);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange c) {
        this.postPatternChangeEvent();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged c) {
        this.postPatternChangeEvent();
    }

    protected void postPatternChangeEvent() {
        boolean currentActive = this.proxy.isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            try {
                this.proxy.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.proxy.getNode()));
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        EFabricatorController controller = (EFabricatorController)((Object)this.getController());
        if (controller == null) {
            return;
        }
        List<EFabricatorPatternBus> patternBuses = controller.getPatternBuses();
        patternBuses.stream().flatMap(patternBus -> patternBus.getDetails().stream()).filter(details -> details.isCraftable() || details instanceof FluidCraftingPatternDetails).forEach(details -> craftingTracker.addCraftingOption((ICraftingMedium)this, details));
    }

    public boolean pushPattern(ICraftingPatternDetails pattern, InventoryCrafting table) {
        if (this.isBusy()) {
            return false;
        }
        if (!pattern.isCraftable()) {
            if (pattern instanceof FluidCraftingPatternDetails) {
                return this.pushFluidPattern((FluidCraftingPatternDetails)pattern);
            }
            return false;
        }
        ItemStack output = pattern.getOutput(table, this.func_145831_w());
        if (output.func_190926_b()) {
            return false;
        }
        ItemStack[] remaining = new ItemStack[9];
        for (int i = 0; i < Math.min(table.func_70302_i_(), 9); ++i) {
            remaining[i] = Platform.getContainerItem((ItemStack)table.func_70301_a(i));
        }
        return ((EFabricatorController)this.partController).offerWork(new EFabricatorWorker.CraftWork(remaining, output));
    }

    protected boolean pushFluidPattern(FluidCraftingPatternDetails pattern) {
        Object[] remaining = new ItemStack[9];
        Arrays.fill(remaining, ItemStack.field_190927_a);
        IAEItemStack[] outputs = pattern.getOutputs();
        ItemStack output = outputs[0] != null ? outputs[0].getCachedItemStack(outputs[0].getStackSize()) : ItemStack.field_190927_a;
        return ((EFabricatorController)this.partController).offerWork(new EFabricatorWorker.CraftWork((ItemStack[])remaining, output));
    }

    public boolean insertPattern(ItemStack patternStack) {
        if (!PatternItemFilter.INSTANCE.allowInsert(null, -1, patternStack)) {
            return false;
        }
        if (this.partController != null) {
            return ((EFabricatorController)this.partController).insertPattern(patternStack);
        }
        return false;
    }

    public boolean isBusy() {
        if (this.partController != null) {
            return ((EFabricatorController)this.partController).isQueueFull();
        }
        return false;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    @Nonnull
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        return this.proxy.getNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void securityBreak() {
        this.func_145831_w().func_175655_b(this.func_174877_v(), true);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.proxy.readFromNBT(compound);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.proxy.writeToNBT(compound);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.proxy.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.proxy.invalidate();
    }

    @Override
    public void onAssembled() {
        super.onAssembled();
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            this.proxy.onReady();
            ((EFabricatorController)this.partController).recalculateEnergyUsage();
        });
    }

    @Override
    public void onDisassembled() {
        super.onDisassembled();
        this.proxy.invalidate();
    }
}

