/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech.efabricator;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.item.ItemList;
import github.kasuminova.mmce.client.util.ItemStackUtils;
import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.util.BlockModelHider;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorController;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.prop.Levels;
import github.kasuminova.novaeng.common.network.PktEFabricatorGUIData;
import github.kasuminova.novaeng.common.tile.ecotech.EPartController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorParallelProc;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPart;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPatternBus;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorWorker;
import github.kasuminova.novaeng.common.util.MachineCoolants;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.client.ClientProxy;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EFabricatorController
extends EPartController<EFabricatorPart> {
    public static final int MAX_COOLANT_CACHE = 100000;
    public static final int WORK_DELAY = 20;
    public static final List<BlockPos> HIDE_POS_LIST = Arrays.asList(new BlockPos(0, 1, 0), new BlockPos(0, -1, 0), new BlockPos(0, 1, 1), new BlockPos(0, 0, 1), new BlockPos(0, -1, 1), new BlockPos(1, 1, 0), new BlockPos(1, 0, 0), new BlockPos(1, -1, 0), new BlockPos(1, 1, 1), new BlockPos(1, 0, 1), new BlockPos(1, -1, 1), new BlockPos(-1, 1, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, -1, 0), new BlockPos(-1, 1, 1), new BlockPos(-1, 0, 1), new BlockPos(-1, -1, 1));
    protected final List<IFluidHandler> coolantInputHandlers = new ArrayList<IFluidHandler>();
    protected final List<IFluidHandler> coolantOutputHandlers = new ArrayList<IFluidHandler>();
    protected final IItemStorageChannel itemChannel = (IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class);
    protected ItemList outputBuffer = new ItemList();
    protected BlockEFabricatorController parentController = null;
    protected double idleDrain = 64.0;
    protected EFabricatorMEChannel channel = null;
    protected int length = 0;
    protected int workDelay = 20;
    protected int maxWorkDelay = 20;
    protected int parallelism = 0;
    protected int consumedParallelism = 0;
    protected int coolantCache = 0;
    protected long totalCrafted = 0L;
    protected boolean speedupApplied = false;
    protected boolean overclocked = false;
    protected boolean activeCooling = false;
    protected PktEFabricatorGUIData guiDataPacket = null;
    protected volatile boolean guiDataDirty = false;

    public EFabricatorController(ResourceLocation machineRegistryName) {
        this();
        this.parentMachine = MachineRegistry.getRegistry().getMachine(machineRegistryName);
        this.parentController = BlockEFabricatorController.REGISTRY.get(new ResourceLocation("novaeng_core", machineRegistryName.func_110623_a()));
    }

    public EFabricatorController() {
        this.workMode = TileMultiblockMachineController.WorkMode.SEMI_SYNC;
    }

    @Override
    protected boolean onSyncTick() {
        if (this.channel == null || !this.channel.getProxy().isActive()) {
            this.tickExecutor = null;
            return false;
        }
        --this.workDelay;
        if (this.workDelay > 0) {
            this.tickExecutor = null;
            return false;
        }
        this.workDelay = this.maxWorkDelay;
        this.speedupApplied = false;
        this.clearOutputBuffer();
        this.supplyWorkerPower();
        this.supplyCoolantCache();
        return true;
    }

    @Override
    protected void onAsyncTick() {
        this.updateGUIDataPacket();
        long prevTotalCrafted = this.totalCrafted;
        List<EFabricatorWorker> workers = this.getWorkers();
        workers.forEach(worker -> worker.updateStatus(false));
        for (EFabricatorWorker worker2 : workers) {
            if (!worker2.hasWork()) continue;
            int worked = worker2.doWork();
            this.totalCrafted += (long)worked;
            this.consumedParallelism += worked <= 1 ? 0 : worked;
        }
        if (this.activeCooling && this.hasWork()) {
            this.convertOverflowParallelismToWorkDelay(this.parallelism - this.consumedParallelism);
        }
        this.consumedParallelism = 0;
        if (prevTotalCrafted != this.totalCrafted) {
            this.markNoUpdateSync();
        }
    }

    protected void supplyCoolantCache() {
        if (this.coolantCache >= 100000) {
            return;
        }
        for (IFluidHandler inputHandler : this.coolantInputHandlers) {
            for (IFluidTankProperties property : inputHandler.getTankProperties()) {
                MachineCoolants.Coolant coolant;
                FluidStack contents = property.getContents();
                if (contents == null || contents.amount == 0 || (coolant = MachineCoolants.INSTANCE.getCoolant(contents.getFluid())) == null) continue;
                for (IFluidHandler outputHandler : this.coolantOutputHandlers) {
                    int maxCanConsume = coolant.maxCanConsume(inputHandler, outputHandler);
                    if (maxCanConsume <= 0) continue;
                    int required = 100000 - this.coolantCache;
                    int mul = required / coolant.coolantUnit();
                    if (mul * coolant.coolantUnit() < required) {
                        ++mul;
                    }
                    if ((mul = Math.min(mul, maxCanConsume)) <= 0) continue;
                    FluidStack input = coolant.input();
                    inputHandler.drain(new FluidStack(input, mul * input.amount), true);
                    FluidStack output = coolant.output();
                    if (output != null) {
                        outputHandler.fill(new FluidStack(output, mul * output.amount), true);
                    }
                    this.coolantCache += mul * coolant.coolantUnit();
                    if (this.coolantCache < 100000) continue;
                    return;
                }
            }
        }
    }

    protected void supplyWorkerPower() {
        IEnergyGrid energy;
        try {
            energy = this.channel.getProxy().getEnergy();
        }
        catch (GridAccessException ignored) {
            return;
        }
        for (EFabricatorWorker worker : this.getWorkers()) {
            if (worker.getEnergyCache() >= worker.getMaxEnergyCache()) continue;
            worker.supplyEnergy((int)energy.extractAEPower((double)(worker.getMaxEnergyCache() - worker.getEnergyCache()), Actionable.MODULATE, PowerMultiplier.CONFIG));
        }
    }

    protected void clearOutputBuffer() {
        try {
            AENetworkProxy proxy = this.channel.getProxy();
            IMEMonitor inv = proxy.getStorage().getInventory((IStorageChannel)this.itemChannel);
            for (IAEItemStack stack : this.outputBuffer) {
                IAEItemStack notInserted = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)inv, (IAEStack)stack.copy(), (IActionSource)this.channel.getSource());
                if (notInserted != null) {
                    stack.setStackSize(notInserted.getStackSize());
                    continue;
                }
                stack.setStackSize(0L);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    protected void updateComponents() {
        super.updateComponents();
        IDynamicPatternInfo workers = this.getDynamicPattern("workers");
        this.length = workers != null ? workers.getSize() : 0;
        this.foundComponents.values().forEach(component -> {
            Object patt9659$temp = component.providedComponent();
            if (patt9659$temp instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)patt9659$temp;
                switch (component.getComponent().ioType) {
                    case INPUT: {
                        this.coolantInputHandlers.add(handler);
                        break;
                    }
                    case OUTPUT: {
                        this.coolantOutputHandlers.add(handler);
                    }
                }
            }
        });
        this.updateParallelism();
        this.updateWorkDelay();
    }

    @Override
    protected void onAddPart(EFabricatorPart part) {
        if (part instanceof EFabricatorMEChannel) {
            EFabricatorMEChannel channel;
            this.channel = channel = (EFabricatorMEChannel)part;
        }
    }

    @Override
    protected void clearParts() {
        super.clearParts();
        this.coolantInputHandlers.clear();
        this.coolantOutputHandlers.clear();
        this.channel = null;
        this.length = 0;
    }

    protected void updateParallelism() {
        double[] parallelism = new double[]{0.0};
        Map modifierMap = this.getParallelProcs().stream().flatMap(proc -> this.overclocked ? Stream.concat(proc.modifiers.stream(), proc.overclockModifiers.stream()) : proc.modifiers.stream()).filter(modifier -> modifier.isBuff() || !this.activeCooling).collect(Collectors.groupingBy(EFabricatorParallelProc.Modifier::getType, () -> new TreeMap(Comparator.comparingInt(EFabricatorParallelProc.Type::getPriority)), Collectors.toList()));
        modifierMap.values().stream().flatMap(Collection::stream).filter(EFabricatorParallelProc.Modifier::isBuff).forEach(modifier -> {
            parallelism[0] = modifier.apply(parallelism[0]);
        });
        modifierMap.values().stream().flatMap(Collection::stream).filter(EFabricatorParallelProc.Modifier::isDebuff).forEach(modifier -> {
            parallelism[0] = modifier.apply(parallelism[0]);
        });
        this.parallelism = (int)Math.round(parallelism[0]);
    }

    public synchronized void convertOverflowParallelismToWorkDelay(int overflow) {
        if (overflow <= 0 || this.speedupApplied) {
            return;
        }
        float ratio = (float)this.parallelism / (float)overflow;
        int speedUp = Math.min(Math.round(ratio / 0.05f), this.maxWorkDelay - 1);
        double coolantUsage = (double)this.parallelism * 0.04;
        int maxCanConsume = (int)((double)this.coolantCache / coolantUsage);
        speedUp = Math.min(speedUp, maxCanConsume);
        this.coolantCache -= (int)Math.round((double)speedUp * coolantUsage);
        this.workDelay = this.maxWorkDelay - speedUp;
        this.speedupApplied = true;
    }

    public void updateWorkDelay() {
        this.maxWorkDelay = this.activeCooling ? 20 - this.getWorkers().size() : 20;
    }

    public void recalculateEnergyUsage() {
        double newIdleDrain;
        this.idleDrain = newIdleDrain = 64.0;
        if (this.channel != null) {
            this.channel.getProxy().setIdlePowerUsage(this.idleDrain);
        }
    }

    public boolean insertPattern(ItemStack patternStack) {
        for (EFabricatorPatternBus patternBus : this.getPatternBuses()) {
            AppEngInternalInventory patternInv = patternBus.getPatterns();
            for (int i = 0; i < patternInv.getSlots(); ++i) {
                if (!patternInv.getStackInSlot(i).func_190926_b()) continue;
                patternInv.setStackInSlot(i, patternStack.func_77946_l());
                return true;
            }
        }
        return false;
    }

    public boolean offerWork(EFabricatorWorker.CraftWork work) {
        boolean success = false;
        for (EFabricatorWorker fabricatorWorker : this.getWorkers()) {
            if (fabricatorWorker.isFull()) continue;
            fabricatorWorker.offerWork(work);
            success = true;
            break;
        }
        if (success && this.activeCooling && !this.speedupApplied) {
            this.convertOverflowParallelismToWorkDelay(this.parallelism);
        }
        return success;
    }

    public boolean isQueueFull() {
        for (EFabricatorWorker worker : this.getWorkers()) {
            if (worker.isFull()) continue;
            return false;
        }
        return true;
    }

    public boolean hasWork() {
        for (EFabricatorWorker eFabricatorWorker : this.getWorkers()) {
            if (!eFabricatorWorker.hasWork()) continue;
            return true;
        }
        return false;
    }

    public synchronized void updateGUIDataPacket() {
        this.guiDataDirty = true;
    }

    public PktEFabricatorGUIData getGuiDataPacket() {
        if (this.guiDataDirty || this.guiDataPacket == null) {
            this.guiDataPacket = new PktEFabricatorGUIData(this);
            this.guiDataDirty = false;
        }
        return this.guiDataPacket;
    }

    public long getTotalCrafted() {
        return this.totalCrafted;
    }

    public double getEnergyConsumePerTick() {
        return this.idleDrain;
    }

    public int getLength() {
        return this.length;
    }

    public Levels getLevel() {
        if (this.parentController == BlockEFabricatorController.L4) {
            return Levels.L4;
        }
        if (this.parentController == BlockEFabricatorController.L6) {
            return Levels.L6;
        }
        if (this.parentController == BlockEFabricatorController.L9) {
            return Levels.L9;
        }
        NovaEngineeringCore.log.warn("Invalid EFabricator controller level: {}", (Object)this.parentController);
        return Levels.L4;
    }

    public EFabricatorMEChannel getChannel() {
        return this.channel;
    }

    public List<EFabricatorWorker> getWorkers() {
        return this.parts.getParts(EFabricatorWorker.class);
    }

    public List<EFabricatorPatternBus> getPatternBuses() {
        return this.parts.getParts(EFabricatorPatternBus.class);
    }

    public List<EFabricatorParallelProc> getParallelProcs() {
        return this.parts.getParts(EFabricatorParallelProc.class);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getAvailableParallelism() {
        return Math.max(0, this.parallelism - this.consumedParallelism);
    }

    public ItemList getOutputBuffer() {
        return this.outputBuffer;
    }

    public boolean isOverclocked() {
        return this.overclocked;
    }

    public EFabricatorController setOverclocked(boolean overclocked) {
        this.overclocked = overclocked;
        this.updateParallelism();
        this.updateGUIDataPacket();
        return this;
    }

    public boolean isActiveCooling() {
        return this.activeCooling;
    }

    public EFabricatorController setActiveCooling(boolean activeCooling) {
        this.activeCooling = activeCooling;
        this.updateParallelism();
        this.updateWorkDelay();
        this.updateGUIDataPacket();
        return this;
    }

    public int getEnergyStored() {
        return this.getWorkers().stream().mapToInt(EFabricatorWorker::getEnergyCache).sum();
    }

    public int getCoolantCache() {
        return this.coolantCache;
    }

    public void consumeCoolant(int amount) {
        this.coolantCache -= amount;
    }

    public int getCoolantInputCap() {
        int total = 0;
        for (IFluidHandler handler : this.coolantInputHandlers) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                if ((total += Math.min(property.getCapacity(), Integer.MAX_VALUE - total)) != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            }
        }
        return total;
    }

    public int getCoolantInputFluids() {
        int total = 0;
        for (IFluidHandler handler : this.coolantInputHandlers) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                FluidStack contents = property.getContents();
                if (contents == null || contents.amount == 0 || MachineCoolants.INSTANCE.getCoolant(contents.getFluid()) == null || (total += Math.min(contents.amount, Integer.MAX_VALUE - total)) != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            }
        }
        return total;
    }

    public int getCoolantOutputCap() {
        int total = 0;
        for (IFluidHandler handler : this.coolantOutputHandlers) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                if ((total += Math.min(property.getCapacity(), Integer.MAX_VALUE - total)) != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            }
        }
        return total;
    }

    public int getCoolantOutputFluids() {
        int total = 0;
        for (IFluidHandler handler : this.coolantOutputHandlers) {
            for (IFluidTankProperties property : handler.getTankProperties()) {
                FluidStack contents = property.getContents();
                if (contents == null || contents.amount == 0 || (total += Math.min(contents.amount, Integer.MAX_VALUE - total)) != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            }
        }
        return total;
    }

    @Override
    protected Class<? extends Block> getControllerBlock() {
        return BlockEFabricatorController.class;
    }

    @Override
    public void func_145829_t() {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ClientProxy.clientScheduler.addRunnable(() -> {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
            this.notifyStructureFormedState(this.isStructureFormed());
        }, 0);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        ClientProxy.clientScheduler.addRunnable(() -> {
            BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
            this.notifyStructureFormedState(this.isStructureFormed());
        }, 0);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        boolean prevLoaded = this.loaded;
        this.loaded = false;
        super.readCustomNBT(compound);
        this.totalCrafted = compound.func_74763_f("totalCrafted");
        this.overclocked = compound.func_74767_n("overclock");
        this.activeCooling = compound.func_74767_n("activeCooling");
        this.coolantCache = compound.func_74762_e("coolantCache");
        this.outputBuffer = new ItemList();
        NBTTagList list = compound.func_150295_c("outputBuffer", 10);
        IntStream.range(0, list.func_74745_c()).mapToObj(i -> (IAEItemStack)this.itemChannel.createStack((Object)ItemStackUtils.readNBTOversize((NBTTagCompound)list.func_150305_b(i)))).forEach(arg_0 -> ((ItemList)this.outputBuffer).add(arg_0));
        this.loaded = prevLoaded;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientProxy.clientScheduler.addRunnable(() -> {
                BlockModelHider.hideOrShowBlocks(HIDE_POS_LIST, this);
                this.notifyStructureFormedState(this.isStructureFormed());
            }, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74772_a("totalCrafted", this.totalCrafted);
        compound.func_74757_a("overclock", this.overclocked);
        compound.func_74757_a("activeCooling", this.activeCooling);
        compound.func_74768_a("coolantCache", this.coolantCache);
        NBTTagList list = new NBTTagList();
        ItemList itemList = this.outputBuffer;
        synchronized (itemList) {
            for (IAEItemStack stack : this.outputBuffer) {
                list.func_74742_a((NBTBase)ItemStackUtils.writeNBTOversize((ItemStack)stack.getCachedItemStack(stack.getStackSize())));
            }
        }
        compound.func_74782_a("outputBuffer", (NBTBase)list);
    }

    @Override
    protected void readMachineNBT(NBTTagCompound compound) {
        super.readMachineNBT(compound);
        if (compound.func_74764_b("parentMachine")) {
            ResourceLocation rl = new ResourceLocation(compound.func_74779_i("parentMachine"));
            this.parentMachine = MachineRegistry.getRegistry().getMachine(rl);
            if (this.parentMachine != null) {
                this.parentController = BlockEFabricatorController.REGISTRY.get(new ResourceLocation("novaeng_core", this.parentMachine.getRegistryName().func_110623_a()));
            } else {
                ModularMachinery.log.info("Couldn't find machine named " + rl + " for controller at " + this.func_174877_v());
            }
        }
    }
}

