/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile.ecotech;

import github.kasuminova.mmce.common.world.MMWorldEventListener;
import github.kasuminova.mmce.common.world.MachineComponentManager;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.block.prop.FacingProp;
import github.kasuminova.novaeng.common.tile.TileCustomController;
import github.kasuminova.novaeng.common.tile.ecotech.AbstractEPart;
import github.kasuminova.novaeng.common.tile.ecotech.EPart;
import github.kasuminova.novaeng.common.util.EPartMap;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public abstract class EPartController<P extends EPart<?>>
extends TileCustomController {
    protected final EPartMap<P> parts = new EPartMap();
    protected boolean assembled = false;

    public void doControllerTick() {
        if (!this.doStructureCheck() || !this.isStructureFormed()) {
            this.disassemble();
            return;
        }
        this.assemble();
        if (this.onSyncTick()) {
            this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(this::onAsyncTick, this.timeRecorder.usedTimeAvg());
        }
    }

    protected abstract boolean onSyncTick();

    protected void onAsyncTick() {
    }

    protected void updateComponents() {
        super.updateComponents();
        this.clearParts();
        this.foundPattern.getTileBlocksArray().forEach((pos, info) -> {
            BlockPos realPos = this.func_174877_v().func_177971_a((Vec3i)pos);
            if (!this.func_145831_w().func_175667_e(realPos)) {
                return;
            }
            TileEntity te = this.func_145831_w().func_175625_s(realPos);
            if (!(te instanceof AbstractEPart)) {
                return;
            }
            EPart part = (EPart)te;
            part.setController(this);
            this.parts.addPart(part);
            this.onAddPart(part);
        });
    }

    protected abstract void onAddPart(P var1);

    protected boolean canCheckStructure() {
        if (this.lastStructureCheckTick == -1 || this.isStructureFormed() && !this.assembled) {
            return true;
        }
        if (this.ticksExisted % 40 == 0) {
            return true;
        }
        if (this.isStructureFormed()) {
            BlockPos pos = this.func_174877_v();
            BlockPos min = this.foundPattern.getMin();
            BlockPos max = this.foundPattern.getMax();
            return MMWorldEventListener.INSTANCE.isAreaChanged(this.func_145831_w(), pos.func_177971_a((Vec3i)min), pos.func_177971_a((Vec3i)max));
        }
        return this.ticksExisted % Math.min(structureCheckDelay + this.structureCheckCounter * 5, maxStructureCheckDelay) == 0;
    }

    protected void assemble() {
        if (this.assembled) {
            return;
        }
        this.assembled = true;
        this.parts.assemble(this);
    }

    protected void disassemble() {
        if (!this.assembled) {
            return;
        }
        this.assembled = false;
        this.parts.disassemble();
    }

    protected void clearParts() {
        this.parts.clear();
    }

    public EPartMap<P> getParts() {
        return this.parts;
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    protected void checkRotation() {
        if (this.controllerRotation != null) {
            return;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (this.getControllerBlock().isInstance(state.func_177230_c())) {
            this.controllerRotation = (EnumFacing)state.func_177229_b(FacingProp.HORIZONTALS);
        } else {
            NovaEngineeringCore.log.warn("Invalid EPartController block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    protected abstract Class<? extends Block> getControllerBlock();

    public void func_145829_t() {
        this.field_145846_f = false;
        this.loaded = true;
    }

    public void func_145843_s() {
        this.field_145846_f = true;
        this.loaded = false;
        this.foundComponents.forEach((te, component) -> MachineComponentManager.INSTANCE.removeOwner(te, (TileMultiblockMachineController)this));
        this.disassemble();
    }

    public void onLoad() {
        this.loaded = true;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.disassemble();
    }

    public boolean isWorking() {
        return this.assembled;
    }
}

