/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.gui.GuiModularServerAssembler;
import github.kasuminova.novaeng.common.container.ContainerModularServerAssembler;
import github.kasuminova.novaeng.common.hypernet.computer.ModularServer;
import github.kasuminova.novaeng.common.tile.TileCustomController;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;

public class TileModularServerAssembler
extends TileCustomController {
    protected IOInventory serverInventory;
    protected ModularServer server = null;
    protected Set<ContainerModularServerAssembler> openedContainer = new HashSet<ContainerModularServerAssembler>();

    public TileModularServerAssembler() {
        this.serverInventory = (IOInventory)new IOInventory((TileEntitySynchronized)this, new int[0], new int[0]).setMiscSlots(new int[]{0});
        this.serverInventory.setStackLimit(1, new int[]{0});
        this.serverInventory.setListener(this::onServerInventoryUpdate);
        this.parentMachine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", "modular_server_assembler"));
    }

    public void doControllerTick() {
    }

    protected void onServerInventoryUpdate(int changedSlot) {
        ItemStack stackInSlot = this.serverInventory.getStackInSlot(changedSlot);
        if (stackInSlot.func_190926_b()) {
            this.server = null;
            this.openedContainer.forEach(ContainerModularServerAssembler::reInitSlots);
            this.notifyClientGUIInventoryUpdate();
            return;
        }
        if (this.server == null || this.server.requiresUpdate(stackInSlot)) {
            if (this.server != null) {
                this.server.invalidate();
            }
            this.server = new ModularServer((TileEntitySynchronized)this, stackInSlot);
            if (stackInSlot.func_77978_p() != null) {
                this.server.readFullInvNBT(stackInSlot.func_77978_p().func_74775_l("server"));
            } else {
                this.server.initInv();
            }
            this.server.setOnServerInvChangedListener(this::onServerInternalInventoryUpdate);
            this.openedContainer.forEach(ContainerModularServerAssembler::reInitSlots);
        }
        if (this.server != null) {
            this.server.initModules();
        }
        this.notifyClientGUIInventoryUpdate();
    }

    protected void notifyClientGUIInventoryUpdate() {
        GuiModularServerAssembler assemblerGUI;
        GuiScreen currentScreen;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (currentScreen = Minecraft.func_71410_x().field_71462_r) instanceof GuiModularServerAssembler && (assemblerGUI = (GuiModularServerAssembler)currentScreen).getAssembler() == this) {
            assemblerGUI.onServerInventoryUpdate();
        }
    }

    protected void onServerInternalInventoryUpdate(ModularServer server) {
        ItemStack copied;
        NBTTagCompound tag;
        ItemStack stackInSlot = this.serverInventory.getStackInSlot(0);
        if (stackInSlot.func_190926_b() || server.requiresUpdate(stackInSlot)) {
            NovaEngineeringCore.log.warn("Server stack is not equals the cachedStack or it's empty! Assembler world: " + this.func_145831_w() + ", pos: " + MiscUtils.posToString((Vec3i)this.func_174877_v()));
        }
        if ((tag = (copied = stackInSlot.func_77946_l()).func_77978_p()) == null) {
            tag = new NBTTagCompound();
            copied.func_77982_d(tag);
        }
        tag.func_74782_a("server", (NBTBase)server.writeNBT());
        server.setCachedStack(copied);
        this.serverInventory.setStackInSlot(0, copied);
    }

    public ModularServer getServer() {
        return this.server;
    }

    public IOInventory getServerInventory() {
        return this.serverInventory;
    }

    public void addContainer(ContainerModularServerAssembler container) {
        this.openedContainer.add(container);
    }

    public void removeContainer(ContainerModularServerAssembler container) {
        this.openedContainer.remove((Object)container);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (compound.func_74764_b("serverInv")) {
            this.serverInventory = IOInventory.deserialize((TileEntitySynchronized)this, (NBTTagCompound)compound.func_74775_l("serverInv"));
            this.serverInventory.setListener(this::onServerInventoryUpdate);
            this.onServerInventoryUpdate(0);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("serverInv", (NBTBase)this.serverInventory.writeNBT());
    }

    public void func_145843_s() {
        this.serverInventory.clear();
        if (this.server != null) {
            this.server.invalidate();
        }
        super.func_145843_s();
    }

    public boolean isWorking() {
        return this.controllerStatus.isCrafting();
    }
}

