/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile;

import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.block.BlockHyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.HyperNetTerminal;
import github.kasuminova.novaeng.common.tile.TileCustomController;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.block.BlockController;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.helper.ProcessingComponent;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.IEnergyHandlerAsync;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileHyperNetTerminal
extends TileCustomController {
    public static final int NETWORK_CONNECT_CARD_SLOT = 0;
    public static final int ENERGY_USAGE = 2000;
    private final HyperNetTerminal nodeProxy = new HyperNetTerminal(this);
    private final List<IEnergyHandlerAsync> energyHandlers = new ArrayList<IEnergyHandlerAsync>();
    private IOInventory cardInventory = (IOInventory)new IOInventory((TileEntitySynchronized)this, new int[0], new int[0]).setMiscSlots(new int[]{0});

    public TileHyperNetTerminal() {
        this.cardInventory.setStackLimit(1, new int[]{0});
        this.parentMachine = MachineRegistry.getRegistry().getMachine(new ResourceLocation("modularmachinery", "hypernet_terminal"));
    }

    public void doControllerTick() {
        this.tickExecutor = ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
            if (!this.doStructureCheck() || !this.isStructureFormed()) {
                return;
            }
            this.onMachineTick(Phase.START);
            if (this.consumeEnergy()) {
                this.nodeProxy.onMachineTick();
            } else {
                this.nodeProxy.disconnect();
            }
            this.onMachineTick(Phase.END);
        }, this.usedTimeAvg());
    }

    public boolean consumeEnergy() {
        if (this.energyHandlers.isEmpty()) {
            this.controllerStatus = CraftingStatus.failure((String)"component.missing.modularmachinery.energy.input");
            return false;
        }
        int energyUsage = this.nodeProxy.isConnected() ? 2000 : 200;
        for (IEnergyHandlerAsync handler : this.energyHandlers) {
            if (!handler.extractEnergy((long)energyUsage)) continue;
            this.controllerStatus = CraftingStatus.working();
            return true;
        }
        this.controllerStatus = CraftingStatus.failure((String)"craftcheck.failure.energy.input");
        return false;
    }

    protected void updateComponents() {
        super.updateComponents();
        this.energyHandlers.clear();
        for (ProcessingComponent foundComponent : this.foundComponents.values()) {
            Object providedComponent;
            if (foundComponent.getComponent().getIOType() != IOType.INPUT || !((providedComponent = foundComponent.getProvidedComponent()) instanceof IEnergyHandlerAsync)) continue;
            IEnergyHandlerAsync iEnergyHandlerAsync = (IEnergyHandlerAsync)providedComponent;
            this.energyHandlers.add(iEnergyHandlerAsync);
        }
    }

    protected void checkRotation() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockHyperNetTerminal) {
            this.controllerRotation = (EnumFacing)state.func_177229_b((IProperty)BlockController.FACING);
        } else {
            NovaEngineeringCore.log.warn("Invalid controller block at " + this.func_174877_v() + " !");
            this.controllerRotation = EnumFacing.NORTH;
        }
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.nodeProxy.readNBT();
        if (compound.func_74764_b("cardInventory")) {
            this.cardInventory = IOInventory.deserialize((TileEntitySynchronized)this, (NBTTagCompound)compound.func_74775_l("cardInventory"));
        }
        if (compound.func_74764_b("controllerStatus")) {
            this.controllerStatus = CraftingStatus.deserialize((NBTTagCompound)compound.func_74775_l("controllerStatus"));
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        this.nodeProxy.writeNBT();
        super.writeCustomNBT(compound);
        compound.func_74782_a("cardInventory", (NBTBase)this.cardInventory.writeNBT());
        compound.func_74782_a("controllerStatus", (NBTBase)this.controllerStatus.serialize());
    }

    public IOInventory getCardInventory() {
        return this.cardInventory;
    }

    public HyperNetTerminal getNodeProxy() {
        return this.nodeProxy;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.cardInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isWorking() {
        return this.controllerStatus.isCrafting();
    }
}

