/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.tile;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import github.kasuminova.novaeng.common.tile.TileCustomController;
import hellfirepvp.modularmachinery.ModularMachinery;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class TileCustomControllerME
extends TileCustomController
implements IActionHost,
IGridProxyable,
IGridTickable {
    protected final AENetworkProxy proxy = new AENetworkProxy((IGridProxyable)this, "aeProxy", this.getVisualItemStack(), true);
    protected final IActionSource source = new MachineSource((IActionHost)this);

    public TileCustomControllerME() {
        this.proxy.setIdlePowerUsage(0.0);
        this.proxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public abstract ItemStack getVisualItemStack();

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        if (FMLCommonHandler.instance().getSide().isServer()) {
            this.proxy.readFromNBT(compound);
        }
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.proxy.writeToNBT(compound);
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkChannelsChanged change) {
        this.notifyNeighbors();
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange change) {
        this.notifyNeighbors();
    }

    private void notifyNeighbors() {
        if (this.proxy.isActive()) {
            try {
                this.proxy.getTick().wakeDevice(this.proxy.getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
            Platform.notifyBlocksOfNeighbors((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        }
    }

    public void gridChanged() {
    }

    @Nonnull
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    @Nonnull
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Nonnull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation dir) {
        return this.proxy.getNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.func_145831_w().func_175655_b(this.func_174877_v(), true);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.proxy.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.proxy.invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.func_145831_w().field_72995_K) {
            ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> ((AENetworkProxy)this.proxy).onReady());
        }
    }
}

