/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.registry;

import com.google.common.base.Preconditions;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import github.kasuminova.novaeng.common.hypernet.computer.module.base.ServerModuleBase;
import github.kasuminova.novaeng.common.item.ItemServerModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.server.module.ServerModuleRegistry")
public class ServerModuleRegistry {
    private static final Map<String, ServerModuleBase<?>> MODULE_BASE_REGISTRY = new HashMap();
    private static final Map<Item, ItemModuleRegistry> MODULE_ITEM_REGISTRY = new HashMap<Item, ItemModuleRegistry>();

    @ZenMethod
    public static void registryModuleBase(ServerModuleBase<?> module) {
        Preconditions.checkNotNull(module);
        MODULE_BASE_REGISTRY.put(module.getRegistryName(), module);
    }

    public static void registryItemStackMatch(ItemStack match, ServerModuleBase<?> module) {
        Preconditions.checkNotNull((Object)match);
        Preconditions.checkNotNull(module);
        MODULE_ITEM_REGISTRY.computeIfAbsent(match.func_77973_b(), v -> new ItemModuleRegistry(module)).addMatch(match);
    }

    @ZenMethod
    public static void registryItemStackMatch(IItemStack matchCT, ServerModuleBase<?> module) {
        ServerModuleRegistry.registryItemStackMatch(CraftTweakerMC.getItemStack((IItemStack)matchCT), module);
    }

    @ZenMethod
    public static ServerModuleBase<?> getModule(String moduleRegistryName) {
        return MODULE_BASE_REGISTRY.get(moduleRegistryName);
    }

    public static ServerModuleBase<?> getModule(ItemStack toMatch) {
        ItemServerModule itemServerModule;
        ServerModuleBase<?> boundedModule;
        Item item = toMatch.func_77973_b();
        if (item instanceof ItemServerModule && (boundedModule = (itemServerModule = (ItemServerModule)item).getBoundedModule()) != null) {
            return boundedModule;
        }
        ItemModuleRegistry itemModuleRegistry = MODULE_ITEM_REGISTRY.get(item);
        return itemModuleRegistry == null ? null : itemModuleRegistry.getModule(toMatch);
    }

    public static class ItemModuleRegistry {
        private final List<ItemStack> matches = new ArrayList<ItemStack>();
        private final ServerModuleBase<?> module;

        public ItemModuleRegistry(ServerModuleBase<?> module) {
            this.module = module;
        }

        public ItemModuleRegistry addMatch(ItemStack stack) {
            this.matches.add(stack);
            return this;
        }

        public ServerModuleBase<?> getModule(ItemStack stack) {
            for (ItemStack match : this.matches) {
                if (!match.func_77969_a(stack)) continue;
                return this.module;
            }
            return null;
        }
    }
}

