/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.registry;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.client.renderer.EStorageEnergyCellItemRenderer;
import github.kasuminova.novaeng.common.item.estorage.EStorageCellFluid;
import github.kasuminova.novaeng.common.item.estorage.EStorageCellItem;
import github.kasuminova.novaeng.common.item.estorage.ItemBlockEStorageEnergyCell;
import github.kasuminova.novaeng.common.registry.GenericRegistryPrimer;
import hellfirepvp.modularmachinery.common.item.ItemDynamicColor;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RegistryItems {
    public static final List<Item> ITEMS_TO_REGISTER = new LinkedList<Item>();
    public static final List<Item> ITEMS_TO_REGISTER_CT = new LinkedList<Item>();
    public static final Map<String, Item> CUSTOM_MODEL_ITEMS_TO_REGISTER_CT = new LinkedHashMap<String, Item>();
    public static final List<Item> ITEM_MODELS_TO_REGISTER = new LinkedList<Item>();
    public static final Map<String, Item> ITEM_CUSTOM_MODELS_TO_REGISTER = new LinkedHashMap<String, Item>();

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        GenericRegistryPrimer.INSTANCE.wipe(event.getGenericType());
        ITEMS_TO_REGISTER.add((Item)EStorageCellItem.LEVEL_A);
        ITEMS_TO_REGISTER.add((Item)EStorageCellItem.LEVEL_B);
        ITEMS_TO_REGISTER.add((Item)EStorageCellItem.LEVEL_C);
        ITEMS_TO_REGISTER.add((Item)EStorageCellFluid.LEVEL_A);
        ITEMS_TO_REGISTER.add((Item)EStorageCellFluid.LEVEL_B);
        ITEMS_TO_REGISTER.add((Item)EStorageCellFluid.LEVEL_C);
        RegistryItems.registerItems();
        GenericRegistryPrimer.INSTANCE.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    public static void registerItems() {
        ITEMS_TO_REGISTER.forEach(RegistryItems::registerItem);
        ITEMS_TO_REGISTER.clear();
        ITEMS_TO_REGISTER_CT.forEach(RegistryItems::registerItem);
        ITEMS_TO_REGISTER_CT.clear();
        CUSTOM_MODEL_ITEMS_TO_REGISTER_CT.forEach((path, item) -> RegistryItems.registerItem(item, path));
        CUSTOM_MODEL_ITEMS_TO_REGISTER_CT.clear();
    }

    public static void registerItemModels() {
        if (FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        ITEM_MODELS_TO_REGISTER.forEach(RegistryItems::registerItemModel);
        ITEM_MODELS_TO_REGISTER.clear();
        ITEM_CUSTOM_MODELS_TO_REGISTER.forEach((path, item) -> RegistryItems.registerItemModel(item, path));
        ITEM_CUSTOM_MODELS_TO_REGISTER.clear();
        RegistryItems.setMeshDef();
    }

    @SideOnly(value=Side.CLIENT)
    private static void setMeshDef() {
        ModelLoader.setCustomMeshDefinition((Item)ItemBlockEStorageEnergyCell.L4, (ItemMeshDefinition)new EStorageEnergyCellItemRenderer(ItemBlockEStorageEnergyCell.L4, "l4"));
        ModelLoader.setCustomMeshDefinition((Item)ItemBlockEStorageEnergyCell.L6, (ItemMeshDefinition)new EStorageEnergyCellItemRenderer(ItemBlockEStorageEnergyCell.L6, "l6"));
        ModelLoader.setCustomMeshDefinition((Item)ItemBlockEStorageEnergyCell.L9, (ItemMeshDefinition)new EStorageEnergyCellItemRenderer(ItemBlockEStorageEnergyCell.L9, "l9"));
    }

    public static <T extends Item> T registerItem(T item) {
        ITEM_MODELS_TO_REGISTER.add(item);
        GenericRegistryPrimer.INSTANCE.register(item);
        if (item instanceof ItemDynamicColor) {
            hellfirepvp.modularmachinery.common.registry.RegistryItems.pendingDynamicColorItems.add((ItemDynamicColor)item);
        }
        return item;
    }

    public static <T extends Item> T registerItem(T item, String modelPath) {
        ITEM_CUSTOM_MODELS_TO_REGISTER.put(modelPath, item);
        GenericRegistryPrimer.INSTANCE.register(item);
        if (item instanceof ItemDynamicColor) {
            hellfirepvp.modularmachinery.common.registry.RegistryItems.pendingDynamicColorItems.add((ItemDynamicColor)item);
        }
        return item;
    }

    public static void registerItemModel(Item item) {
        NonNullList list = NonNullList.func_191196_a();
        ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
        item.func_150895_a(Objects.requireNonNull(item.func_77640_w()), list);
        if (list.isEmpty()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(registryName, "inventory"));
        } else {
            list.forEach(stack -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(registryName, "inventory")));
        }
        NovaEngineeringCore.log.debug("REGISTERED ITEM MODEL: {}", (Object)registryName);
    }

    public static void registerItemModel(Item item, String modelPath) {
        NonNullList list = NonNullList.func_191196_a();
        ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
        ResourceLocation modelLocation = new ResourceLocation(registryName.func_110624_b(), modelPath);
        item.func_150895_a(Objects.requireNonNull(item.func_77640_w()), list);
        if (list.isEmpty()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(modelLocation, "inventory"));
        } else {
            list.forEach(stack -> ModelLoader.setCustomModelResourceLocation((Item)item, (int)stack.func_77952_i(), (ModelResourceLocation)new ModelResourceLocation(modelLocation, "inventory")));
        }
        NovaEngineeringCore.log.debug("REGISTERED ITEM MODEL: {}", (Object)modelLocation);
    }
}

