/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.registry;

import github.kasuminova.novaeng.common.block.BlockAngel;
import github.kasuminova.novaeng.common.block.BlockGeocentricDrillController;
import github.kasuminova.novaeng.common.block.BlockHyperNetTerminal;
import github.kasuminova.novaeng.common.block.BlockModularServerAssembler;
import github.kasuminova.novaeng.common.block.BlockSingularityCoreController;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorCasing;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorController;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorMEChannel;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorParallelProc;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorPatternBus;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorVent;
import github.kasuminova.novaeng.common.block.ecotech.efabricator.BlockEFabricatorWorker;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageCasing;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageCellDrive;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageController;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageEnergyCell;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageMEChannel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.BlockEStorageVent;
import github.kasuminova.novaeng.common.item.ItemBlockAngel;
import github.kasuminova.novaeng.common.item.ItemBlockME;
import github.kasuminova.novaeng.common.item.efabriactor.ItemEFabricatorMEChannel;
import github.kasuminova.novaeng.common.item.efabriactor.ItemEFabricatorParallelProc;
import github.kasuminova.novaeng.common.item.efabriactor.ItemEFabricatorPatternBus;
import github.kasuminova.novaeng.common.item.efabriactor.ItemEFabricatorWorker;
import github.kasuminova.novaeng.common.registry.GenericRegistryPrimer;
import github.kasuminova.novaeng.common.registry.RegistryItems;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import github.kasuminova.novaeng.common.tile.TileModularServerAssembler;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorMEChannel;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorParallelProc;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorPatternBus;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorTail;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorWorker;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageEnergyCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageMEChannel;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import github.kasuminova.novaeng.common.tile.machine.SingularityCore;
import hellfirepvp.modularmachinery.common.block.BlockCustomName;
import hellfirepvp.modularmachinery.common.block.BlockDynamicColor;
import hellfirepvp.modularmachinery.common.block.BlockMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockCustomName;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponent;
import hellfirepvp.modularmachinery.common.item.ItemBlockMachineComponentCustomName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class RegistryBlocks {
    public static final List<Block> BLOCK_MODEL_TO_REGISTER = new ArrayList<Block>();

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        GenericRegistryPrimer.INSTANCE.wipe(event.getGenericType());
        RegistryBlocks.registerBlocks();
        RegistryBlocks.registerTileEntities();
        GenericRegistryPrimer.INSTANCE.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    public static void registerBlocks() {
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockHyperNetTerminal.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockModularServerAssembler.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister(new ItemBlockAngel(RegistryBlocks.registerBlock(BlockAngel.INSTANCE)));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockSingularityCoreController.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockGeocentricDrillController.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageController.L4));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageController.L6));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageController.L9));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageEnergyCell.L4));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageEnergyCell.L6));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageEnergyCell.L9));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEStorageCellDrive.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister(new ItemBlockME((Block)RegistryBlocks.registerBlock(BlockEStorageMEChannel.INSTANCE)));
        RegistryBlocks.prepareItemBlockRegister(RegistryBlocks.registerBlock(BlockEStorageVent.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister(RegistryBlocks.registerBlock(BlockEStorageCasing.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEFabricatorController.L4));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEFabricatorController.L6));
        RegistryBlocks.prepareItemBlockRegister((Block)RegistryBlocks.registerBlock(BlockEFabricatorController.L9));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorParallelProc(RegistryBlocks.registerBlock(BlockEFabricatorParallelProc.L4)));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorParallelProc(RegistryBlocks.registerBlock(BlockEFabricatorParallelProc.L6)));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorParallelProc(RegistryBlocks.registerBlock(BlockEFabricatorParallelProc.L9)));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorMEChannel((Block)RegistryBlocks.registerBlock(BlockEFabricatorMEChannel.INSTANCE)));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorPatternBus((Block)RegistryBlocks.registerBlock(BlockEFabricatorPatternBus.INSTANCE)));
        RegistryBlocks.prepareItemBlockRegister(new ItemEFabricatorWorker((Block)RegistryBlocks.registerBlock(BlockEFabricatorWorker.INSTANCE)));
        RegistryBlocks.prepareItemBlockRegister(RegistryBlocks.registerBlock(BlockEFabricatorVent.INSTANCE));
        RegistryBlocks.prepareItemBlockRegister(RegistryBlocks.registerBlock(BlockEFabricatorCasing.INSTANCE));
    }

    public static void registerTileEntities() {
        RegistryBlocks.registerTileEntity(TileHyperNetTerminal.class, "hypernet_terminal");
        RegistryBlocks.registerTileEntity(TileModularServerAssembler.class, "modular_server_assembler");
        RegistryBlocks.registerTileEntity(SingularityCore.class, "singularity_core");
        RegistryBlocks.registerTileEntity(GeocentricDrillController.class, "geocentric_drill_controller");
        RegistryBlocks.registerTileEntity(EStorageController.class, "estorage_controller");
        RegistryBlocks.registerTileEntity(EStorageEnergyCell.class, "estorage_energy_cell");
        RegistryBlocks.registerTileEntity(EStorageCellDrive.class, "estorage_cell_drive");
        RegistryBlocks.registerTileEntity(EStorageMEChannel.class, "estorage_me_channel");
        RegistryBlocks.registerTileEntity(EFabricatorController.class, "efabricator_controller");
        RegistryBlocks.registerTileEntity(EFabricatorParallelProc.class, "efabricator_parallel_proc");
        RegistryBlocks.registerTileEntity(EFabricatorTail.class, "efabricator_tail");
        RegistryBlocks.registerTileEntity(EFabricatorPatternBus.class, "efabricator_pattern_bus");
        RegistryBlocks.registerTileEntity(EFabricatorWorker.class, "efabricator_worker");
        RegistryBlocks.registerTileEntity(EFabricatorMEChannel.class, "efabricator_me_channel");
    }

    public static void registerBlockModels() {
        BLOCK_MODEL_TO_REGISTER.forEach(RegistryBlocks::registerBlockModel);
        BLOCK_MODEL_TO_REGISTER.clear();
    }

    public static void registerTileEntity(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (ResourceLocation)new ResourceLocation("novaeng_core", name));
    }

    public static <T extends Block> T registerBlock(T block) {
        BLOCK_MODEL_TO_REGISTER.add(block);
        GenericRegistryPrimer.INSTANCE.register(block);
        if (block instanceof BlockDynamicColor) {
            hellfirepvp.modularmachinery.common.registry.RegistryBlocks.pendingIBlockColorBlocks.add((BlockDynamicColor)block);
        }
        return block;
    }

    public static ItemBlock prepareItemBlockRegister(Block block) {
        if (block instanceof BlockMachineComponent) {
            if (block instanceof BlockCustomName) {
                return RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponentCustomName(block));
            }
            return RegistryBlocks.prepareItemBlockRegister(new ItemBlockMachineComponent(block));
        }
        if (block instanceof BlockCustomName) {
            return RegistryBlocks.prepareItemBlockRegister(new ItemBlockCustomName(block));
        }
        return RegistryBlocks.prepareItemBlockRegister(new ItemBlock(block));
    }

    public static <T extends ItemBlock> T prepareItemBlockRegister(T item) {
        Block block = item.func_179223_d();
        ResourceLocation registryName = Objects.requireNonNull(block.getRegistryName());
        String translationKey = block.func_149739_a();
        ((Item)item.setRegistryName(registryName)).func_77655_b(translationKey);
        RegistryItems.ITEMS_TO_REGISTER.add((Item)item);
        return item;
    }

    public static void registerBlockModel(Block block) {
        Item item = Item.func_150898_a((Block)block);
        ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{registryName});
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(registryName, "inventory"));
    }
}

