/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.registry;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GenericRegistryPrimer {
    public static final GenericRegistryPrimer INSTANCE = new GenericRegistryPrimer();
    private final Map<Type, List<IForgeRegistryEntry<?>>> primed = new HashMap();

    private GenericRegistryPrimer() {
    }

    public <V extends IForgeRegistryEntry<V>> V register(V entry) {
        Class type = entry.getRegistryType();
        List entries = this.primed.computeIfAbsent(type, k -> new LinkedList());
        entries.add(entry);
        return entry;
    }

    public <T extends IForgeRegistryEntry<T>> List<?> getEntries(Class<T> type) {
        return this.primed.get(type);
    }

    public void wipe(Type type) {
        this.primed.remove(type);
    }

    public <T extends IForgeRegistryEntry<T>> void fillRegistry(Class<T> registrySuperType, IForgeRegistry<T> forgeRegistry) {
        List<?> entries = this.getEntries(registrySuperType);
        if (entries != null) {
            entries.forEach(e -> forgeRegistry.register((IForgeRegistryEntry)e));
        }
    }
}

