/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.profiler;

import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class TEUpdatePacketProfiler {
    public static final ConcurrentHashMap<Class<?>, Tuple<Long, Long>> TE_UPDATE_PACKET_TOTAL_SIZE = new ConcurrentHashMap();

    public static void onPacketReceived(SPacketUpdateTileEntity packet, int packetSize) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = packet.func_179823_a();
        if (world.func_175667_e(pos)) {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return;
            }
            TE_UPDATE_PACKET_TOTAL_SIZE.compute(te.getClass(), (key, value) -> value == null ? new Tuple((Object)1L, (Object)packetSize) : new Tuple((Object)((Long)value.func_76341_a() + 1L), (Object)((Long)value.func_76340_b() + (long)packetSize)));
        }
    }

    public static List<String> getProfilerMessages(int limit) {
        if (limit <= 0) {
            return Collections.emptyList();
        }
        LinkedList<String> messages = new LinkedList<String>();
        List teSorted = TE_UPDATE_PACKET_TOTAL_SIZE.entrySet().stream().sorted((o1, o2) -> Long.compare((Long)((Tuple)o2.getValue()).func_76340_b(), (Long)((Tuple)o1.getValue()).func_76340_b())).limit(limit).collect(Collectors.toList());
        messages.add("SPacketUpdateTileEntity stat:");
        for (Map.Entry entry : teSorted) {
            Class tClass = (Class)entry.getKey();
            long packetTotalAmount = (Long)((Tuple)entry.getValue()).func_76341_a();
            long packetTotalSize = (Long)((Tuple)entry.getValue()).func_76340_b();
            messages.add(String.format("TE Class: %s", TextFormatting.BLUE + tClass.getName() + TextFormatting.WHITE));
            messages.add(String.format("Amt: %s, Size Total: %s, Size Avg: %s", TextFormatting.GOLD + MiscUtils.formatDecimal((double)packetTotalAmount) + TextFormatting.WHITE, TextFormatting.RED + MiscUtils.formatNumber((long)packetTotalSize) + 'B' + TextFormatting.WHITE, TextFormatting.YELLOW + MiscUtils.formatNumber((long)(packetTotalSize / packetTotalAmount))) + 'B' + TextFormatting.WHITE);
        }
        return messages;
    }
}

