/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.profiler;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.text.TextFormatting;

public class SPacketProfiler {
    private static final Map<GameProfile, Map<Class<?>, AtomicLong>> PLAYER_CLIENT_PACKETS = new ConcurrentHashMap();

    public static void onPacketReceived(NetworkManager networkManager, Object packet) {
        INetHandler netHandler = networkManager.func_150729_e();
        if (!(netHandler instanceof NetHandlerPlayServer)) {
            return;
        }
        NetHandlerPlayServer handlerServer = (NetHandlerPlayServer)netHandler;
        GameProfile profile = handlerServer.field_147369_b.func_146103_bH();
        Map packetCounter = PLAYER_CLIENT_PACKETS.computeIfAbsent(profile, v -> new ConcurrentHashMap());
        packetCounter.computeIfAbsent(packet.getClass(), v -> new AtomicLong(0L)).getAndIncrement();
    }

    public static void onPacketReceived(EntityPlayer player, Object packet) {
        GameProfile profile = player.func_146103_bH();
        Map packetCounter = PLAYER_CLIENT_PACKETS.computeIfAbsent(profile, v -> new ConcurrentHashMap());
        packetCounter.computeIfAbsent(packet.getClass(), v -> new AtomicLong(0L)).getAndIncrement();
    }

    public static List<String> getProfilerMessages() {
        ConcurrentHashMap packetCounter = new ConcurrentHashMap();
        PLAYER_CLIENT_PACKETS.forEach((profile, map) -> map.forEach((pClass, counter) -> packetCounter.computeIfAbsent(pClass, v -> new AtomicLong(0L)).addAndGet(counter.get())));
        List<Map.Entry> largest = packetCounter.entrySet().stream().sorted((o1, o2) -> Long.compare(((AtomicLong)o2.getValue()).get(), ((AtomicLong)o1.getValue()).get())).limit(Math.min(50, packetCounter.size() / 2 + packetCounter.size() % 2)).collect(Collectors.toList());
        List<Map.Entry> smallest = packetCounter.entrySet().stream().sorted(Comparator.comparingLong(o -> ((AtomicLong)o.getValue()).get())).limit(Math.min(50, packetCounter.size() / 2)).collect(Collectors.toList());
        ConcurrentHashMap<Class, Map> pClassCounter = new ConcurrentHashMap<Class, Map>();
        PLAYER_CLIENT_PACKETS.forEach((profile, map) -> map.forEach((pClass, counter) -> pClassCounter.computeIfAbsent((Class)pClass, v -> new ConcurrentHashMap()).computeIfAbsent(profile, v -> new AtomicLong(0L)).addAndGet(counter.get())));
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(TextFormatting.BLUE + "\u5df2\u63a5\u6536\u7684\u7f51\u7edc\u5305\uff08\u6700\u5927\u6392\u5e8f\uff0c\u81f3\u591a 50\uff09\uff1a");
        largest.forEach(entry -> {
            Class pClass = (Class)entry.getKey();
            AtomicLong counter = (AtomicLong)entry.getValue();
            messages.add(TextFormatting.BLUE + "  " + SPacketProfiler.getPacketClassName(pClass) + ": " + TextFormatting.GOLD + counter.get());
        });
        messages.add(TextFormatting.BLUE + "\u5df2\u63a5\u6536\u7684\u7f51\u7edc\u5305\uff08\u6700\u5c0f\u6392\u5e8f\uff0c\u81f3\u591a 50\uff09\uff1a");
        smallest.forEach(entry -> {
            Class pClass = (Class)entry.getKey();
            AtomicLong counter = (AtomicLong)entry.getValue();
            messages.add(TextFormatting.BLUE + "  " + SPacketProfiler.getPacketClassName(pClass) + ": " + TextFormatting.GOLD + counter.get());
        });
        messages.add(TextFormatting.RED + "\u7edf\u8ba1\u4e2d\u7684\u53ef\u7591\u7f51\u7edc\u5305\uff1a");
        pClassCounter.forEach((pClass, map) -> {
            if (map.size() == 1) {
                map.forEach((profile, counter) -> {
                    messages.add(TextFormatting.RED + profile.getName() + " (" + profile.getId() + ")");
                    messages.add(TextFormatting.BLUE + "  " + SPacketProfiler.getPacketClassName(pClass) + ": " + TextFormatting.GOLD + counter.get());
                });
            }
        });
        return messages;
    }

    public static List<String> getFullProfilerMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        PLAYER_CLIENT_PACKETS.forEach((profile, map) -> {
            messages.add(TextFormatting.BLUE + profile.getName() + " (" + profile.getId() + ")");
            map.entrySet().stream().sorted((o1, o2) -> Long.compare(((AtomicLong)o2.getValue()).get(), ((AtomicLong)o1.getValue()).get())).forEach(entry -> {
                Class pClass = (Class)entry.getKey();
                AtomicLong counter = (AtomicLong)entry.getValue();
                messages.add(TextFormatting.BLUE + "  " + SPacketProfiler.getPacketClassName(pClass) + ": " + TextFormatting.GOLD + counter.get());
            });
        });
        return messages;
    }

    private static String getPacketClassName(Class<?> pClass) {
        if (pClass.getName().startsWith("net.minecraft")) {
            return pClass.getSimpleName();
        }
        return pClass.getName();
    }
}

