/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.profiler;

import com.mojang.authlib.GameProfile;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.handler.HyperNetEventHandler;
import github.kasuminova.novaeng.common.network.packetprofiler.PktCProfilerRequest;
import github.kasuminova.novaeng.common.profiler.CPacketProfilerData;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CPacketProfilerDataProcessor {
    public static final CPacketProfilerDataProcessor INSTANCE = new CPacketProfilerDataProcessor();
    private final Map<GameProfile, CPacketProfilerData> receivedData = new ConcurrentHashMap<GameProfile, CPacketProfilerData>();
    private ICommandSender sender = null;
    private UUID currentEvent = null;
    private GameProfile target = null;
    private int limit = 0;
    private long startTime = 0L;
    private int players = 0;
    private int receivedPlayers = 0;
    private Future<Void> task = null;

    private CPacketProfilerDataProcessor() {
    }

    public void create(ICommandSender sender, int limit, @Nullable GameProfile target) {
        if (this.currentEvent != null) {
            NovaEngineeringCore.log.warn("Profiler collect task is already running, event ID: {}", (Object)this.currentEvent);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "\u5df2\u5b58\u5728\u4e00\u4e2a\u6536\u96c6\u4efb\u52a1\uff01\u4e8b\u4ef6 ID: " + TextFormatting.YELLOW + this.currentEvent));
            return;
        }
        List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
        if (players.isEmpty()) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "\u65e0\u73a9\u5bb6\u5728\u7ebf\uff0c\u65e0\u6cd5\u521b\u5efa\u6536\u96c6\u4efb\u52a1\uff01"));
            return;
        }
        this.sender = sender;
        this.currentEvent = UUID.randomUUID();
        this.target = target;
        this.limit = limit;
        this.startTime = System.currentTimeMillis();
        this.requestPlayers(players, limit);
        this.createTask();
        this.sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u6536\u96c6\u4efb\u52a1\u5df2\u521b\u5efa\uff0c\u4e8b\u4ef6 ID: " + TextFormatting.YELLOW + this.currentEvent));
    }

    private void requestPlayers(List<EntityPlayerMP> players, int limit) {
        this.players = players.size();
        this.receivedPlayers = 0;
        players.forEach(player -> NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktCProfilerRequest(this.currentEvent, limit), player));
    }

    private void createTask() {
        this.task = CompletableFuture.runAsync(() -> {
            while (this.receivedPlayers < this.players && System.currentTimeMillis() - this.startTime < 5000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.receivedPlayers < this.players) {
                NovaEngineeringCore.log.warn("Profiler collect task timeout ({}ms), received players: {}, players: {}", (Object)(System.currentTimeMillis() - this.startTime), (Object)this.receivedPlayers, (Object)this.players);
            } else {
                NovaEngineeringCore.log.info("Profiler collect task completed ({}ms), received players: {}, players: {}", (Object)(System.currentTimeMillis() - this.startTime), (Object)this.receivedPlayers, (Object)this.players);
            }
            ProcessedData result = this.getProcessedData();
            HyperNetEventHandler.addTickEndAction(() -> this.finish(result));
        });
    }

    private void finish(ProcessedData result) {
        Map mergedPackets = result.mergedPackets().entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(LinkedHashMap::new, (map, entry) -> map.put((String)entry.getKey(), (CPacketProfilerData.PacketData)entry.getValue()), Map::putAll);
        Map mergedTileEntityPackets = result.mergedTileEntityPackets().entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(LinkedHashMap::new, (map, entry) -> map.put((String)entry.getKey(), (CPacketProfilerData.PacketData)entry.getValue()), Map::putAll);
        ArrayList<ITextComponent> messages = new ArrayList<ITextComponent>();
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u6536\u96c6\u4efb\u52a1\u5b8c\u6210\uff0c\u4e8b\u4ef6 ID: " + TextFormatting.YELLOW + this.currentEvent));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u5df2\u6536\u96c6\u6570\u636e: " + TextFormatting.YELLOW + this.receivedPlayers + "/" + this.players));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u603b\u5e26\u5bbd\u4f7f\u7528: ~" + TextFormatting.AQUA + MiscUtils.formatNumber((long)((long)result.totalBandwidthPerSecond())) + "B/s"));
        if (this.target == null) {
            CPacketProfilerDataProcessor.generateDefaultMessage(messages, (long)result.maxBandwidthPerSecond(), result.maxPlayer(), mergedPackets, mergedTileEntityPackets);
        } else {
            CPacketProfilerDataProcessor.generateTargetMessage(messages, this.target, mergedPackets, mergedTileEntityPackets);
        }
        messages.forEach(message -> this.sender.func_145747_a(message));
        this.reset();
    }

    private void reset() {
        this.receivedData.clear();
        this.sender = null;
        this.currentEvent = null;
        this.target = null;
        this.limit = 0;
        this.startTime = 0L;
        this.receivedPlayers = 0;
        this.players = 0;
        this.task = null;
    }

    @Nonnull
    private ProcessedData getProcessedData() {
        Map sorted = this.receivedData.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(LinkedHashMap::new, (map, entry) -> map.put((GameProfile)entry.getKey(), (CPacketProfilerData)entry.getValue()), Map::putAll);
        double totalBandwidthPerSecond = sorted.values().stream().mapToDouble(CPacketProfilerData::getNetworkBandwidthPerSecond).sum();
        GameProfile maxPlayer = sorted.entrySet().stream().max(Comparator.comparingDouble(entry -> ((CPacketProfilerData)entry.getValue()).getNetworkBandwidthPerSecond())).map(Map.Entry::getKey).orElse(null);
        assert (maxPlayer != null);
        double maxBandwidthPerSecond = sorted.values().stream().mapToDouble(CPacketProfilerData::getNetworkBandwidthPerSecond).max().orElse(0.0);
        HashMap mergedPackets = new HashMap();
        HashMap mergedTileEntityPackets = new HashMap();
        for (CPacketProfilerData data : sorted.values()) {
            HashMap finalMergedPackets = mergedPackets;
            data.getPackets().forEach((packetName, packetData) -> {
                CPacketProfilerData.PacketData mergedPacketData = (CPacketProfilerData.PacketData)finalMergedPackets.get(packetName);
                if (mergedPacketData == null) {
                    finalMergedPackets.put(packetName, packetData);
                } else {
                    mergedPacketData.merge((CPacketProfilerData.PacketData)packetData);
                }
            });
            HashMap finalMergedTileEntityPackets = mergedTileEntityPackets;
            data.getTileEntityPackets().forEach((packetName, packetData) -> {
                CPacketProfilerData.PacketData mergedPacketData = (CPacketProfilerData.PacketData)finalMergedTileEntityPackets.get(packetName);
                if (mergedPacketData == null) {
                    finalMergedTileEntityPackets.put(packetName, packetData);
                } else {
                    mergedPacketData.merge((CPacketProfilerData.PacketData)packetData);
                }
            });
        }
        return new ProcessedData(totalBandwidthPerSecond, maxPlayer, maxBandwidthPerSecond, mergedPackets, mergedTileEntityPackets);
    }

    private static void generateDefaultMessage(List<ITextComponent> messages, long maxBandwidthPerSecond, GameProfile maxPlayer, Map<String, CPacketProfilerData.PacketData> mergedPackets, Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets) {
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u6700\u5927\u5e26\u5bbd\u4f7f\u7528: ~" + TextFormatting.AQUA + MiscUtils.formatNumber((long)maxBandwidthPerSecond) + "B/s" + TextFormatting.GREEN + "\uff0c\u6765\u81ea: " + TextFormatting.YELLOW + maxPlayer.getName()));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u5408\u5e76\u540e\u6570\u636e: "));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u666e\u901a\u6570\u636e\u5305: "));
        CPacketProfilerDataProcessor.generatePktMessage(messages, mergedPackets);
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "TileEntity \u6570\u636e\u5305: "));
        CPacketProfilerDataProcessor.generatePktMessage(messages, mergedTileEntityPackets);
    }

    private static void generatePktMessage(List<ITextComponent> messages, Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets) {
        for (Map.Entry<String, CPacketProfilerData.PacketData> entry : mergedTileEntityPackets.entrySet()) {
            messages.add((ITextComponent)new TextComponentString("PktClass: " + TextFormatting.GOLD + entry.getKey() + TextFormatting.RESET + ": " + TextFormatting.RED + MiscUtils.formatNumber((long)entry.getValue().totalSize()) + 'B' + TextFormatting.WHITE + ", PktCnt: " + TextFormatting.AQUA + entry.getValue().count() + TextFormatting.WHITE + ", SizeAvg: " + TextFormatting.YELLOW + MiscUtils.formatNumber((long)(entry.getValue().totalSize() / (long)entry.getValue().count())) + 'B'));
        }
    }

    private static void generateTargetMessage(List<ITextComponent> messages, GameProfile target, Map<String, CPacketProfilerData.PacketData> mergedPackets, Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets) {
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u76ee\u6807\u73a9\u5bb6: " + TextFormatting.YELLOW + target.getName()));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u5408\u5e76\u540e\u6570\u636e: "));
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "\u666e\u901a\u6570\u636e\u5305: "));
        CPacketProfilerDataProcessor.generatePktMessage(messages, mergedPackets);
        messages.add((ITextComponent)new TextComponentString(TextFormatting.GREEN + "TileEntity \u6570\u636e\u5305: "));
        CPacketProfilerDataProcessor.generatePktMessage(messages, mergedTileEntityPackets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(UUID eventId, GameProfile player, CPacketProfilerData data) {
        if (this.currentEvent == null) {
            return;
        }
        if (!this.currentEvent.equals(eventId)) {
            NovaEngineeringCore.log.warn("Received profiler data from {} with wrong eventId!", (Object)player.getName());
            return;
        }
        Map<GameProfile, CPacketProfilerData> map = this.receivedData;
        synchronized (map) {
            ++this.receivedPlayers;
            this.receivedData.put(player, data);
        }
        NovaEngineeringCore.log.info("Received profiler data from {}", (Object)player.getName());
    }

    private static final class ProcessedData {
        private final double totalBandwidthPerSecond;
        private final GameProfile maxPlayer;
        private final double maxBandwidthPerSecond;
        private final Map<String, CPacketProfilerData.PacketData> mergedPackets;
        private final Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets;

        private ProcessedData(double totalBandwidthPerSecond, GameProfile maxPlayer, double maxBandwidthPerSecond, Map<String, CPacketProfilerData.PacketData> mergedPackets, Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets) {
            this.totalBandwidthPerSecond = totalBandwidthPerSecond;
            this.maxPlayer = maxPlayer;
            this.maxBandwidthPerSecond = maxBandwidthPerSecond;
            this.mergedPackets = mergedPackets;
            this.mergedTileEntityPackets = mergedTileEntityPackets;
        }

        public String toString() {
            return "ProcessedData[" + "totalBandwidthPerSecond=" + this.totalBandwidthPerSecond + "," + "maxPlayer=" + this.maxPlayer + "," + "maxBandwidthPerSecond=" + this.maxBandwidthPerSecond + "," + "mergedPackets=" + this.mergedPackets + "," + "mergedTileEntityPackets=" + this.mergedTileEntityPackets + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(Double.doubleToLongBits(this.totalBandwidthPerSecond) ^ Double.doubleToLongBits(this.totalBandwidthPerSecond) >>> 32);
            result = 31 * result + (this.maxPlayer != null ? this.maxPlayer.hashCode() : 0);
            result = 31 * result + (int)(Double.doubleToLongBits(this.maxBandwidthPerSecond) ^ Double.doubleToLongBits(this.maxBandwidthPerSecond) >>> 32);
            result = 31 * result + (this.mergedPackets != null ? this.mergedPackets.hashCode() : 0);
            result = 31 * result + (this.mergedTileEntityPackets != null ? this.mergedTileEntityPackets.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((ProcessedData)arg0).totalBandwidthPerSecond != this.totalBandwidthPerSecond) {
                return false;
            }
            if (!Objects.equals(((ProcessedData)arg0).maxPlayer, this.maxPlayer)) {
                return false;
            }
            if (((ProcessedData)arg0).maxBandwidthPerSecond != this.maxBandwidthPerSecond) {
                return false;
            }
            if (!Objects.equals(((ProcessedData)arg0).mergedPackets, this.mergedPackets)) {
                return false;
            }
            return Objects.equals(((ProcessedData)arg0).mergedTileEntityPackets, this.mergedTileEntityPackets);
            {
            }
        }

        public double totalBandwidthPerSecond() {
            return this.totalBandwidthPerSecond;
        }

        public GameProfile maxPlayer() {
            return this.maxPlayer;
        }

        public double maxBandwidthPerSecond() {
            return this.maxBandwidthPerSecond;
        }

        public Map<String, CPacketProfilerData.PacketData> mergedPackets() {
            return this.mergedPackets;
        }

        public Map<String, CPacketProfilerData.PacketData> mergedTileEntityPackets() {
            return this.mergedTileEntityPackets;
        }
    }
}

