/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.profiler;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class CPacketProfilerData
implements Comparable<CPacketProfilerData> {
    private final Map<String, PacketData> packets = new HashMap<String, PacketData>();
    private final Map<String, PacketData> tileEntityPackets = new HashMap<String, PacketData>();
    private final float networkBandwidthPerSecond;

    public CPacketProfilerData(float networkBandwidthPerSecond) {
        this.networkBandwidthPerSecond = networkBandwidthPerSecond;
    }

    public void addPacket(String packetName, int count, long totalSize) {
        this.packets.putIfAbsent(packetName, new PacketData(count, totalSize));
    }

    public void addTileEntityPacket(String packetName, int count, long totalSize) {
        this.tileEntityPackets.putIfAbsent(packetName, new PacketData(count, totalSize));
    }

    public Map<String, PacketData> getPackets() {
        return this.packets;
    }

    public Map<String, PacketData> getTileEntityPackets() {
        return this.tileEntityPackets;
    }

    public float getNetworkBandwidthPerSecond() {
        return this.networkBandwidthPerSecond;
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeFloat(this.networkBandwidthPerSecond);
        buf.writeInt(this.packets.size());
        for (Map.Entry<String, PacketData> entry : this.packets.entrySet()) {
            buf.writeShort(entry.getKey().length());
            buf.writeCharSequence((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
            buf.writeInt(entry.getValue().count());
            buf.writeLong(entry.getValue().totalSize());
        }
        buf.writeInt(this.tileEntityPackets.size());
        for (Map.Entry<String, PacketData> entry : this.tileEntityPackets.entrySet()) {
            buf.writeShort(entry.getKey().length());
            buf.writeCharSequence((CharSequence)entry.getKey(), StandardCharsets.UTF_8);
            buf.writeInt(entry.getValue().count());
            buf.writeLong(entry.getValue().totalSize());
        }
    }

    public static CPacketProfilerData readFromBuffer(ByteBuf buf) {
        CPacketProfilerData data = new CPacketProfilerData(buf.readFloat());
        int packetCount = buf.readInt();
        for (int i = 0; i < packetCount; ++i) {
            String packetName = buf.readCharSequence((int)buf.readShort(), StandardCharsets.UTF_8).toString();
            int count = buf.readInt();
            long totalSize = buf.readLong();
            data.addPacket(packetName, count, totalSize);
        }
        int tileEntityPacketCount = buf.readInt();
        for (int i = 0; i < tileEntityPacketCount; ++i) {
            String packetName = buf.readCharSequence((int)buf.readShort(), StandardCharsets.UTF_8).toString();
            int count = buf.readInt();
            long totalSize = buf.readLong();
            data.addTileEntityPacket(packetName, count, totalSize);
        }
        return data;
    }

    @Override
    public int compareTo(@Nonnull CPacketProfilerData o) {
        return Float.compare(o.networkBandwidthPerSecond, this.networkBandwidthPerSecond);
    }

    public static final class PacketData
    implements Comparable<PacketData> {
        private int count;
        private long totalSize;

        public PacketData(int count, long totalSize) {
            this.count = count;
            this.totalSize = totalSize;
        }

        public void merge(PacketData data) {
            this.count += data.count;
            this.totalSize += data.totalSize;
        }

        public int count() {
            return this.count;
        }

        public long totalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "PacketData[count=" + this.count + ", totalSize=" + this.totalSize + ']';
        }

        @Override
        public int compareTo(@Nonnull PacketData o) {
            return Long.compare(o.totalSize, this.totalSize);
        }
    }
}

