/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.profiler;

import github.kasuminova.novaeng.common.profiler.CPacketProfilerData;
import github.kasuminova.novaeng.common.profiler.TEUpdatePacketProfiler;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;

public class CPacketProfiler {
    public static final ConcurrentHashMap<Class<?>, Tuple<Long, Long>> PACKET_TOTAL_SIZE = new ConcurrentHashMap();
    public static final AtomicLong TOTAL_RECEIVED_DATA_SIZE = new AtomicLong(0L);
    public static boolean enabled = false;
    public static long profilerStartTime = 0L;
    public static long profilerStopTime = 0L;

    public static void onPacketReceived(Object packet, int packetSize) {
        if (!enabled) {
            return;
        }
        if (PACKET_TOTAL_SIZE.isEmpty()) {
            profilerStartTime = System.currentTimeMillis();
        }
        PACKET_TOTAL_SIZE.compute(packet.getClass(), (key, value) -> value == null ? new Tuple((Object)1L, (Object)packetSize) : new Tuple((Object)((Long)value.func_76341_a() + 1L), (Object)((Long)value.func_76340_b() + (long)packetSize)));
        if (packet instanceof SPacketUpdateTileEntity) {
            TEUpdatePacketProfiler.onPacketReceived((SPacketUpdateTileEntity)packet, packetSize);
        }
    }

    public static void onPacketDecoded(int length) {
        if (!enabled) {
            return;
        }
        TOTAL_RECEIVED_DATA_SIZE.addAndGet(length);
    }

    public static CPacketProfilerData getProfilerData(int limit) {
        long totalPacketSize = TOTAL_RECEIVED_DATA_SIZE.get();
        long profileTimeExisted = enabled ? System.currentTimeMillis() - profilerStartTime : profilerStopTime - profilerStartTime;
        double networkBandwidthPerSec = profileTimeExisted <= 0L ? 0.0 : (double)totalPacketSize / ((double)profileTimeExisted / 1000.0);
        List<Map.Entry> sorted = PACKET_TOTAL_SIZE.entrySet().stream().sorted((o1, o2) -> Long.compare((Long)((Tuple)o2.getValue()).func_76340_b(), (Long)((Tuple)o1.getValue()).func_76340_b())).limit(limit).collect(Collectors.toList());
        List<Map.Entry> teSorted = TEUpdatePacketProfiler.TE_UPDATE_PACKET_TOTAL_SIZE.entrySet().stream().sorted((o1, o2) -> Long.compare((Long)((Tuple)o2.getValue()).func_76340_b(), (Long)((Tuple)o1.getValue()).func_76340_b())).limit(limit).collect(Collectors.toList());
        CPacketProfilerData data = new CPacketProfilerData((float)networkBandwidthPerSec);
        sorted.forEach(entry -> {
            Class pktClass = (Class)entry.getKey();
            if (pktClass.getName().startsWith("net.minecraft")) {
                data.addPacket(pktClass.getSimpleName(), (int)((Long)((Tuple)entry.getValue()).func_76341_a()).longValue(), (Long)((Tuple)entry.getValue()).func_76340_b());
            } else {
                data.addPacket(pktClass.getName(), (int)((Long)((Tuple)entry.getValue()).func_76341_a()).longValue(), (Long)((Tuple)entry.getValue()).func_76340_b());
            }
        });
        teSorted.forEach(entry -> data.addTileEntityPacket(((Class)entry.getKey()).getName(), (int)((Long)((Tuple)entry.getValue()).func_76341_a()).longValue(), (Long)((Tuple)entry.getValue()).func_76340_b()));
        return data;
    }

    public static List<String> getProfilerMessages(int limit) {
        LinkedList<String> messages = new LinkedList<String>();
        long totalPacketSize = TOTAL_RECEIVED_DATA_SIZE.get();
        long profileTimeExisted = enabled ? System.currentTimeMillis() - profilerStartTime : profilerStopTime - profilerStartTime;
        double networkBandwidthPerSec = profileTimeExisted <= 0L ? 0.0 : (double)totalPacketSize / ((double)profileTimeExisted / 1000.0);
        messages.add(String.format("Network BandWidth Per Second: %s", TextFormatting.GREEN + MiscUtils.formatNumber((long)((long)networkBandwidthPerSec)) + "B/s" + TextFormatting.WHITE));
        if (limit <= 0) {
            return messages;
        }
        List sorted = PACKET_TOTAL_SIZE.entrySet().stream().sorted((o1, o2) -> Long.compare((Long)((Tuple)o2.getValue()).func_76340_b(), (Long)((Tuple)o1.getValue()).func_76340_b())).limit(limit).collect(Collectors.toList());
        for (Map.Entry entry : sorted) {
            Class pClass = (Class)entry.getKey();
            long packetTotalAmount = (Long)((Tuple)entry.getValue()).func_76341_a();
            long packetTotalSize = (Long)((Tuple)entry.getValue()).func_76340_b();
            if (pClass.getName().startsWith("net.minecraft")) {
                messages.add(String.format("Pkt Class: %s", TextFormatting.BLUE + pClass.getSimpleName() + TextFormatting.WHITE));
            } else {
                messages.add(String.format("Mod Pkt Class: %s", TextFormatting.BLUE + pClass.getName() + TextFormatting.WHITE));
            }
            messages.add(String.format("Amt: %s, Size Total: %s, Size Avg: %s", TextFormatting.GOLD + MiscUtils.formatDecimal((double)packetTotalAmount) + TextFormatting.WHITE, TextFormatting.RED + MiscUtils.formatNumber((long)packetTotalSize) + 'B' + TextFormatting.WHITE, TextFormatting.YELLOW + MiscUtils.formatNumber((long)(packetTotalSize / packetTotalAmount))) + 'B' + TextFormatting.WHITE);
        }
        return messages;
    }
}

