/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.HyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStation;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStationType;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktTerminalGuiData
implements IMessage,
IMessageHandler<PktTerminalGuiData, IMessage> {
    private static final List<ResearchCognitionData> UNLOCKED_DATA = new ArrayList<ResearchCognitionData>();
    private static final Object2DoubleOpenHashMap<ResearchCognitionData> RESEARCHING_DATA = new Object2DoubleOpenHashMap();
    private static final List<Database.Status> DATABASES = new ArrayList<Database.Status>();
    private static ResearchStationType researchStationType = null;
    private NBTTagCompound tag;
    private TileHyperNetTerminal terminal = null;

    public PktTerminalGuiData() {
    }

    public PktTerminalGuiData(TileHyperNetTerminal terminal) {
        this.terminal = terminal;
    }

    public static List<ResearchCognitionData> getUnlockedData() {
        return UNLOCKED_DATA;
    }

    public static Object2DoubleOpenHashMap<ResearchCognitionData> getResearchingData() {
        return RESEARCHING_DATA;
    }

    public static List<Database.Status> getDatabases() {
        return DATABASES;
    }

    public static ResearchStationType getResearchStationType() {
        return researchStationType;
    }

    public void fromBytes(ByteBuf buf) {
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        HyperNetTerminal node = this.terminal.getNodeProxy();
        ComputationCenter center = node.getCenter();
        if (!node.isConnected() || center == null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            return;
        }
        Collection<Database> databases = center.getNode(Database.class);
        Set researchCognition = databases.stream().flatMap(database -> database.getStoredResearchCognition().stream()).collect(Collectors.toSet());
        NBTTagList unlocked = new NBTTagList();
        researchCognition.stream().map(data -> new NBTTagString(data.getResearchName())).forEach(arg_0 -> ((NBTTagList)unlocked).func_74742_a(arg_0));
        tag.func_74782_a("unlockedData", (NBTBase)unlocked);
        NBTTagList databasesTag = new NBTTagList();
        Object2DoubleOpenHashMap researchingData = new Object2DoubleOpenHashMap();
        databases.forEach(database -> {
            databasesTag.func_74742_a((NBTBase)database.createStatus().writeToNBT());
            database.getAllResearchingCognition().forEach((research, progress) -> {
                String researchName = research.getResearchName();
                Double value = (Double)researchingData.computeIfPresent((Object)researchName, (_k, v) -> v > progress ? v : progress);
                if (value == null) {
                    researchingData.put((Object)researchName, progress.doubleValue());
                }
            });
        });
        tag.func_74782_a("databases", (NBTBase)databasesTag);
        NBTTagList researching = new NBTTagList();
        researchingData.forEach((key, value) -> {
            NBTTagCompound research = new NBTTagCompound();
            research.func_74778_a("researchName", key);
            research.func_74780_a("progress", value.doubleValue());
            researching.func_74742_a((NBTBase)research);
        });
        tag.func_74782_a("researchingData", (NBTBase)researching);
        Collection<ResearchStation> researchStations = center.getNode(ResearchStation.class);
        if (!researchStations.isEmpty()) {
            ResearchStation station = researchStations.stream().findFirst().get();
            ResearchStationType type = station.getType();
            tag.func_74778_a("researchStationType", type.getTypeName());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IMessage onMessage(PktTerminalGuiData message, MessageContext ctx) {
        if (message.tag == null) {
            return null;
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> PktTerminalGuiData.processPacket(message));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static void processPacket(PktTerminalGuiData message) {
        UNLOCKED_DATA.clear();
        RESEARCHING_DATA.clear();
        DATABASES.clear();
        NBTTagCompound tag = message.tag;
        NBTTagList unlocked = tag.func_150295_c("unlockedData", 8);
        IntStream.range(0, unlocked.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)unlocked).func_150307_f(arg_0)).map(RegistryHyperNet::getResearchCognitionData).filter(Objects::nonNull).forEach(UNLOCKED_DATA::add);
        NBTTagList researching = tag.func_150295_c("researchingData", 10);
        IntStream.range(0, researching.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)researching).func_150305_b(arg_0)).forEach(tagAt -> {
            String researchName = tagAt.func_74779_i("researchName");
            ResearchCognitionData data = RegistryHyperNet.getResearchCognitionData(researchName);
            if (data == null) {
                return;
            }
            RESEARCHING_DATA.put((Object)data, tagAt.func_74769_h("progress"));
        });
        NBTTagList databases = tag.func_150295_c("databases", 10);
        IntStream.range(0, databases.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)databases).func_150305_b(arg_0)).map(Database.Status::readFromNBT).filter(Objects::nonNull).forEach(DATABASES::add);
        researchStationType = RegistryHyperNet.getResearchStationType(tag.func_74779_i("researchStationType"));
    }
}

