/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.common.container.ContainerHyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.HyperNetTerminal;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStation;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.tile.TileHyperNetTerminal;
import hellfirepvp.modularmachinery.ModularMachinery;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktResearchTaskProvideCreative
implements IMessage,
IMessageHandler<PktResearchTaskProvideCreative, IMessage> {
    private ResearchCognitionData researchTask = null;

    public PktResearchTaskProvideCreative() {
    }

    public PktResearchTaskProvideCreative(ResearchCognitionData researchTask) {
        this.researchTask = researchTask;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag == null || !tag.func_74764_b("researchTask")) {
            return;
        }
        this.researchTask = RegistryHyperNet.getResearchCognitionData(tag.func_74779_i("researchTask"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("researchTask", this.researchTask.getResearchName());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IMessage onMessage(PktResearchTaskProvideCreative message, MessageContext ctx) {
        ResearchCognitionData researchTask = message.researchTask;
        if (researchTask == null) {
            return null;
        }
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        Container container = player.field_71070_bA;
        if (!(container instanceof ContainerHyperNetTerminal)) {
            return null;
        }
        if (!player.func_184812_l_() || !player.func_70003_b(2, "")) {
            return null;
        }
        TileHyperNetTerminal terminal = (TileHyperNetTerminal)((ContainerHyperNetTerminal)container).getOwner();
        HyperNetTerminal nodeProxy = terminal.getNodeProxy();
        ComputationCenter center = nodeProxy.getCenter();
        if (center == null) {
            return null;
        }
        Collection<Database> databases = center.getNode(Database.class);
        block0: for (ResearchCognitionData dependency : researchTask.getDependencies()) {
            for (Database database : databases) {
                if (!database.hasResearchCognition(dependency)) continue;
                continue block0;
            }
            return null;
        }
        Collection<ResearchStation> stations = center.getNode(ResearchStation.class);
        Optional<ResearchStation> first = stations.stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        ResearchStation researchStation = first.get();
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            researchStation.provideTask(researchTask, (EntityPlayer)ctx.getServerHandler().field_147369_b);
            researchStation.setCompletedPoints(researchTask.getRequiredPoints());
        });
        return null;
    }
}

