/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenterCache;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktHyperNetStatus
implements IMessage,
IMessageHandler<PktHyperNetStatus, IMessage> {
    private NBTTagCompound statusTag = null;
    private ComputationCenter center = null;

    public PktHyperNetStatus() {
    }

    public PktHyperNetStatus(ComputationCenter center) {
        this.center = center;
    }

    public void fromBytes(ByteBuf buf) {
        this.statusTag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound statusTag = new NBTTagCompound();
        statusTag.func_74778_a("centerType", this.center.getType().getTypeName());
        statusTag.func_74768_a("totalConnected", this.center.getConnectedMachineryCount());
        statusTag.func_74780_a("computationPointGeneration", this.center.getComputationPointGeneration());
        statusTag.func_74780_a("computationPointConsumption", this.center.getComputationPointConsumption());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)statusTag);
    }

    public IMessage onMessage(PktHyperNetStatus message, MessageContext ctx) {
        NBTTagCompound statusTag = message.statusTag;
        if (statusTag == null) {
            return null;
        }
        if (!(statusTag.func_74764_b("centerType") && statusTag.func_74764_b("totalConnected") && statusTag.func_74764_b("computationPointGeneration") && statusTag.func_74764_b("computationPointConsumption"))) {
            return null;
        }
        ComputationCenterCache.setType(RegistryHyperNet.getComputationCenterType(statusTag.func_74779_i("centerType")));
        ComputationCenterCache.setTotalConnected(statusTag.func_74762_e("totalConnected"));
        ComputationCenterCache.setComputationPointGeneration(statusTag.func_74769_h("computationPointGeneration"));
        ComputationCenterCache.setComputationPointConsumption(statusTag.func_74769_h("computationPointConsumption"));
        return null;
    }

    public NBTTagCompound getStatusTag() {
        return this.statusTag;
    }
}

