/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.common.container.ContainerGeocentricDrill;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktGeocentricDrillControl
implements IMessage,
IMessageHandler<PktGeocentricDrillControl, IMessage> {
    private Type type;
    private int depth;
    private String accelerateOre;

    public PktGeocentricDrillControl() {
    }

    public PktGeocentricDrillControl(Type type, int depth) {
        this.type = type;
        this.depth = depth;
    }

    public PktGeocentricDrillControl(Type type, String accelerateOre) {
        this.type = type;
        this.accelerateOre = accelerateOre;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readByte()];
        if (this.type == Type.SET_TARGET_DEPTH) {
            this.depth = buf.readShort();
        } else if (this.type == Type.ADD_ACCELERATE_ORE || this.type == Type.REMOVE_ACCELERATE_ORE) {
            byte len = buf.readByte();
            this.accelerateOre = buf.readCharSequence((int)len, StandardCharsets.UTF_8).toString();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        if (this.type == Type.SET_TARGET_DEPTH) {
            buf.writeShort(this.depth);
        } else if (this.type == Type.ADD_ACCELERATE_ORE || this.type == Type.REMOVE_ACCELERATE_ORE) {
            buf.writeByte(this.accelerateOre.length());
            buf.writeCharSequence((CharSequence)this.accelerateOre, StandardCharsets.UTF_8);
        }
    }

    public IMessage onMessage(PktGeocentricDrillControl message, MessageContext ctx) {
        Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
        if (container instanceof ContainerGeocentricDrill) {
            ContainerGeocentricDrill containerGeocentricDrill = (ContainerGeocentricDrill)container;
            GeocentricDrillController drill = (GeocentricDrillController)containerGeocentricDrill.getOwner();
            switch (message.type) {
                case SET_TARGET_DEPTH: {
                    drill.setTargetDepth(message.depth);
                    break;
                }
                case ADD_ACCELERATE_ORE: {
                    drill.addAccelerateOre(message.accelerateOre);
                    break;
                }
                case REMOVE_ACCELERATE_ORE: {
                    drill.removeAccelerateOre(message.accelerateOre);
                }
            }
        }
        return null;
    }

    public static enum Type {
        SET_TARGET_DEPTH,
        ADD_ACCELERATE_ORE,
        REMOVE_ACCELERATE_ORE;

    }
}

