/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.client.gui.GuiEStorageController;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import github.kasuminova.novaeng.common.container.data.EStorageEnergyData;
import github.kasuminova.novaeng.common.item.estorage.EStorageCell;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktEStorageGUIData
implements IMessage,
IMessageHandler<PktEStorageGUIData, IMessage> {
    protected final List<EStorageCellData> dataList = new ArrayList<EStorageCellData>();
    protected EStorageEnergyData energyData = null;

    public PktEStorageGUIData() {
    }

    public PktEStorageGUIData(EStorageController controller) {
        List<EStorageCellDrive> drives = controller.getCellDrives();
        drives.stream().filter(drive -> {
            EStorageCell cell;
            Item patt1811$temp = drive.getDriveInv().getStackInSlot(0).func_77973_b();
            return patt1811$temp instanceof EStorageCell && drive.isCellSupported((cell = (EStorageCell)patt1811$temp).getLevel());
        }).map(EStorageCellData::from).filter(Objects::nonNull).forEach(this.dataList::add);
        this.energyData = new EStorageEnergyData(controller.getEnergyStored(), controller.getMaxEnergyStore(), controller.getEnergyConsumePerTick());
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            byte type = buf.readByte();
            byte level = buf.readByte();
            short usedTypes = buf.readShort();
            long usedBytes = buf.readLong();
            this.dataList.add(new EStorageCellData(DriveStorageType.values()[type], DriveStorageLevel.values()[level], usedTypes, usedBytes));
        }
        this.energyData = new EStorageEnergyData(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dataList.size());
        this.dataList.forEach(data -> {
            int type = data.type().ordinal();
            int level = data.level().ordinal();
            int usedTypes = data.usedTypes();
            long usedBytes = data.usedBytes();
            buf.writeByte(type);
            buf.writeByte(level);
            buf.writeShort(usedTypes);
            buf.writeLong(usedBytes);
        });
        buf.writeDouble(this.energyData.energyStored());
        buf.writeDouble(this.energyData.maxEnergyStore());
        buf.writeDouble(this.energyData.energyConsumePerTick());
    }

    public IMessage onMessage(PktEStorageGUIData message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            PktEStorageGUIData.processPacket(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void processPacket(PktEStorageGUIData message) {
        List<EStorageCellData> dataList = message.dataList;
        EStorageEnergyData energyData = message.energyData;
        GuiScreen cur = Minecraft.func_71410_x().field_71462_r;
        if (!(cur instanceof GuiEStorageController)) {
            return;
        }
        List sorted = dataList.stream().sorted((o1, o2) -> {
            int byteResult = Long.compare(o2.usedBytes(), o1.usedBytes());
            if (byteResult != 0) {
                return byteResult;
            }
            int typeResult = Integer.compare(o2.usedTypes(), o1.usedTypes());
            if (typeResult != 0) {
                return typeResult;
            }
            return Integer.compare(o2.level().ordinal(), o1.level().ordinal());
        }).collect(Collectors.toList());
        Minecraft.func_71410_x().func_152344_a(() -> {
            GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
            if (!(currentScreen instanceof GuiEStorageController)) {
                return;
            }
            GuiEStorageController controllerGUI = (GuiEStorageController)currentScreen;
            controllerGUI.setCellDataList(sorted);
            controllerGUI.setEnergyData(energyData);
            controllerGUI.onDataReceived();
        });
    }
}

