/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.client.gui.GuiEFabricatorController;
import github.kasuminova.novaeng.common.container.data.EFabricatorData;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorWorker;
import io.netty.buffer.ByteBuf;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktEFabricatorGUIData
implements IMessage,
IMessageHandler<PktEFabricatorGUIData, IMessage> {
    private EFabricatorData data = null;

    public PktEFabricatorGUIData(EFabricatorController controller) {
        this.data = new EFabricatorData(controller.getLength(), controller.isOverclocked(), controller.isActiveCooling(), controller.getParallelism(), controller.getCoolantInputFluids(), controller.getCoolantInputCap(), controller.getCoolantOutputFluids(), controller.getCoolantOutputCap(), controller.getEnergyStored(), controller.getTotalCrafted(), controller.getLevel(), controller.getWorkers().stream().map(EFabricatorWorker::getQueue).map(queue -> new EFabricatorData.WorkerStatus(queue.peek() != null ? queue.peek().getOutput() : ItemStack.field_190927_a, queue.size())).collect(Collectors.toList()));
    }

    public PktEFabricatorGUIData() {
    }

    public void fromBytes(ByteBuf buf) {
        this.data = EFabricatorData.read(buf);
    }

    public void toBytes(ByteBuf buf) {
        this.data.write(buf);
    }

    public IMessage onMessage(PktEFabricatorGUIData message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            Minecraft.func_71410_x().func_152344_a(() -> PktEFabricatorGUIData.processPacket(message));
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void processPacket(PktEFabricatorGUIData message) {
        EFabricatorData data = message.data;
        GuiScreen cur = Minecraft.func_71410_x().field_71462_r;
        if (!(cur instanceof GuiEFabricatorController)) {
            return;
        }
        GuiEFabricatorController efGUI = (GuiEFabricatorController)cur;
        if (data == null) {
            return;
        }
        efGUI.onDataUpdate(data);
    }
}

