/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktCellDriveStatusUpdate
implements IMessage,
IMessageHandler<PktCellDriveStatusUpdate, IMessage> {
    private BlockPos pos = null;
    private boolean writing = false;

    public PktCellDriveStatusUpdate() {
    }

    public PktCellDriveStatusUpdate(BlockPos pos, boolean writing) {
        this.pos = pos;
        this.writing = writing;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.writing = buf.readBoolean();
        }
        catch (Exception e) {
            NovaEngineeringCore.log.error("PktCellDriveStatusUpdate read failed.", (Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.writing);
    }

    public IMessage onMessage(PktCellDriveStatusUpdate message, MessageContext ctx) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            PktCellDriveStatusUpdate.processPacket(message);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected static void processPacket(PktCellDriveStatusUpdate message) {
        BlockPos pos = message.pos;
        boolean writing = message.writing;
        if (pos == null) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof EStorageCellDrive)) {
            return;
        }
        EStorageCellDrive drive = (EStorageCellDrive)te;
        drive.setWriting(writing);
        drive.markForUpdate();
    }
}

