/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.network;

import appeng.core.sync.network.NetworkHandler;
import github.kasuminova.mmce.common.util.concurrent.Action;
import github.kasuminova.mmce.common.util.concurrent.ActionExecutor;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.mod.Mods;
import hellfirepvp.modularmachinery.ModularMachinery;
import ic2.core.network.NetworkManager;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import mekanism.common.Mekanism;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.FMLEventChannel;

public class ParallelNetworkManager {
    private final Map<Object, Queue<ActionExecutor>> groupQueues = new ConcurrentHashMap<Object, Queue<ActionExecutor>>();
    private final ReferenceSet<Object> blacklistChannels = new ReferenceOpenHashSet();

    public void init() {
        if (Mods.IC2.loaded()) {
            this.initializeIC2Blacklist();
        }
        if (Mods.AE2.loaded()) {
            this.initializeAE2Blacklist();
        }
        if (Mods.MEKCEU.loaded()) {
            this.initializeMekanismCEuBlacklist();
        }
    }

    @Optional.Method(modid="ic2")
    private void initializeIC2Blacklist() {
        try {
            FMLEventChannel channel = (FMLEventChannel)ObfuscationReflectionHelper.getPrivateValue(NetworkManager.class, null, (String)"channel");
            if (channel != null) {
                this.addBlacklistChannel(channel);
            }
        }
        catch (Throwable e) {
            NovaEngineeringCore.log.warn((Object)e);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void initializeAE2Blacklist() {
        try {
            FMLEventChannel ec = (FMLEventChannel)ObfuscationReflectionHelper.getPrivateValue(NetworkHandler.class, (Object)NetworkHandler.instance(), (String)"ec");
            if (ec != null) {
                this.addBlacklistChannel(ec);
            }
        }
        catch (Throwable e) {
            NovaEngineeringCore.log.warn((Object)e);
        }
    }

    @Optional.Method(modid="mekanism")
    private void initializeMekanismCEuBlacklist() {
        this.addBlacklistChannel(Mekanism.packetHandler.netHandler);
    }

    public void offerAction(Object group, Action action) {
        this.offerAction(group, action, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerAction(Object group, Action action, int priority) {
        Object object;
        Queue queue = this.groupQueues.get(group);
        if (queue == null) {
            object = this.groupQueues;
            synchronized (object) {
                queue = this.groupQueues.computeIfAbsent(group, k -> new PriorityQueue());
            }
        }
        object = queue;
        synchronized (object) {
            queue.offer((ActionExecutor)new ActionExecutor(action, priority));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Map<Object, Queue<ActionExecutor>> map = this.groupQueues;
        synchronized (map) {
            ModularMachinery.EXECUTE_MANAGER.addTask(() -> {
                Iterator<Queue<ActionExecutor>> iterator = this.groupQueues.values().iterator();
                while (iterator.hasNext()) {
                    Queue<ActionExecutor> queue;
                    Queue<ActionExecutor> queue2 = queue = iterator.next();
                    synchronized (queue2) {
                        ActionExecutor action;
                        while ((action = queue.poll()) != null) {
                            action.run();
                        }
                    }
                }
            });
        }
    }

    public boolean isBlacklistChannel(Object channel) {
        return this.blacklistChannels.contains(channel);
    }

    public void addBlacklistChannel(Object channel) {
        this.blacklistChannels.add(channel);
    }
}

