/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.machine;

import com.meteor.extrabotany.common.block.ModBlocks;
import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.machine.MachineSpecial;
import github.kasuminova.novaeng.common.util.RandomUtils;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.fluid.FluidBlockLiquidStarlight;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.tile.network.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.MultiBlockModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.IBlockStateDescriptor;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import ink.ikx.mmce.common.utils.StackUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.common.Botania;

public class IllumPool
implements MachineSpecial {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("modularmachinery", "illum_pool");
    public static final IllumPool ILLUM_POOL = new IllumPool();
    public static final int MAX_MANA_STORE = 10000000;
    public static final int MAX_ILLUM_STORE = 10000;
    public static final List<BlockPos> CATALYST_POS_PRESET = Arrays.asList(IllumPool.withXZ(1, 1), IllumPool.withXZ(0, 1), IllumPool.withXZ(-1, 1), IllumPool.withXZ(2, 2), IllumPool.withXZ(1, 2), IllumPool.withXZ(0, 2), IllumPool.withXZ(-1, 2), IllumPool.withXZ(-2, 2), IllumPool.withXZ(2, 3), IllumPool.withXZ(1, 3), IllumPool.withXZ(0, 3), IllumPool.withXZ(-1, 3), IllumPool.withXZ(-2, 3), IllumPool.withXZ(2, 4), IllumPool.withXZ(1, 4), IllumPool.withXZ(0, 4), IllumPool.withXZ(-1, 4), IllumPool.withXZ(-2, 4), IllumPool.withXZ(1, 5), IllumPool.withXZ(0, 5), IllumPool.withXZ(-1, 5));
    public static final List<BlockPos> CRYSTAL_POS_PRESET = Arrays.asList(new BlockPos(3, 2, 6), new BlockPos(-3, 2, 6), new BlockPos(3, 2, 0), new BlockPos(-3, 2, 0));
    public static final BlockPos ASTRAL_CRYSTAL_POS = new BlockPos(0, 5, 3);
    public static final String NORMAL_CATALYST = "normal";
    public static final String ALCHEMY_CATALYST = "alchemyCatalyst";
    public static final String CONJURATION_CATALYST = "conjurationCatalyst";
    public static final String DIMENSION_CATALYST = "dimensionCatalyst";
    public static final String STARLIGHT_CATALYST = "starlightCatalyst";

    protected IllumPool() {
    }

    @Override
    public void init(DynamicMachine machine) {
        FactoryRecipeThread infusionThread = FactoryRecipeThread.createCoreThread((String)"\u8f89\u5149\u8f6c\u5316\u672f\u5f0f");
        machine.addCoreThread(infusionThread);
        FactoryRecipeThread manaInputThread = FactoryRecipeThread.createCoreThread((String)"\u9b54\u529b\u6ce8\u5165\u672f\u5f0f");
        machine.addCoreThread(manaInputThread);
        FluidBlockLiquidStarlight blockLiquidStarLight = BlocksAS.blockLiquidStarlight;
        Block blockBifrostPerm = vazkii.botania.common.block.ModBlocks.bifrostPerm;
        Block blockAlchemyCatalyst = vazkii.botania.common.block.ModBlocks.alchemyCatalyst;
        Block blockConjurationCatalyst = vazkii.botania.common.block.ModBlocks.conjurationCatalyst;
        Block blockDimensionCatalyst = ModBlocks.dimensioncatalyst;
        machine.getMultiBlockModifiers().add(new MultiBlockModifierReplacement(NORMAL_CATALYST, IllumPool.buildModifierReplacementBlockArray(blockBifrostPerm, CATALYST_POS_PRESET.stream().map(pos -> pos.func_177982_a(0, 1, 0)).collect(Collectors.toList())), Collections.emptyList(), Collections.singletonList("\u9b54\u529b\u6c60\u4e0a\u65b9\u5e03\u6ee1\u5f69\u8679\u6865\u65b9\u5757\u53ef\u4f7f\u5176\u6fc0\u6d3b\u00a7a\u666e\u901a\u6a21\u5f0f\u00a7f\uff0c\u50ac\u5316\u5242\u6a21\u5f0f\u5fc5\u987b\u57fa\u4e8e\u6b64\u6a21\u5f0f\u3002"), StackUtils.getStackFromBlockState((IBlockState)blockBifrostPerm.func_176223_P())));
        machine.getMultiBlockModifiers().add(new MultiBlockModifierReplacement(STARLIGHT_CATALYST, IllumPool.buildModifierReplacementBlockArray((Block)blockLiquidStarLight, CATALYST_POS_PRESET.stream().map(pos -> pos.func_177982_a(0, 1, 0)).collect(Collectors.toList())), Collections.emptyList(), Collections.singletonList("\u9b54\u529b\u6c60\u4e0a\u65b9\u5012\u6ee1\u661f\u80fd\u6db2\u53ef\u4f7f\u5176\u6fc0\u6d3b\u00a7b\u661f\u5149\u6a21\u5f0f\u00a7f\uff0c\u4e0e\u50ac\u5316\u5242\u6a21\u5f0f\u51b2\u7a81\u3002"), StackUtils.getStackFromBlockState((IBlockState)blockLiquidStarLight.func_176223_P())));
        machine.getMultiBlockModifiers().add(new MultiBlockModifierReplacement(ALCHEMY_CATALYST, IllumPool.buildModifierReplacementBlockArray(blockAlchemyCatalyst, CATALYST_POS_PRESET), Collections.emptyList(), Collections.singletonList("\u5c06\u5f69\u8679\u6865\u65b9\u5757\u4e0b\u65b9\u7684\u00a7c\u6240\u6709\u65b9\u5757\u00a7f\u66ff\u6362\u4e3a\u00a7e\u70bc\u91d1\u50ac\u5316\u5668\u00a7f\u65b9\u5757\u53ef\u4f7f\u5176\u6fc0\u6d3b\u00a7e\u70bc\u91d1\u6a21\u5f0f\u00a7f\u3002"), StackUtils.getStackFromBlockState((IBlockState)blockAlchemyCatalyst.func_176223_P())));
        machine.getMultiBlockModifiers().add(new MultiBlockModifierReplacement(CONJURATION_CATALYST, IllumPool.buildModifierReplacementBlockArray(blockConjurationCatalyst, CATALYST_POS_PRESET), Collections.emptyList(), Collections.singletonList("\u5c06\u5f69\u8679\u6865\u65b9\u5757\u4e0b\u65b9\u7684\u00a7c\u6240\u6709\u65b9\u5757\u00a7f\u66ff\u6362\u4e3a\u00a7d\u70bc\u9020\u50ac\u5316\u5668\u00a7f\u65b9\u5757\u53ef\u4f7f\u5176\u6fc0\u6d3b\u00a7d\u70bc\u9020\u6a21\u5f0f\u00a7f\u3002"), StackUtils.getStackFromBlockState((IBlockState)blockConjurationCatalyst.func_176223_P())));
        machine.getMultiBlockModifiers().add(new MultiBlockModifierReplacement(DIMENSION_CATALYST, IllumPool.buildModifierReplacementBlockArray(blockDimensionCatalyst, CATALYST_POS_PRESET), Collections.emptyList(), Collections.singletonList("\u5c06\u5f69\u8679\u6865\u65b9\u5757\u4e0b\u65b9\u7684\u00a7c\u6240\u6709\u65b9\u5757\u00a7f\u66ff\u6362\u4e3a\u00a75\u6b21\u5143\u50ac\u5316\u5668\u00a7f\u65b9\u5757\u53ef\u4f7f\u5176\u6fc0\u6d3b\u00a75\u6b21\u5143\u6a21\u5f0f\u00a7f\u3002"), StackUtils.getStackFromBlockState((IBlockState)blockDimensionCatalyst.func_176223_P())));
        machine.addMachineEventHandler(MachineStructureUpdateEvent.class, event -> {
            TileMultiblockMachineController controller = event.getController();
            NBTTagCompound tag = controller.getCustomDataTag();
            String catalyst = null;
            Map foundModifiers = controller.getFoundModifiers();
            if (foundModifiers.containsKey(ALCHEMY_CATALYST) && foundModifiers.containsKey(NORMAL_CATALYST)) {
                catalyst = ALCHEMY_CATALYST;
            } else if (foundModifiers.containsKey(CONJURATION_CATALYST) && foundModifiers.containsKey(NORMAL_CATALYST)) {
                catalyst = CONJURATION_CATALYST;
            } else if (foundModifiers.containsKey(DIMENSION_CATALYST) && foundModifiers.containsKey(NORMAL_CATALYST)) {
                catalyst = DIMENSION_CATALYST;
            } else if (foundModifiers.containsKey(STARLIGHT_CATALYST) && !foundModifiers.containsKey(NORMAL_CATALYST)) {
                catalyst = STARLIGHT_CATALYST;
            } else if (foundModifiers.containsKey(NORMAL_CATALYST) && !foundModifiers.containsKey(STARLIGHT_CATALYST)) {
                catalyst = NORMAL_CATALYST;
            }
            if (catalyst != null) {
                tag.func_74778_a("currentMode", catalyst);
            } else {
                tag.func_82580_o("currentMode");
            }
            World world = controller.func_145831_w();
            EnumFacing facing = controller.getControllerRotation();
            BlockPos astralCrystalPos = MiscUtils.rotateYCCWNorthUntil((BlockPos)ASTRAL_CRYSTAL_POS, (EnumFacing)facing);
            TileEntity te = world.func_175625_s(astralCrystalPos.func_177971_a((Vec3i)controller.func_174877_v()));
            if (te instanceof TileCollectorCrystal) {
                TileCollectorCrystal collectorCrystal = (TileCollectorCrystal)te;
                CrystalProperties crystalProperties = collectorCrystal.getCrystalProperties();
                int size = crystalProperties.getSize();
                int purity = crystalProperties.getPurity();
                int collectiveCapability = crystalProperties.getCollectiveCapability();
                int illumStored = IllumPool.getIllumStored(tag);
                float parallelism = 256.0f;
                parallelism *= IllumPool.calculateCrystalSizeRatio(size);
                parallelism *= IllumPool.calculateCrystalPurityRatio(purity);
                parallelism *= IllumPool.calculateCrystalCollectiveCapabilityRatio(collectiveCapability);
                float manaConsumeRatio = 2.0f;
                manaConsumeRatio -= IllumPool.calculateCrystalPurityEfficiency(purity);
                manaConsumeRatio -= IllumPool.calculateCrystalCollectiveCapabilityEfficiency(collectiveCapability);
                float f = illumStored > 0 ? 0.75f : 1.0f;
                tag.func_74768_a("size", size);
                tag.func_74768_a("purity", purity);
                tag.func_74768_a("collectiveCapability", collectiveCapability);
                tag.func_74768_a("poolExtraParallelism", Math.round(parallelism));
                tag.func_74776_a("manaConsumeRatio", manaConsumeRatio *= f);
            }
        });
    }

    public static void onRecipeCheck(RecipeCheckEvent event, int manaRequired) {
        float manaConsumeRatio;
        int required;
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int manaStored = IllumPool.getManaStored(tag);
        if (manaStored < (required = Math.max(Math.round((float)manaRequired * (manaConsumeRatio = IllumPool.getManaConsumeRatio(tag))), 1))) {
            event.setFailed("\u9b54\u529b\u5b58\u50a8\u4e0d\u8db3\u6216\u7f3a\u5c11\u7269\u54c1\u8f93\u5165\uff01");
            return;
        }
        int maxParallelism = manaStored / required;
        int extraParallelism = controller.getCustomDataTag().func_74762_e("poolExtraParallelism");
        event.getActiveRecipe().setMaxParallelism(Math.max(1, Math.min(extraParallelism, maxParallelism)));
    }

    public static void onRecipeTick(FactoryRecipeTickEvent event, int manaRequired) {
        float manaConsumeRatio;
        int required;
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        int parallelism = activeRecipe.getParallelism();
        int tickTime = activeRecipe.getTotalTick();
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int manaStored = IllumPool.getManaStored(tag);
        if (manaStored < (required = Math.round((float)manaRequired / (float)tickTime * (float)parallelism * (manaConsumeRatio = IllumPool.getManaConsumeRatio(tag))))) {
            event.setFailed(false, "\u9b54\u529b\u5b58\u50a8\u4e0d\u8db3\uff01");
        } else {
            tag.func_74768_a("manaStored", manaStored - required);
        }
    }

    public static void onRecipeFinished(FactoryRecipeFinishEvent event) {
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int illumStored = IllumPool.getIllumStored(tag);
        if (illumStored > 0) {
            tag.func_74768_a("illumStored", illumStored - 1);
        }
    }

    public static void onAddManaRecipeCheck(RecipeCheckEvent event, int manaToAdd) {
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int manaStored = IllumPool.getManaStored(tag);
        if (manaStored + manaToAdd > 10000000) {
            event.setFailed("\u9b54\u529b\u5b58\u50a8\u5df2\u62b5\u8fbe\u6781\u9650\uff01");
            return;
        }
        int maxParallelism = (10000000 - manaStored) / manaToAdd;
        event.getActiveRecipe().setMaxParallelism(Math.max(1, maxParallelism));
    }

    public static void onAddManaRecipeTick(FactoryRecipeTickEvent event, int manaToAdd) {
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        int parallelism = activeRecipe.getParallelism();
        int tickTime = activeRecipe.getTotalTick();
        int requireToAdd = manaToAdd / tickTime * parallelism;
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int manaStored = IllumPool.getManaStored(tag);
        if (manaStored + requireToAdd > 10000000) {
            event.setFailed(false, "\u9b54\u529b\u5b58\u50a8\u5df2\u62b5\u8fbe\u6781\u9650\uff01");
        } else {
            tag.func_74768_a("manaStored", manaStored + requireToAdd);
        }
    }

    public static void onAddIllumRecipeCheck(RecipeCheckEvent event, int illumToAdd) {
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int illumStored = IllumPool.getIllumStored(tag);
        if (illumStored + illumToAdd > 10000) {
            event.setFailed("\u8f89\u5149\u9b54\u529b\u5b58\u50a8\u5df2\u62b5\u8fbe\u6781\u9650\uff01");
            return;
        }
        int maxParallelism = (10000 - illumStored) / illumToAdd;
        event.getActiveRecipe().setMaxParallelism(Math.max(1, maxParallelism));
    }

    public static void onAddIllumRecipeTick(FactoryRecipeTickEvent event, int illumToAdd) {
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        int parallelism = activeRecipe.getParallelism();
        int tickTime = activeRecipe.getTotalTick();
        int requireToAdd = illumToAdd / tickTime * parallelism;
        TileMultiblockMachineController controller = event.getController();
        NBTTagCompound tag = controller.getCustomDataTag();
        int illumStored = IllumPool.getIllumStored(tag);
        if (illumStored + requireToAdd > 10000) {
            event.setFailed(false, "\u8f89\u5149\u9b54\u529b\u5b58\u50a8\u5df2\u62b5\u8fbe\u6781\u9650\uff01");
        } else {
            tag.func_74768_a("illumStored", illumStored + requireToAdd);
        }
    }

    public static void checkCatalyst(RecipeCheckEvent event, String requiredCatalyst) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TileMultiblockMachineController controller) {
        BlockPos pos = controller.func_174877_v();
        World world = controller.func_145831_w();
        EnumFacing facing = controller.getControllerRotation();
        NBTTagCompound tag = controller.getCustomDataTag();
        BlockPos center = pos.func_177982_a(0, 1, 0).func_177967_a(facing.func_176734_d(), 3);
        int manaStored = IllumPool.getManaStored(tag);
        int wispFXCount = RandomUtils.nextInt(Math.round(Math.max((float)manaStored / 1.0E7f * 11.0f, 2.0f)));
        for (int i = 0; i < wispFXCount; ++i) {
            float size = RandomUtils.nextFloat() / 3.0f;
            IllumPool.wispFX(controller, center, size, 2.0f);
        }
        if (!controller.isWorking()) {
            return;
        }
        int sparkleFXCount = 3;
        TileFactoryController factory = (TileFactoryController)controller;
        FactoryRecipeThread recipeThread = (FactoryRecipeThread)factory.getCoreRecipeThreads().get("\u8f89\u5149\u8f6c\u5316\u672f\u5f0f");
        if (recipeThread != null) {
            sparkleFXCount += Math.min(recipeThread.getActiveRecipe().getParallelism() / 40, 4);
        }
        for (int i = 0; i < sparkleFXCount; ++i) {
            float size = 0.8f + 0.8f * RandomUtils.nextFloat();
            IllumPool.sparkleFX(controller, center, size, 20);
        }
        if (RandomUtils.nextBool()) {
            int illumStored = IllumPool.getIllumStored(tag);
            Color color = illumStored > 0 && RandomUtils.nextBool() ? new Color(16766720) : new Color(10024447);
            Vector3 astralCrystalPos = new Vector3(MiscUtils.rotateYCCWNorthUntil((BlockPos)ASTRAL_CRYSTAL_POS, (EnumFacing)facing));
            Vector3 crystalPos = new Vector3(MiscUtils.rotateYCCWNorthUntil((BlockPos)CRYSTAL_POS_PRESET.get(RandomUtils.nextInt(CRYSTAL_POS_PRESET.size())), (EnumFacing)facing));
            AstralSorcery.proxy.fireLightning(world, astralCrystalPos.add((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), crystalPos.add((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), color);
        }
    }

    @Override
    public void onTOPInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, IProbeHitData data, TileMultiblockMachineController controller) {
        NBTTagCompound tag = controller.getCustomDataTag();
        IProbeInfo box = probeInfo;
        int manaStored = IllumPool.getManaStored(tag);
        float manaPercent = (float)manaStored / 1.0E7f;
        String manaPercentStr = NovaEngUtils.formatNumber(manaStored) + " / " + NovaEngUtils.formatNumber(10000000L) + " (" + NovaEngUtils.formatFloat(manaPercent * 100.0f, 2) + "%)";
        MachineSpecial.newBox(box).horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextFormatting.AQUA + "\u9b54\u529b\u5b58\u50a8:  ").progress(Math.round(manaPercent * 100.0f), 100, probeInfo.defaultProgressStyle().prefix(manaPercentStr).filledColor(-865879809).alternateFilledColor(-872366081).borderColor(-867199795).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(120));
        int illumStored = IllumPool.getIllumStored(tag);
        float illumPercent = (float)illumStored / 10000.0f;
        String illumPercentStr = NovaEngUtils.formatNumber(illumStored) + " / " + NovaEngUtils.formatNumber(10000L) + " (" + NovaEngUtils.formatFloat(illumPercent * 100.0f, 2) + "%)";
        MachineSpecial.newBox(box).horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextFormatting.YELLOW + "\u8f89\u5149\u9b54\u529b\u5b58\u50a8:  ").progress(Math.round(illumPercent * 100.0f), 100, probeInfo.defaultProgressStyle().prefix(illumPercentStr).filledColor(-855638272).alternateFilledColor(-855648512).borderColor(-856766208).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(80));
        box = MachineSpecial.newBox(probeInfo);
        IProbeInfo left = MachineSpecial.newVertical(box);
        IProbeInfo mid = MachineSpecial.newVertical(box);
        IProbeInfo right = MachineSpecial.newVertical(box);
        left.text(TextFormatting.YELLOW + "\u8f89\u5149\u8f6c\u6362\u672f\u5f0f\uff1a");
        switch (tag.func_74779_i("currentMode")) {
            case "alchemyCatalyst": {
                mid.text("\u00a7e\u70bc\u91d1");
                break;
            }
            case "conjurationCatalyst": {
                mid.text("\u00a7d\u70bc\u9020");
                break;
            }
            case "dimensionCatalyst": {
                mid.text("\u00a75\u6b21\u5143");
                break;
            }
            case "starlightCatalyst": {
                mid.text("\u00a7b\u661f\u5149");
                break;
            }
            case "normal": {
                mid.text("\u00a7a\u666e\u901a");
                break;
            }
            default: {
                mid.text("\u00a7c\u672a\u77e5");
            }
        }
        right.text("");
        int crystalSize = tag.func_74762_e("size");
        int crystalPurity = tag.func_74762_e("purity");
        int crystalCollectiveCapability = tag.func_74762_e("collectiveCapability");
        int parallelism = tag.func_74762_e("poolExtraParallelism");
        float manaConsumeRatio = IllumPool.getManaConsumeRatio(tag);
        int maxParallelism = 256;
        float crystalSizeRatio = IllumPool.calculateCrystalSizeRatio(crystalSize);
        float crystalPurityRatio = IllumPool.calculateCrystalPurityRatio(crystalPurity);
        float crystalCollectiveCapabilityRatio = IllumPool.calculateCrystalCollectiveCapabilityRatio(crystalCollectiveCapability);
        left.text(TextFormatting.BLUE + "\u6c34\u6676\u77f3\u5927\u5c0f\uff1a");
        mid.text(TextFormatting.AQUA + String.valueOf(crystalSize));
        Object[] objectArray = new Object[3];
        objectArray[0] = maxParallelism;
        objectArray[1] = Float.valueOf(crystalSizeRatio * 100.0f);
        maxParallelism = Math.round((float)maxParallelism * crystalSizeRatio);
        objectArray[2] = maxParallelism;
        right.text(TextFormatting.DARK_GREEN + String.format(" (%s x %.1f%% = %s)", objectArray));
        left.text(TextFormatting.BLUE + "\u6c34\u6676\u77f3\u7eaf\u5ea6\uff1a");
        mid.text(TextFormatting.AQUA + String.valueOf(crystalPurity));
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = maxParallelism;
        objectArray2[1] = Float.valueOf(crystalPurityRatio * 100.0f);
        maxParallelism = Math.round((float)maxParallelism * crystalPurityRatio);
        objectArray2[2] = maxParallelism;
        right.text(TextFormatting.DARK_GREEN + String.format(" (%s x %.1f%% = %s)", objectArray2) + ' ' + TextFormatting.DARK_AQUA + String.format("(-%.1f%%)", Float.valueOf(IllumPool.calculateCrystalPurityEfficiency(crystalPurity) * 100.0f)));
        left.text(TextFormatting.BLUE + "\u6c34\u6676\u77f3\u629b\u5149\uff1a");
        mid.text(TextFormatting.AQUA + String.valueOf(crystalCollectiveCapability));
        right.text(TextFormatting.DARK_GREEN + String.format(" (%s x %.1f%% = %s)", maxParallelism, Float.valueOf(crystalCollectiveCapabilityRatio * 100.0f), Math.round((float)maxParallelism * crystalCollectiveCapabilityRatio)) + ' ' + TextFormatting.DARK_AQUA + String.format("(-%.1f%%)", Float.valueOf(IllumPool.calculateCrystalCollectiveCapabilityEfficiency(crystalCollectiveCapability) * 100.0f)));
        left.text(TextFormatting.BLUE + "\u6700\u5927\u5e76\u884c\u6570\uff1a");
        mid.text(TextFormatting.DARK_GREEN + String.valueOf(parallelism));
        right.text(TextFormatting.DARK_GREEN + String.format(" (%.1f%%)", Float.valueOf((float)parallelism / 256.0f * 100.0f)));
        left.text(TextFormatting.BLUE + "\u9b54\u529b\u6d88\u8017\u7cfb\u6570\uff1a");
        mid.text(TextFormatting.DARK_AQUA + String.format("%.1f%%", Float.valueOf(manaConsumeRatio * 100.0f)));
        if (illumStored > 0) {
            right.text(TextFormatting.DARK_AQUA + String.format(" (200%% - %.1f%%)", Float.valueOf((2.0f - manaConsumeRatio / 0.75f) * 100.0f)) + TextFormatting.YELLOW + " x 0.75");
        } else {
            right.text(TextFormatting.DARK_AQUA + String.format(" (200%% - %.1f%%)", Float.valueOf((2.0f - manaConsumeRatio) * 100.0f)));
        }
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REGISTRY_NAME;
    }

    protected static int getIllumStored(NBTTagCompound tag) {
        return tag.func_74762_e("illumStored");
    }

    protected static int getManaStored(NBTTagCompound tag) {
        return tag.func_74762_e("manaStored");
    }

    protected static float getManaConsumeRatio(NBTTagCompound tag) {
        float ratio = tag.func_74760_g("manaConsumeRatio");
        return ratio == 0.0f ? 2.0f : ratio;
    }

    protected static float calculateCrystalCollectiveCapabilityRatio(float collectiveCapability) {
        return Math.max(Math.min(collectiveCapability / 35.0f, 1.0f), 0.75f);
    }

    protected static float calculateCrystalPurityRatio(float purity) {
        return Math.max(Math.min(purity / 80.0f, 1.0f), 0.5f);
    }

    protected static float calculateCrystalSizeRatio(float size) {
        return Math.max(Math.min(size / 700.0f, 1.0f), 0.2f);
    }

    public static float calculateCrystalPurityEfficiency(float purity) {
        return purity / 100.0f * 0.6f;
    }

    protected static float calculateCrystalCollectiveCapabilityEfficiency(float collectiveCapability) {
        return collectiveCapability / 100.0f * 0.9f;
    }

    protected static BlockArray buildModifierReplacementBlockArray(Block block, List<BlockPos> posSet) {
        BlockArray blockArray = new BlockArray();
        IBlockStateDescriptor descriptor = new IBlockStateDescriptor(block);
        posSet.forEach(pos -> blockArray.addBlock(pos, new BlockArray.BlockInformation(Collections.singletonList(descriptor))));
        return blockArray;
    }

    protected static BlockPos withXZ(int x, int z) {
        return new BlockPos(x, 0, z);
    }

    protected static void sparkleFX(TileMultiblockMachineController controller, BlockPos center, float size, int lifeTime) {
        double x = (double)center.func_177958_n() + 0.5 + RandomUtils.nextFloat(4.0f) - 2.0;
        double y = (double)center.func_177956_o() + 0.5 + RandomUtils.nextFloat(1.0f);
        double z = (double)center.func_177952_p() + 0.5 + RandomUtils.nextFloat(4.0f) - 2.0;
        boolean starlightMode = controller.getCustomDataTag().func_74779_i("currentMode").equals(STARLIGHT_CATALYST);
        float r = starlightMode ? 0.9f : RandomUtils.nextFloat();
        float g = starlightMode ? 0.9f : RandomUtils.nextFloat();
        float b = starlightMode ? 1.0f : RandomUtils.nextFloat();
        IllumPool.sparkleFX(x, y, z, r, g, b, size, lifeTime);
    }

    protected static void wispFX(TileMultiblockMachineController controller, BlockPos center, float size, float lifeTime) {
        double x = (double)center.func_177958_n() + 0.5 + RandomUtils.nextFloat(4.0f) - 2.0;
        double y = (double)center.func_177956_o() + 0.5 + RandomUtils.nextFloat(1.0f);
        double z = (double)center.func_177952_p() + 0.5 + RandomUtils.nextFloat(4.0f) - 2.0;
        boolean starlightMode = controller.getCustomDataTag().func_74779_i("currentMode").equals(STARLIGHT_CATALYST);
        float r = starlightMode ? 0.9f : RandomUtils.nextFloat();
        float g = starlightMode ? 0.9f : RandomUtils.nextFloat();
        float b = starlightMode ? 1.0f : RandomUtils.nextFloat();
        float gravity = RandomUtils.nextFloat() / 15.0f;
        IllumPool.wispFX(x, y, z, r, g, b, size, gravity, lifeTime);
    }

    protected static void sparkleFX(double x, double y, double z, float r, float g, float b, float size, int lifetime) {
        Botania.proxy.sparkleFX(x, y, z, r, g, b, size, lifetime);
    }

    protected static void wispFX(double x, double y, double z, float r, float g, float b, float size, float gravity, float lifetime) {
        Botania.proxy.wispFX(x, y, z, r, g, b, size, -gravity, lifetime);
    }
}

