/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.machine;

import crafttweaker.util.IEventHandler;
import github.kasuminova.mmce.common.event.Phase;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.mmce.common.itemtype.ChancedIngredientStack;
import github.kasuminova.novaeng.common.crafttweaker.expansion.RecipePrimerHyperNet;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.machine.MachineSpecial;
import github.kasuminova.novaeng.common.tile.machine.GeocentricDrillController;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementEnergy;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeBuilder;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class GeocentricDrill
implements MachineSpecial {
    public static final GeocentricDrill GEOCENTRIC_DRILL = new GeocentricDrill();
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("modularmachinery", "earth_drill");
    public static final ResourceLocation RECIPE_REGISTRY_NAME = new ResourceLocation("modularmachinery", "earth_drill_working");
    public static final int ENERGY_PER_TICK = 8000000;
    public static final int ORE_COUNT = 8;
    public static final int ACCELERATE_MULTIPLIER = 15;
    public static final int MIN_DEPTH = 1000;
    public static final int MAX_DEPTH = 10000;
    public static final int PARALLELISM_PER_DEPTH = 16;
    public static final int COMPUTATION_POINT_PRE_PARALLELISM = 2;
    public static final int MAX_PARALLELISM = 625;
    private final Map<String, ItemStack> rawOres = new Object2ObjectLinkedOpenHashMap();

    private static void onRecipePreTick(RecipeTickEvent event) {
        if (event.phase == Phase.START) {
            TileMultiblockMachineController tileMultiblockMachineController = event.getController();
            if (!(tileMultiblockMachineController instanceof GeocentricDrillController)) {
                return;
            }
            GeocentricDrillController geoDrill = (GeocentricDrillController)tileMultiblockMachineController;
            if (geoDrill.diveOrAscend()) {
                if (!geoDrill.hasModifier("diveOrAscend")) {
                    geoDrill.addModifier("diveOrAscend", new RecipeModifier((RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, 2.0f, 1, false));
                }
                geoDrill.markNoUpdateSync();
            } else if (geoDrill.hasModifier("diveOrAscend")) {
                geoDrill.removeModifier("diveOrAscend");
                geoDrill.markNoUpdateSync();
            }
            return;
        }
        if (event.phase == Phase.END) {
            TileMultiblockMachineController tileMultiblockMachineController = event.getController();
            if (!(tileMultiblockMachineController instanceof GeocentricDrillController)) {
                return;
            }
            GeocentricDrillController geoDrill = (GeocentricDrillController)tileMultiblockMachineController;
            if (geoDrill.getDepth() < 1000.0f) {
                event.preventProgressing("craftcheck.failure.geocentric_drill_depth");
                geoDrill.markNoUpdateSync();
            }
        }
    }

    @Override
    public void preInit(DynamicMachine machine) {
        HyperNetHelper.proxyMachineForHyperNet(machine.getRegistryName());
        machine.setInternalParallelism(625);
        Object2ObjectLinkedOpenHashMap rawOres = new Object2ObjectLinkedOpenHashMap();
        Arrays.stream(OreDictionary.getOreNames()).filter(oreName -> oreName.startsWith("rawOre")).forEach(arg_0 -> GeocentricDrill.lambda$preInit$1((Map)rawOres, arg_0));
        GeocentricDrill.addRFToolsDimShard((Map<String, ItemStack>)rawOres);
        GeocentricDrill.addEnvironmentTechOres((Map<String, ItemStack>)rawOres);
        GeocentricDrill.addGeocentricQuartzCrystalOre((Map<String, ItemStack>)rawOres);
        this.rawOres.clear();
        this.rawOres.putAll((Map<String, ItemStack>)rawOres);
        RecipePrimer primer = RecipeBuilder.newBuilder((String)RECIPE_REGISTRY_NAME.func_110623_a(), (String)REGISTRY_NAME.func_110623_a(), (int)20);
        primer.addEnergyPerTickInput(8000000L);
        float chance = 1.0f / (float)rawOres.size();
        List components = primer.getComponents();
        for (ItemStack ore : rawOres.values()) {
            RequirementItem output = new RequirementItem(IOType.OUTPUT, ore.func_77946_l());
            output.setChance(chance);
            components.add(output);
        }
        RecipePrimerHyperNet.requireComputationPoint(primer, 2.0f);
        primer.build();
    }

    private static void addRFToolsDimShard(Map<String, ItemStack> rawOres) {
        NonNullList genDimShards = OreDictionary.getOres((String)"gemDimensionalShard", (boolean)false);
        if (!genDimShards.isEmpty()) {
            rawOres.put("gemDimensionalShard", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)genDimShards.get(0)), (int)4));
        }
    }

    private static void addGeocentricQuartzCrystalOre(Map<String, ItemStack> rawOres) {
        Item geocentricCrystal = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("contenttweaker", "geocentric_crystal"));
        if (geocentricCrystal != null) {
            rawOres.put("crystalGeocentric", new ItemStack(geocentricCrystal, 1));
        }
    }

    private static void addEnvironmentTechOres(Map<String, ItemStack> rawOres) {
        NonNullList crystalAethium;
        NonNullList crystalIonite;
        NonNullList crystalPladium;
        NonNullList crystalKyronite;
        NonNullList crystalLonsdaleite;
        NonNullList crystalErodium;
        NonNullList crystalLitherite = OreDictionary.getOres((String)"crystalLitherite", (boolean)false);
        if (!crystalLitherite.isEmpty()) {
            rawOres.put("crystalLitherite", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalLitherite.get(0)), (int)4));
        }
        if (!(crystalErodium = OreDictionary.getOres((String)"crystalErodium", (boolean)false)).isEmpty()) {
            rawOres.put("crystalErodium", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalErodium.get(0)), (int)3));
        }
        if (!(crystalLonsdaleite = OreDictionary.getOres((String)"crystalLonsdaleite", (boolean)false)).isEmpty()) {
            rawOres.put("crystalLonsdaleite", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalLonsdaleite.get(0)), (int)2));
        }
        if (!(crystalKyronite = OreDictionary.getOres((String)"crystalKyronite", (boolean)false)).isEmpty()) {
            rawOres.put("crystalKyronite", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalKyronite.get(0)), (int)2));
        }
        if (!(crystalPladium = OreDictionary.getOres((String)"crystalPladium", (boolean)false)).isEmpty()) {
            rawOres.put("crystalPladium", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalPladium.get(0)), (int)2));
        }
        if (!(crystalIonite = OreDictionary.getOres((String)"crystalIonite", (boolean)false)).isEmpty()) {
            rawOres.put("crystalIonite", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalIonite.get(0)), (int)2));
        }
        if (!(crystalAethium = OreDictionary.getOres((String)"crystalAethium", (boolean)false)).isEmpty()) {
            rawOres.put("crystalAethium", ItemUtils.copyStackWithSize((ItemStack)((ItemStack)crystalAethium.get(0)), (int)1));
        }
    }

    public Map<String, ItemStack> getRawOres() {
        return Collections.unmodifiableMap(this.rawOres);
    }

    public MachineRecipe rebuildRecipe(MachineRecipe original, Set<String> accelerateOres) {
        MachineRecipe recipe = new MachineRecipe("", RECIPE_REGISTRY_NAME, REGISTRY_NAME, 10, 0, false, true);
        recipe.addRequirement((ComponentRequirement)new RequirementEnergy(IOType.INPUT, 8000000L));
        float chance = 1.0f / (float)(this.rawOres.size() + accelerateOres.size() * 14);
        ArrayList output = new ArrayList();
        this.rawOres.forEach((oreName, ore) -> output.add(new ChancedIngredientStack(ore.func_77946_l(), accelerateOres.contains(oreName) ? chance * 15.0f : chance)));
        recipe.addRequirement((ComponentRequirement)new RequirementIngredientArray(output, IOType.OUTPUT));
        original.getRecipeEventHandlers().forEach((eventClass, handlerList) -> {
            for (IEventHandler handler : handlerList) {
                recipe.addRecipeEventHandler(eventClass, handler);
            }
        });
        recipe.addRecipeEventHandler(RecipeTickEvent.class, GeocentricDrill::onRecipePreTick);
        return recipe;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return REGISTRY_NAME;
    }

    private static /* synthetic */ void lambda$preInit$1(Map rawOres, String oreName) {
        NonNullList ores = OreDictionary.getOres((String)oreName);
        if (!ores.isEmpty()) {
            ItemStack stack = ((ItemStack)ores.get(0)).func_77946_l();
            stack.func_190920_e(8);
            rawOres.put(oreName, stack);
        }
    }
}

