/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.item.estorage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.data.IAEStack;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.core.CreativeTabNovaEng;
import github.kasuminova.novaeng.common.estorage.EStorageCellHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public abstract class EStorageCell<T extends IAEStack<T>>
extends AEBaseItem
implements IStorageCell<T> {
    protected final DriveStorageLevel level;
    protected final int totalBytes;
    protected final int byteMultiplier;

    public EStorageCell(DriveStorageLevel level, int millionBytes, int byteMultiplier) {
        this.level = level;
        this.totalBytes = millionBytes * 1024 * 1024;
        this.byteMultiplier = byteMultiplier;
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabNovaEng.INSTANCE);
    }

    @SideOnly(value=Side.CLIENT)
    protected void addCheckedInformation(ItemStack stack, World world, List<String> lines, ITooltipFlag advancedTooltips) {
        super.addCheckedInformation(stack, world, lines, advancedTooltips);
        AEApi.instance().client().addCellInformation(EStorageCellHandler.getHandler(stack).getCellInventory(stack, null, this.getChannel()), lines);
        lines.add(I18n.func_135052_a((String)"novaeng.estorage_cell.insert.tip", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"novaeng.estorage_cell.extract.tip", (Object[])new Object[0]));
        if (this.level == DriveStorageLevel.B) {
            lines.add(I18n.func_135052_a((String)"novaeng.estorage_cell.l6.tip", (Object[])new Object[0]));
        }
        if (this.level == DriveStorageLevel.C) {
            lines.add(I18n.func_135052_a((String)"novaeng.estorage_cell.l9.tip", (Object[])new Object[0]));
        }
    }

    public double getIdleDrain() {
        return (double)this.totalBytes / 1024.0 / 1024.0;
    }

    public DriveStorageLevel getLevel() {
        return this.level;
    }

    public int getByteMultiplier() {
        return this.byteMultiplier;
    }

    public int getBytes(@Nonnull ItemStack cellItem) {
        return this.totalBytes;
    }

    public boolean isBlackListed(@Nonnull ItemStack cellItem, @Nonnull T requestedAddition) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(@Nonnull ItemStack i) {
        return true;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }
}

