/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.integration.theoneprobe;

import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.DataProcessor;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStation;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class HyperNetInfoProvider
implements IProbeInfoProvider {
    public static final HyperNetInfoProvider INSTANCE = new HyperNetInfoProvider();

    private HyperNetInfoProvider() {
    }

    public String getID() {
        return "novaeng_core:hypernet_info_provider";
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        if (!blockState.func_177230_c().hasTileEntity(blockState)) {
            return;
        }
        TileEntity te = world.func_175625_s(data.getPos());
        if (!(te instanceof TileMultiblockMachineController)) {
            return;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        if (!RegistryHyperNet.isHyperNetSupported(foundMachine)) {
            return;
        }
        HyperNetInfoProvider.processHyperNetTOP(foundMachine, ctrl, probeInfo);
    }

    private static void processHyperNetTOP(DynamicMachine foundMachine, TileMultiblockMachineController ctrl, IProbeInfo info) {
        ResourceLocation registryName = foundMachine.getRegistryName();
        if (RegistryHyperNet.isComputationCenter(registryName)) {
            ComputationCenter center = ComputationCenter.from((IMachineController)ctrl);
            if (center != null) {
                HyperNetInfoProvider.processCenterTOP(center, info);
            }
            return;
        }
        NetNode node = NetNodeCache.getCache(ctrl, RegistryHyperNet.getNodeType(foundMachine));
        if (node == null) {
            return;
        }
        HyperNetInfoProvider.processNetNodeTOP(node, info);
    }

    private static IProbeInfo newBox(IProbeInfo info) {
        return info.horizontal(info.defaultLayoutStyle().borderColor(Integer.valueOf(-2145480449)));
    }

    private static void processNetNodeTOP(NetNode node, IProbeInfo probeInfo) {
        IProbeInfo box;
        ComputationCenter center = node.getCenter();
        if (center != null) {
            probeInfo.text("{*top.hypernet.online*}");
        } else {
            probeInfo.text("{*top.hypernet.offline*}");
        }
        if (node instanceof DataProcessor) {
            box = HyperNetInfoProvider.newBox(probeInfo);
            HyperNetInfoProvider.processDataProcessorTOP((DataProcessor)node, HyperNetInfoProvider.newVertical(box), HyperNetInfoProvider.newVertical(box));
        } else if (node instanceof ResearchStation) {
            box = HyperNetInfoProvider.newBox(probeInfo);
            HyperNetInfoProvider.processResearchStationTOP((ResearchStation)node, HyperNetInfoProvider.newVertical(box), HyperNetInfoProvider.newVertical(box), probeInfo);
        } else if (node instanceof Database) {
            box = HyperNetInfoProvider.newBox(probeInfo);
            HyperNetInfoProvider.processDatabaseTOP((Database)node, HyperNetInfoProvider.newVertical(box), HyperNetInfoProvider.newVertical(box));
        } else {
            HyperNetInfoProvider.processNetNodeTOPDefault(node, probeInfo);
        }
        if (center != null) {
            box = HyperNetInfoProvider.newBox(probeInfo);
            HyperNetInfoProvider.processCenterStatusTOP(center, HyperNetInfoProvider.newVertical(box), HyperNetInfoProvider.newVertical(box));
        }
    }

    private static void processNetNodeTOPDefault(NetNode node, IProbeInfo probeInfo) {
        double consumption = node.getComputationPointConsumption();
        double provision = node.getComputationPointProvision(1.6777215E7);
        if (consumption <= 0.0 && provision <= 0.0) {
            return;
        }
        IProbeInfo box = HyperNetInfoProvider.newBox(probeInfo);
        IProbeInfo leftInfo = HyperNetInfoProvider.newVertical(box);
        IProbeInfo rightInfo = HyperNetInfoProvider.newVertical(box);
        if (consumption > 0.0) {
            leftInfo.text("{*top.hypernet.computation_point_consumption*}");
            rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatFLOPS(consumption));
        }
        if (provision > 0.0) {
            leftInfo.text("{*top.hypernet.computation_point_generation*}" + provision);
            rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatFLOPS(provision));
        }
    }

    private static void processDataProcessorTOP(DataProcessor processor, IProbeInfo leftInfo, IProbeInfo rightInfo) {
        double maxGeneration = processor.getMaxGeneration();
        double load = Math.min(processor.getComputationalLoad(), maxGeneration);
        float efficiency = processor.getEfficiency();
        int storedHU = processor.getStoredHU();
        float heatPercent = processor.getOverHeatPercent();
        leftInfo.text("{*top.hypernet.processor.generation*}");
        rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatFLOPS(load) + " / " + NovaEngUtils.formatFLOPS(maxGeneration));
        leftInfo.text("{*top.hypernet.processor.load*}");
        rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatPercent(load, maxGeneration));
        leftInfo.text("{*top.hypernet.processor.efficiency*}");
        rightInfo.text(TextFormatting.GREEN + NovaEngUtils.formatPercent(efficiency, 1.0));
        leftInfo.text("{*top.hypernet.processor.heat*}");
        rightInfo.text(TextFormatting.RED + MiscUtils.formatDecimal((double)storedHU) + "HU (" + NovaEngUtils.formatPercent(heatPercent, 1.0) + ")");
    }

    private static IProbeInfo newVertical(IProbeInfo probeInfo) {
        return probeInfo.vertical(probeInfo.defaultLayoutStyle().spacing(0));
    }

    private static void processResearchStationTOP(ResearchStation station, IProbeInfo leftInfo, IProbeInfo rightInfo, IProbeInfo probeInfo) {
        ResearchCognitionData researching = station.getCurrentResearching();
        if (researching == null) {
            leftInfo.text("{*top.hypernet.research_station.current.empty*}");
            return;
        }
        double consumption = station.getComputationPointConsumption();
        leftInfo.text("{*top.hypernet.computation_point_consumption*}");
        rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatFLOPS(consumption));
        leftInfo.text("{*top.hypernet.research_station.current*}");
        rightInfo.text(researching.getTranslatedName());
        double completedPoints = station.getCompletedPoints();
        double requiredPoints = researching.getRequiredPoints();
        float progress = (float)(completedPoints / requiredPoints) * 100.0f;
        String progressStr = NovaEngUtils.formatNumber(Math.round(completedPoints)) + " / " + NovaEngUtils.formatNumber(Math.round(requiredPoints)) + " (" + NovaEngUtils.formatFloat(progress, 2) + "%)";
        HyperNetInfoProvider.newBox(probeInfo).horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text(TextFormatting.AQUA + "{*top.hypernet.research_station.progress*}:  ").progress(Math.round(progress), 100, probeInfo.defaultProgressStyle().prefix(progressStr).filledColor(-870402817).alternateFilledColor(-870412033).borderColor(-870412103).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(120));
    }

    private static void processDatabaseTOP(Database database, IProbeInfo leftInfo, IProbeInfo rightInfo) {
        if (!database.isWorking()) {
            return;
        }
        int researching = database.getAllResearchingCognition().size();
        int size = database.getStoredResearchCognition().size();
        leftInfo.text("{*top.hypernet.database.stored.research*}");
        rightInfo.text(String.format("%s%s %s(%s) / %s%d", TextFormatting.AQUA, size, TextFormatting.YELLOW, researching, TextFormatting.YELLOW, database.getType().getMaxResearchDataStoreSize()));
    }

    private static void processCenterTOP(ComputationCenter center, IProbeInfo probeInfo) {
        if (!center.isWorking()) {
            probeInfo.text("{*top.hypernet.offline*}");
            return;
        }
        probeInfo.text("{*top.hypernet.online*}");
        IProbeInfo box = HyperNetInfoProvider.newBox(probeInfo);
        HyperNetInfoProvider.processCenterStatusTOP(center, HyperNetInfoProvider.newVertical(box), HyperNetInfoProvider.newVertical(box));
    }

    private static void processCenterStatusTOP(ComputationCenter center, IProbeInfo leftInfo, IProbeInfo rightInfo) {
        int connections = center.getConnectedMachineryCount();
        int maxConnections = center.getType().getMaxConnections();
        leftInfo.text("{*top.hypernet.connected*}");
        rightInfo.text(TextFormatting.AQUA + String.valueOf(connections) + " / " + TextFormatting.YELLOW + maxConnections);
        double consumption = center.getComputationPointConsumption();
        double generation = center.getComputationPointGeneration();
        leftInfo.text("{*top.hypernet.computation_point.total*}");
        rightInfo.text(TextFormatting.AQUA + NovaEngUtils.formatFLOPS(consumption) + " / " + NovaEngUtils.formatFLOPS(generation));
    }
}

