/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.integration.theoneprobe;

import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageLevel;
import github.kasuminova.novaeng.common.block.ecotech.estorage.prop.DriveStorageType;
import github.kasuminova.novaeng.common.container.data.EStorageCellData;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageCellDrive;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageController;
import github.kasuminova.novaeng.common.tile.ecotech.estorage.EStorageEnergyCell;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class EStorageInfoProvider
implements IProbeInfoProvider {
    public static final EStorageInfoProvider INSTANCE = new EStorageInfoProvider();

    private EStorageInfoProvider() {
    }

    public String getID() {
        return "novaeng_core:estorage_info_provider";
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData hitData) {
        TileEntity te = world.func_175625_s(hitData.getPos());
        if (te instanceof EStorageEnergyCell) {
            EStorageEnergyCell cell = (EStorageEnergyCell)te;
            EStorageInfoProvider.processEnergyCellInfo(probeInfo, cell);
            return;
        }
        if (te instanceof EStorageCellDrive) {
            EStorageCellDrive drive = (EStorageCellDrive)te;
            EStorageInfoProvider.processCellDriveInfo(probeInfo, drive);
        }
    }

    private static void processCellDriveInfo(IProbeInfo probeInfo, EStorageCellDrive drive) {
        String string;
        String string2;
        IProbeInfo box = EStorageInfoProvider.newBox(probeInfo);
        IProbeInfo leftInfo = EStorageInfoProvider.newVertical(box);
        IProbeInfo rightInfo = EStorageInfoProvider.newVertical(box);
        EStorageController controller = (EStorageController)((Object)drive.getController());
        leftInfo.text("{*top.estorage.drive.status*}");
        if (controller == null) {
            rightInfo.text("{*top.estorage.drive.status.offline*}");
        } else {
            rightInfo.text("{*top.estorage.drive.status.online*}");
        }
        EStorageCellData data = EStorageCellData.from(drive);
        if (data == null) {
            return;
        }
        DriveStorageLevel level = data.level();
        if (controller != null && !drive.isCellSupported(level)) {
            EStorageInfoProvider.newBox(probeInfo).text("{*top.estorage.drive.cell.unsupported*}");
        }
        DriveStorageType type = data.type();
        StringBuilder stringBuilder = new StringBuilder().append("gui.estorage_controller.cell_info.");
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                string2 = "unknown";
                break;
            }
            case ITEM: {
                string2 = "item";
                break;
            }
            case FLUID: {
                string2 = "fluid";
            }
        }
        String typeName = stringBuilder.append(string2).toString();
        switch (level) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EMPTY: {
                string = "unknown";
                break;
            }
            case A: {
                string = "L4";
                break;
            }
            case B: {
                string = "L6";
                break;
            }
            case C: {
                string = "L9";
            }
        }
        String levelName = string;
        leftInfo.text("{*top.estorage.drive.cell*}");
        rightInfo.text(String.format("{*%s*} (%s)", typeName, levelName));
        long usedBytes = data.usedBytes();
        long maxBytes = EStorageCellDrive.getMaxBytes(data);
        leftInfo.text("{*top.estorage.drive.cell.bytes*}");
        rightInfo.text(TextFormatting.YELLOW + String.valueOf(usedBytes) + TextFormatting.BLUE + " / " + TextFormatting.GOLD + maxBytes);
        int usedTypes = data.usedTypes();
        int maxTypes = EStorageCellDrive.getMaxTypes(data);
        leftInfo.text("{*top.estorage.drive.cell.types*}");
        rightInfo.text(TextFormatting.YELLOW + String.valueOf(usedTypes) + TextFormatting.BLUE + " / " + TextFormatting.GOLD + maxTypes);
    }

    private static void processEnergyCellInfo(IProbeInfo probeInfo, EStorageEnergyCell cell) {
        double energyStored = cell.getEnergyStored();
        double maxEnergyStore = cell.getMaxEnergyStore();
        String progressStr = String.format("%sAE / %sAE", NovaEngUtils.formatNumber(Math.round(energyStored)), NovaEngUtils.formatNumber(Math.round(maxEnergyStore)));
        probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).progress(Math.round(energyStored / maxEnergyStore * 200.0), 200L, probeInfo.defaultProgressStyle().prefix(progressStr).filledColor(-868042497).alternateFilledColor(-868041217).borderColor(-862453761).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(120));
    }

    private static IProbeInfo newVertical(IProbeInfo probeInfo) {
        return probeInfo.vertical(probeInfo.defaultLayoutStyle().spacing(0));
    }

    private static IProbeInfo newBox(IProbeInfo info) {
        return info.horizontal(info.defaultLayoutStyle().borderColor(Integer.valueOf(-2145480449)));
    }
}

