/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.integration.theoneprobe;

import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorController;
import github.kasuminova.novaeng.common.tile.ecotech.efabricator.EFabricatorWorker;
import github.kasuminova.novaeng.common.util.ColorUtils;
import java.awt.Color;
import java.util.Deque;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EFabricatorInfoProvider
implements IProbeInfoProvider {
    public static final EFabricatorInfoProvider INSTANCE = new EFabricatorInfoProvider();
    public static final Color LOW_COLOR = new Color(-866844769);
    public static final Color MID_COLOR = new Color(-855638272);
    public static final Color FULL_COLOR = new Color(-855685888);

    private EFabricatorInfoProvider() {
    }

    public String getID() {
        return "novaeng_core:efabricator_info_provider";
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData hitData) {
        TileEntity te = world.func_175625_s(hitData.getPos());
        if (te instanceof EFabricatorWorker) {
            EFabricatorWorker worker = (EFabricatorWorker)te;
            EFabricatorInfoProvider.processWorkerInfo(probeInfo, worker);
        }
    }

    private static void processWorkerInfo(IProbeInfo probeInfo, EFabricatorWorker worker) {
        int maxItemsPerRow;
        IProbeInfo box = EFabricatorInfoProvider.newBox(probeInfo);
        IProbeInfo leftInfo = EFabricatorInfoProvider.newVertical(box);
        IProbeInfo rightInfo = EFabricatorInfoProvider.newVertical(box);
        EFabricatorController controller = (EFabricatorController)((Object)worker.getController());
        leftInfo.text("{*top.efabricator.worker.status*}");
        if (controller == null) {
            rightInfo.text("{*top.efabricator.worker.status.offline*}");
        } else {
            rightInfo.text("{*top.efabricator.worker.status.online*}");
        }
        EFabricatorWorker.CraftingQueue queue = worker.getQueue();
        int queueDepth = worker.getQueueDepth();
        float percent = (float)queue.size() / (float)queueDepth;
        int color = ColorUtils.getGradientColor(new Color[]{LOW_COLOR, LOW_COLOR, LOW_COLOR, MID_COLOR, MID_COLOR, FULL_COLOR, FULL_COLOR}, 204, percent).getRGB();
        int energyCache = worker.getEnergyCache();
        int maxEnergyCache = worker.getMaxEnergyCache();
        String progressStr = String.format("%sAE / %sAE", NovaEngUtils.formatNumber(energyCache), NovaEngUtils.formatNumber(maxEnergyCache));
        box = EFabricatorInfoProvider.newBox(probeInfo).vertical();
        box.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).progress(Math.round((float)energyCache / (float)maxEnergyCache * 80.0f), 80, probeInfo.defaultProgressStyle().prefix(progressStr).filledColor(-868042497).alternateFilledColor(-868041217).borderColor(-862453761).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(120));
        progressStr = String.format("%s / %s", queue.size(), queueDepth);
        IProbeInfo progressLine = box.horizontal(box.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        progressLine.text("{*top.efabricator.worker.queue_status*} ");
        progressLine.horizontal(box.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).progress(Math.round(percent * (float)queueDepth), queueDepth, box.defaultProgressStyle().prefix(progressStr).filledColor(color).alternateFilledColor(EFabricatorInfoProvider.darkenColor(color, 0.8)).borderColor(EFabricatorInfoProvider.lightenColor(color, 0.8)).backgroundColor(-16777216).numberFormat(NumberFormat.NONE).width(queueDepth));
        Deque<EFabricatorWorker.CraftWork> workDeque = queue.getQueue();
        if (workDeque.isEmpty()) {
            return;
        }
        box = EFabricatorInfoProvider.newBox(probeInfo);
        IProbeInfo currentCrafting = box.horizontal(box.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
        currentCrafting.text("{*top.efabricator.worker.current_crafting*}");
        EFabricatorWorker.CraftWork peek = workDeque.peek();
        if (peek == null) {
            return;
        }
        currentCrafting.item(peek.getOutput());
        if (workDeque.size() <= 1) {
            return;
        }
        box = EFabricatorInfoProvider.newBox(probeInfo).vertical().text("{*top.efabricator.worker.enqueued_crafting*}");
        IProbeInfo row = box.horizontal();
        int max = Math.min(workDeque.size() - 2, 32);
        int rowItems = maxItemsPerRow = 8;
        boolean first = true;
        for (EFabricatorWorker.CraftWork work : workDeque) {
            if (rowItems == 0) {
                rowItems = maxItemsPerRow;
                row = box.horizontal();
            }
            if (first) {
                first = false;
                continue;
            }
            row.item(work.getOutput());
            --rowItems;
            if (--max > 0) continue;
            break;
        }
    }

    private static int darkenColor(int color, double factor) {
        int a = color >> 24 & 0xFF;
        int r = (int)((double)(color >> 16 & 0xFF) * factor);
        int g = (int)((double)(color >> 8 & 0xFF) * factor);
        int b = (int)((double)(color & 0xFF) * factor);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int lightenColor(int color, double factor) {
        int a = color >> 24 & 0xFF;
        int r = Math.min(255, (int)((double)(color >> 16 & 0xFF) / factor));
        int g = Math.min(255, (int)((double)(color >> 8 & 0xFF) / factor));
        int b = Math.min(255, (int)((double)(color & 0xFF) / factor));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static IProbeInfo newVertical(IProbeInfo probeInfo) {
        return probeInfo.vertical(probeInfo.defaultLayoutStyle().spacing(0));
    }

    private static IProbeInfo newBox(IProbeInfo info) {
        return info.horizontal(info.defaultLayoutStyle().borderColor(Integer.valueOf(-2145480449)));
    }
}

