/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.integration.ae2.data;

import appeng.crafting.CraftingTreeNode;
import appeng.crafting.CraftingTreeProcess;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeNode;
import github.kasuminova.novaeng.common.util.AEItemStackSet;
import github.kasuminova.novaeng.mixin.ae2.AccessorCraftingTreeProcess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LiteCraftTreeProc
implements Comparable<LiteCraftTreeProc> {
    private final List<LiteCraftTreeNode> inputs;

    public LiteCraftTreeProc(List<LiteCraftTreeNode> inputs) {
        this.inputs = inputs;
    }

    @Nullable
    public static LiteCraftTreeProc of(CraftingTreeProcess process) {
        AccessorCraftingTreeProcess accessor = (AccessorCraftingTreeProcess)process;
        ArrayList<LiteCraftTreeNode> inputs = new ArrayList<LiteCraftTreeNode>();
        LiteCraftTreeProc proc = new LiteCraftTreeProc(inputs);
        for (CraftingTreeNode node : accessor.getNodes().keySet()) {
            inputs.add(LiteCraftTreeNode.of(node, proc));
        }
        return inputs.isEmpty() ? null : proc;
    }

    public static LiteCraftTreeProc fromBuffer(ByteBuf buf, AEItemStackSet stackSet) {
        int size = buf.readByte();
        ArrayList<LiteCraftTreeNode> inputs = new ArrayList<LiteCraftTreeNode>();
        LiteCraftTreeProc proc = new LiteCraftTreeProc(inputs);
        for (int i = 0; i < size; ++i) {
            inputs.add(LiteCraftTreeNode.fromBuffer(buf, stackSet, proc));
        }
        return proc;
    }

    public void writeToBuffer(ByteBuf buf, AEItemStackSet stackSet) {
        if (this.inputs.size() > 127) {
            throw new IllegalStateException("Too many inputs for a single node");
        }
        buf.writeByte(this.inputs.size());
        this.inputs.forEach(node -> node.writeToBuffer(buf, stackSet));
    }

    public void sort() {
        this.inputs.sort(Comparator.reverseOrder());
        for (LiteCraftTreeNode input : this.inputs) {
            for (LiteCraftTreeProc proc : input.inputs()) {
                proc.sort();
            }
        }
    }

    @Override
    public int compareTo(@Nonnull LiteCraftTreeProc o) {
        return Integer.compare(LiteCraftTreeProc.diveToDeep(this, 0, new LiteCraftTreeNode.DepthRecorder()), LiteCraftTreeProc.diveToDeep(o, 0, new LiteCraftTreeNode.DepthRecorder()));
    }

    public static int diveToDeep(LiteCraftTreeProc proc, int depth, LiteCraftTreeNode.DepthRecorder recorder) {
        for (LiteCraftTreeNode node : proc.inputs) {
            for (LiteCraftTreeProc subProc : node.inputs()) {
                int newDepth = depth + 1;
                recorder.dive(newDepth);
                LiteCraftTreeProc.diveToDeep(subProc, newDepth, recorder);
            }
        }
        return recorder.getDepth();
    }

    public int totalNodes() {
        int nodeCount = this.inputs.size();
        for (LiteCraftTreeNode node : this.inputs) {
            for (LiteCraftTreeProc input : node.inputs()) {
                nodeCount += input.totalNodes();
            }
        }
        return nodeCount;
    }

    public String toString() {
        return "LiteCraftTreeProc[" + "inputs=" + this.inputs + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equals(((LiteCraftTreeProc)arg0).inputs, this.inputs);
        {
        }
    }

    public List<LiteCraftTreeNode> inputs() {
        return this.inputs;
    }
}

