/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.integration.ae2.data;

import appeng.api.storage.data.IAEItemStack;
import appeng.crafting.CraftingTreeNode;
import appeng.crafting.CraftingTreeProcess;
import github.kasuminova.novaeng.common.integration.ae2.data.LiteCraftTreeProc;
import github.kasuminova.novaeng.common.util.AEItemStackSet;
import github.kasuminova.novaeng.common.util.ByteBufUtils;
import github.kasuminova.novaeng.mixin.ae2.AccessorCraftingTreeNode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class LiteCraftTreeNode
implements Comparable<LiteCraftTreeNode> {
    private final LiteCraftTreeProc parent;
    private final IAEItemStack output;
    private final List<LiteCraftTreeProc> inputs;
    private final long missing;
    private boolean missingCached = false;
    private boolean missingCache = false;

    public LiteCraftTreeNode(LiteCraftTreeProc parent, IAEItemStack output, List<LiteCraftTreeProc> inputs, long missing) {
        this.parent = parent;
        this.output = output;
        this.inputs = inputs;
        this.missing = missing;
    }

    public static LiteCraftTreeNode of(CraftingTreeNode node, LiteCraftTreeProc parent) {
        AccessorCraftingTreeNode accessor = (AccessorCraftingTreeNode)node;
        ArrayList<LiteCraftTreeProc> inputs = new ArrayList<LiteCraftTreeProc>();
        for (CraftingTreeProcess process : accessor.getNodes()) {
            LiteCraftTreeProc proc = LiteCraftTreeProc.of(process);
            if (proc == null) continue;
            inputs.add(proc);
        }
        return new LiteCraftTreeNode(parent, (IAEItemStack)accessor.getWhat().copy().setCraftable(false), inputs, accessor.getMissing());
    }

    public static LiteCraftTreeNode fromBuffer(ByteBuf buf, AEItemStackSet stackSet, LiteCraftTreeProc parent) {
        int stackID = (int)ByteBufUtils.readVarLong(buf);
        IAEItemStack output = stackSet.get(stackID);
        long stackSize = ByteBufUtils.readVarLong(buf);
        output.setStackSize(stackSize);
        int size = buf.readByte();
        ArrayList<LiteCraftTreeProc> inputs = new ArrayList<LiteCraftTreeProc>(size);
        for (int i = 0; i < size; ++i) {
            inputs.add(LiteCraftTreeProc.fromBuffer(buf, stackSet));
        }
        long missing = ByteBufUtils.readVarLong(buf);
        return new LiteCraftTreeNode(parent, output, inputs, missing);
    }

    public void writeToBuffer(ByteBuf buf, AEItemStackSet stackSet) {
        if (this.inputs.size() > 127) {
            throw new IllegalStateException("Too many inputs for a single node");
        }
        int stackID = stackSet.add(this.output);
        ByteBufUtils.writeVarLong(buf, stackID);
        long stackSize = this.output.getStackSize();
        ByteBufUtils.writeVarLong(buf, stackSize);
        buf.writeByte(this.inputs.size());
        this.inputs.forEach(input -> input.writeToBuffer(buf, stackSet));
        ByteBufUtils.writeVarLong(buf, this.missing);
    }

    public void sort() {
        this.inputs.sort(Comparator.reverseOrder());
        for (LiteCraftTreeProc input : this.inputs) {
            input.sort();
            for (LiteCraftTreeNode subNode : input.inputs()) {
                subNode.sort();
            }
        }
    }

    @Override
    public int compareTo(@Nonnull LiteCraftTreeNode o) {
        return Integer.compare(LiteCraftTreeNode.diveToDeep(this, 0, new DepthRecorder()), LiteCraftTreeNode.diveToDeep(o, 0, new DepthRecorder()));
    }

    public static int diveToDeep(LiteCraftTreeNode node, int depth, DepthRecorder recorder) {
        for (LiteCraftTreeProc input : node.inputs) {
            for (LiteCraftTreeNode subNode : input.inputs()) {
                int newDepth = depth + 1;
                recorder.dive(newDepth);
                LiteCraftTreeNode.diveToDeep(subNode, newDepth, recorder);
            }
        }
        return recorder.getDepth();
    }

    public int totalProcessors() {
        int size = this.inputs.size();
        for (LiteCraftTreeProc input : this.inputs) {
            for (LiteCraftTreeNode node : input.inputs()) {
                size += node.totalProcessors();
            }
        }
        return size;
    }

    public int getRenderExpandNodes() {
        int size = Math.max(this.inputs.size() - 1, 0);
        for (LiteCraftTreeProc input : this.inputs) {
            size += Math.max(input.inputs().size() - 1, 0);
            for (LiteCraftTreeNode node : input.inputs()) {
                size += node.getRenderExpandNodes();
            }
        }
        return size;
    }

    public int getLastNodeRenderExpandNodes() {
        if (this.inputs.isEmpty()) {
            return 0;
        }
        LiteCraftTreeProc proc = this.inputs.get(this.inputs.size() - 1);
        List<LiteCraftTreeNode> subNodes = proc.inputs();
        if (subNodes.isEmpty()) {
            return 0;
        }
        LiteCraftTreeNode subNode = subNodes.get(subNodes.size() - 1);
        return subNode.getRenderExpandNodes();
    }

    public LiteCraftTreeNode withMissingOnly() {
        if (!LiteCraftTreeNode.isMissing(this)) {
            return null;
        }
        ArrayList<LiteCraftTreeProc> missingInputs = new ArrayList<LiteCraftTreeProc>();
        for (LiteCraftTreeProc input : this.inputs) {
            ArrayList<LiteCraftTreeNode> missingSubNodes = new ArrayList<LiteCraftTreeNode>();
            for (LiteCraftTreeNode subNode : input.inputs()) {
                if (!LiteCraftTreeNode.isMissing(subNode)) continue;
                missingSubNodes.add(subNode.withMissingOnly());
            }
            if (missingSubNodes.isEmpty()) continue;
            missingInputs.add(new LiteCraftTreeProc(missingSubNodes));
        }
        LiteCraftTreeNode node = new LiteCraftTreeNode(this.parent, this.output, missingInputs, this.missing);
        node.missingCached = true;
        node.missingCache = true;
        return node;
    }

    public LiteCraftTreeProc parent() {
        return this.parent;
    }

    public IAEItemStack output() {
        return this.output;
    }

    public List<LiteCraftTreeProc> inputs() {
        return this.inputs;
    }

    public long missing() {
        return this.missing;
    }

    public static boolean isMissing(LiteCraftTreeNode node) {
        if (node.missingCached) {
            return node.missingCache;
        }
        if (node.missing() > 0L) {
            node.missingCached = true;
            node.missingCache = true;
            return true;
        }
        for (LiteCraftTreeProc input : node.inputs()) {
            for (LiteCraftTreeNode subNode : input.inputs()) {
                if (!LiteCraftTreeNode.isMissing(subNode)) continue;
                node.missingCache = true;
                node.missingCached = true;
                return true;
            }
        }
        node.missingCached = true;
        node.missingCache = false;
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LiteCraftTreeNode that = (LiteCraftTreeNode)obj;
        return Objects.equals(this.output, that.output) && Objects.equals(this.inputs, that.inputs) && this.missing == that.missing;
    }

    public int hashCode() {
        return Objects.hash(this.output, this.inputs, this.missing);
    }

    public String toString() {
        return "LiteCraftTreeNode[output=" + this.output + ", inputs=" + this.inputs + ", missing=" + this.missing + ']';
    }

    public static class DepthRecorder {
        private int depth;

        void dive(int depth) {
            this.depth = Math.max(this.depth, depth);
        }

        public int getDepth() {
            return this.depth;
        }
    }
}

