/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.upgrade;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.upgrade.MachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.upgrade.DataProcessorModule;
import github.kasuminova.novaeng.common.hypernet.old.upgrade.type.ProcessorModuleCPUType;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import github.kasuminova.novaeng.common.util.RandomUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenRegister
@ZenClass(value="novaeng.hypernet.upgrade.ProcessorModuleCPU")
public class ProcessorModuleCPU
extends DataProcessorModule {
    protected final ProcessorModuleCPUType moduleType = RegistryHyperNet.getDataProcessorModuleCPUType(this.getType());

    public ProcessorModuleCPU(UpgradeType type) {
        super(type);
    }

    public static List<ProcessorModuleCPU> filter(Collection<List<MachineUpgrade>> upgradeLists) {
        ArrayList<ProcessorModuleCPU> list = new ArrayList<ProcessorModuleCPU>();
        for (List<MachineUpgrade> upgradeList : upgradeLists) {
            for (MachineUpgrade upgrade : upgradeList) {
                if (!(upgrade instanceof ProcessorModuleCPU)) continue;
                ProcessorModuleCPU cpu = (ProcessorModuleCPU)upgrade;
                if (cpu.maxDurability == 0) {
                    cpu.initDurability();
                }
                if (cpu.durability <= 0) continue;
                list.add(cpu);
            }
        }
        return list;
    }

    public double calculate(boolean doCalculate, double maxGeneration) {
        if (this.durability <= 0 && this.maxDurability != 0) {
            return 0.0;
        }
        float efficiency = this.getEfficiency();
        double generationBase = (double)efficiency * this.getComputationPointGeneration();
        double left = Math.min(generationBase - maxGeneration, generationBase);
        if (left <= 0.0) {
            if (doCalculate && RandomUtils.nextFloat() <= 0.005f) {
                --this.durability;
                this.writeNBTToItem();
            }
            return generationBase;
        }
        double trueGenerated = generationBase - left;
        if (doCalculate && (double)RandomUtils.nextFloat() <= (double)0.005f * (trueGenerated / generationBase)) {
            --this.durability;
            this.writeNBTToItem();
        }
        return trueGenerated;
    }

    public float getEfficiency() {
        if (this.maxDurability == 0) {
            return 1.0f;
        }
        float durabilityPercent = (float)this.durability / (float)this.maxDurability;
        if (durabilityPercent >= 0.25f) {
            return 1.0f;
        }
        return Math.min(Math.max(durabilityPercent + 0.75f, 0.75f), 1.0f);
    }

    @Override
    public int getEnergyConsumption() {
        return this.moduleType.getEnergyConsumption();
    }

    @Override
    protected void initDurability() {
        int min = this.moduleType.getMinDurability();
        int max = this.moduleType.getMaxDurability();
        this.durability = this.maxDurability = min + RandomUtils.nextInt(max - min);
        this.writeNBTToItem();
    }

    @ZenGetter(value="computationalPointGeneration")
    public double getComputationPointGeneration() {
        return this.moduleType.getComputationPointGeneration();
    }

    public List<String> getDescriptions() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.cpu.tip.0", (Object[])new Object[0]));
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.cpu.tip.1", (Object[])new Object[0]));
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.cpu.tip.2", (Object[])new Object[0]));
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.cpu.generate", (Object[])new Object[]{NovaEngUtils.formatFLOPS(this.calculate(false, this.getComputationPointGeneration())), NovaEngUtils.formatPercent(this.getEfficiency(), 1.0)}));
        this.getEnergyDurabilityTip(desc, this.moduleType);
        return desc;
    }

    public List<String> getBusGUIDescriptions() {
        ArrayList<String> desc = new ArrayList<String>();
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.cpu.generate", (Object[])new Object[]{NovaEngUtils.formatFLOPS(this.calculate(false, this.getComputationPointGeneration())), NovaEngUtils.formatPercent(this.getEfficiency(), 1.0)}));
        this.getEnergyDurabilityTip(desc, this.moduleType);
        return desc;
    }

    public ProcessorModuleCPU copy(ItemStack parentStack) {
        ProcessorModuleCPU upgrade = new ProcessorModuleCPU(this.getType());
        upgrade.eventProcessor.putAll(this.eventProcessor);
        upgrade.parentStack = parentStack;
        upgrade.durability = this.durability;
        upgrade.maxDurability = this.maxDurability;
        return upgrade;
    }

    @Override
    public boolean upgradeEquals(Object obj) {
        if (!(obj instanceof ProcessorModuleCPU)) {
            return false;
        }
        return this.moduleType.equals(((ProcessorModuleCPU)((Object)obj)).moduleType);
    }
}

