/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.upgrade;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.upgrade.DynamicMachineUpgrade;
import github.kasuminova.mmce.common.upgrade.UpgradeType;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.upgrade.type.ProcessorModuleType;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="novaeng.hypernet.upgrade.ProcessorModuleType")
public abstract class DataProcessorModule
extends DynamicMachineUpgrade {
    protected int durability = 0;
    protected int maxDurability = 0;

    public DataProcessorModule(UpgradeType type) {
        super(type);
    }

    @ZenGetter(value="energyConsumption")
    public abstract int getEnergyConsumption();

    protected void getEnergyDurabilityTip(List<String> desc, ProcessorModuleType moduleType) {
        desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.energy.tip", (Object[])new Object[]{MiscUtils.formatNumber((long)this.getEnergyConsumption()) + " RF"}));
        if (this.maxDurability == 0) {
            desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.durability.unknown.tip", (Object[])new Object[]{moduleType.getMinDurability(), moduleType.getMaxDurability()}));
        } else {
            desc.add(I18n.func_135052_a((String)"upgrade.data_processor.module.durability.tip", (Object[])new Object[]{this.durability, this.maxDurability, NovaEngUtils.formatPercent(this.durability, this.maxDurability)}));
        }
    }

    public void readItemNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("maxDurability")) {
            if (tag.func_74764_b("durability")) {
                this.durability = tag.func_74762_e("durability");
            }
            this.maxDurability = tag.func_74762_e("maxDurability");
        }
    }

    protected abstract void initDurability();

    public NBTTagCompound writeItemNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.maxDurability != 0) {
            tag.func_74768_a("durability", this.durability);
            tag.func_74768_a("maxDurability", this.maxDurability);
        }
        return tag;
    }

    public void writeNBTToItem() {
        if (this.parentBus != null && this.isValid()) {
            this.parentBus.markNoUpdateSync();
        }
    }

    @ZenGetter(value="durability")
    public int getDurability() {
        return this.durability;
    }

    @ZenSetter(value="durability")
    public void setDurability(int durability) {
        this.durability = durability;
    }

    @ZenGetter(value="maxDurability")
    public int getMaxDurability() {
        return this.maxDurability;
    }

    @ZenSetter(value="maxDurability")
    public void setMaxDurability(int maxDurability) {
        this.maxDurability = maxDurability;
    }

    public boolean upgradeEquals(Object obj) {
        if (!(obj instanceof DataProcessorModule)) {
            return false;
        }
        return this.type.equals((Object)((DataProcessorModule)((Object)obj)).type);
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

