/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.research;

import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleResearchData
implements Serializable {
    private final String researchName;
    private final float techLevel;
    private final double requiredPoints;
    private final double minComputationPointPerTick;
    private final List<String> descriptions;
    private final List<String> unlockedDescriptions;
    private final List<String> dependencies;

    public SimpleResearchData(String researchName, float techLevel, double requiredPoints, double minComputationPointPerTick, List<String> descriptions, List<String> unlockedDescriptions, List<String> dependencies) {
        this.researchName = researchName;
        this.techLevel = techLevel;
        this.requiredPoints = requiredPoints;
        this.minComputationPointPerTick = minComputationPointPerTick;
        this.descriptions = descriptions;
        this.unlockedDescriptions = unlockedDescriptions;
        this.dependencies = dependencies;
    }

    public static SimpleResearchData of(ResearchCognitionData data) {
        return new SimpleResearchData(data.getTranslatedName().replaceAll("\u00a7.", ""), data.getTechLevel(), data.getRequiredPoints(), data.getMinComputationPointPerTick(), data.getDescriptions().stream().map(desc -> desc.replaceAll("\u00a7.", "")).collect(Collectors.toList()), data.getUnlockedDescriptions().stream().map(desc -> desc.replaceAll("\u00a7.", "")).collect(Collectors.toList()), data.getDependencies().stream().map(dep -> dep.getTranslatedName().replaceAll("\u00a7.", "")).collect(Collectors.toList()));
    }

    public String getResearchName() {
        return this.researchName;
    }

    public float getTechLevel() {
        return this.techLevel;
    }

    public double getRequiredPoints() {
        return this.requiredPoints;
    }

    public double getMinComputationPointPerTick() {
        return this.minComputationPointPerTick;
    }

    public List<String> getDescriptions() {
        return this.descriptions;
    }

    public List<String> getUnlockedDescriptions() {
        return this.unlockedDescriptions;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }
}

