/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.research;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.novaeng.NovaEngineeringCore;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.handler.HyperNetEventHandler;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchStationType;
import github.kasuminova.novaeng.common.network.PktResearchTaskComplete;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.ResearchStation")
public class ResearchStation
extends NetNode {
    private final ResearchStationType type;
    private ResearchCognitionData currentResearching = null;
    private UUID taskProvider = null;
    private double completedPoints = 0.0;
    private double consumption = 0.0;

    public ResearchStation(TileMultiblockMachineController owner) {
        super(owner);
        this.type = RegistryHyperNet.getResearchStationType(Objects.requireNonNull(owner.getFoundMachine()).getRegistryName().func_110623_a());
    }

    @ZenMethod
    public void onRecipeCheck(RecipeCheckEvent event) {
        if (this.centerPos == null || this.center == null) {
            event.setFailed("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.currentResearching == null) {
            event.setFailed("\u7ec8\u7aef\u5c1a\u672a\u53d1\u914d\u4efb\u52a1\uff01");
            return;
        }
        float techLevel = this.currentResearching.getTechLevel();
        if (this.type.getMaxTechLevel() < techLevel) {
            event.setFailed("\u79d1\u6280\u7b49\u7ea7\u4e0d\u8db3\uff01\uff08\u7814\u7a76\u7ad9\u7b49\u7ea7\uff1a" + this.type.getMaxTechLevel() + "\uff0c\u8981\u6c42\uff1a" + techLevel + "\uff09");
            return;
        }
        double required = Math.min(this.getComputationLeft(), this.currentResearching.getMinComputationPointPerTick());
        if (this.center.getComputationPointGeneration() < required) {
            event.setFailed("\u7b97\u529b\u4e0d\u8db3\uff01\u9884\u671f\uff1a" + NovaEngUtils.formatFLOPS(required) + "\uff0c\u5f53\u524d\uff1a" + NovaEngUtils.formatFLOPS(this.center.getComputationPointGeneration()));
            return;
        }
        Collection<Database> nodes = this.center.getNode(Database.class);
        if (nodes.isEmpty()) {
            event.setFailed("\u8ba1\u7b97\u7f51\u7edc\u4e2d\u672a\u627e\u5230\u6570\u636e\u5e93\uff01");
            return;
        }
        if (nodes.stream().map(Database.class::cast).noneMatch(database -> database.hasDatabaseSpace(this.currentResearching))) {
            event.setFailed("\u7f51\u7edc\u4e2d\u6240\u6709\u7684\u6570\u636e\u5e93\u5b58\u50a8\u5df2\u6ee1\uff01");
        }
    }

    @ZenMethod
    public void onWorkingTick(FactoryRecipeTickEvent event) {
        if (this.centerPos == null) {
            event.setFailed(true, "\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.currentResearching == null) {
            event.setFailed(true, "\u7ec8\u7aef\u5c1a\u672a\u53d1\u914d\u4efb\u52a1\uff01");
            return;
        }
        if (this.center == null) {
            event.preventProgressing("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.checkCompleted(event)) {
            return;
        }
        double required = Math.min(this.getComputationLeft(), this.currentResearching.getMinComputationPointPerTick());
        double consumed = this.center.consumeComputationPoint(required);
        if (consumed < required) {
            event.preventProgressing("\u7b97\u529b\u4e0d\u8db3\uff01\u9884\u671f\uff1a" + NovaEngUtils.formatFLOPS(required) + "\uff0c\u5f53\u524d\uff1a" + NovaEngUtils.formatFLOPS(consumed));
        } else {
            this.doResearch(event, consumed);
        }
    }

    protected boolean checkCompleted(FactoryRecipeTickEvent event) {
        double left = this.getComputationLeft();
        if (left <= 0.0) {
            this.completeRecipe(event.getFactoryRecipeThread());
            this.sendCompleteToastToPlayer();
            this.writeNBT();
            return true;
        }
        return false;
    }

    private double getComputationLeft() {
        if (this.currentResearching == null) {
            return 0.0;
        }
        return this.currentResearching.getRequiredPoints() - this.completedPoints;
    }

    protected void doResearch(FactoryRecipeTickEvent event, double consumed) {
        if (this.checkCompleted(event)) {
            return;
        }
        this.completedPoints += consumed;
        double baseConsumption = this.currentResearching.getMinComputationPointPerTick();
        this.consumption = Math.min(baseConsumption, this.getComputationLeft());
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        int totalTick = activeRecipe.getTotalTick();
        activeRecipe.setTick(Math.max((int)(this.getProgressPercent() * (double)totalTick) - 1, 0));
        event.getRecipeThread().setStatus(CraftingStatus.SUCCESS).setStatusInfo("\u7814\u7a76\u4e2d...");
        HyperNetEventHandler.addTickEndAction(() -> this.doExtraResearch(Math.min(this.center.getComputationPointGeneration() - this.center.getComputationPointConsumption(), Math.min(baseConsumption * 4.0, this.getComputationLeft()))));
    }

    protected void doExtraResearch(double maxConsumption) {
        if (this.center != null) {
            double consumed = this.center.consumeComputationPoint(maxConsumption);
            this.completedPoints += consumed;
            this.consumption += consumed;
        }
        this.writeResearchProgressToDatabase();
        this.writeNBT();
    }

    public void completeRecipe(FactoryRecipeThread thread) {
        ActiveMachineRecipe recipe = thread.getActiveRecipe();
        recipe.setTick(recipe.getTotalTick() + 1);
        Collection<Database> databases = this.center.getNode(Database.class);
        if (databases.isEmpty()) {
            return;
        }
        ResearchCognitionData data = this.currentResearching;
        if (data == null) {
            return;
        }
        ModularMachinery.EXECUTE_MANAGER.addSyncTask(() -> {
            Database database2;
            Iterator iterator = databases.iterator();
            while (iterator.hasNext() && !(database2 = (Database)iterator.next()).storeResearchCognitionData(data)) {
            }
            databases.forEach(database -> database.getAllResearchingCognition().removeDouble((Object)data));
            this.resetResearchTask();
        });
    }

    public void sendCompleteToastToPlayer() {
        if (this.taskProvider == null) {
            return;
        }
        MinecraftServer server = this.owner.func_145831_w().func_73046_m();
        if (server == null) {
            return;
        }
        EntityPlayerMP player = server.func_184103_al().func_177451_a(this.taskProvider);
        if (player == null) {
            return;
        }
        NovaEngineeringCore.NET_CHANNEL.sendTo((IMessage)new PktResearchTaskComplete(this.currentResearching), player);
    }

    public void writeResearchProgressToDatabase() {
        if (this.currentResearching == null) {
            return;
        }
        for (Database database : this.center.getNode(Database.class)) {
            if (database.writeResearchingData(this.currentResearching, this.completedPoints)) break;
        }
    }

    public void resetResearchTask() {
        this.currentResearching = null;
        this.completedPoints = 0.0;
        this.consumption = 0.0;
    }

    @Override
    @ZenMethod
    public void onMachineTick() {
        super.onMachineTick();
        if (!this.isWorking()) {
            this.consumption = 0.0;
        }
    }

    public void provideTask(ResearchCognitionData data, EntityPlayer taskProvider) {
        this.currentResearching = data;
        if (data == null) {
            this.completedPoints = 0.0;
            this.taskProvider = null;
            this.writeNBT();
            return;
        }
        this.taskProvider = taskProvider.func_110124_au();
        this.consumption = data.getMinComputationPointPerTick();
        double progress = this.center.getNode(Database.class).stream().map(database -> database.getResearchingData(data)).filter(d -> d != -1.0).findFirst().orElse(-1.0);
        if (progress == -1.0) {
            for (Database database2 : this.center.getNode(Database.class)) {
                if (database2.writeResearchingData(data, 0.0)) break;
            }
            progress = 0.0;
        }
        this.completedPoints = progress;
        this.writeNBT();
    }

    @Override
    public boolean isWorking() {
        TileMultiblockMachineController tileMultiblockMachineController = this.owner;
        if (!(tileMultiblockMachineController instanceof TileFactoryController)) {
            return false;
        }
        TileFactoryController factory = (TileFactoryController)tileMultiblockMachineController;
        FactoryRecipeThread thread = (FactoryRecipeThread)factory.getCoreRecipeThreads().get("novaeng.hypernet.research_station.hypercol");
        return this.owner.isWorking() && thread != null && thread.isWorking();
    }

    @Override
    public void readNBT(NBTTagCompound customData) {
        super.readNBT(customData);
        this.consumption = customData.func_74769_h("consumption");
        this.currentResearching = RegistryHyperNet.getResearchCognitionData(customData.func_74779_i("researching"));
        this.completedPoints = customData.func_74769_h("completedPoints");
        if (customData.func_74764_b("taskProvider")) {
            this.taskProvider = UUID.fromString(customData.func_74779_i("taskProvider"));
        }
    }

    @Override
    public void writeNBT() {
        super.writeNBT();
        NBTTagCompound tag = this.owner.getCustomDataTag();
        tag.func_74780_a("consumption", this.consumption);
        if (this.currentResearching != null) {
            tag.func_74778_a("researching", this.currentResearching.getResearchName());
            tag.func_74780_a("completedPoints", this.completedPoints);
        }
        if (this.taskProvider != null) {
            tag.func_74778_a("taskProvider", this.taskProvider.toString());
        }
    }

    @Override
    public int getNodeMaxPresences() {
        return 1;
    }

    @Override
    public double getComputationPointConsumption() {
        return this.consumption;
    }

    @ZenGetter(value="type")
    public ResearchStationType getType() {
        return this.type;
    }

    @ZenGetter(value="currentResearching")
    public ResearchCognitionData getCurrentResearching() {
        return this.currentResearching;
    }

    @ZenGetter(value="completedPoints")
    public double getCompletedPoints() {
        return this.completedPoints;
    }

    public ResearchStation setCompletedPoints(double completedPoints) {
        this.completedPoints = completedPoints;
        return this;
    }

    @ZenGetter(value="progressPercent")
    public double getProgressPercent() {
        if (this.currentResearching == null) {
            return 0.0;
        }
        return this.completedPoints / this.currentResearching.getRequiredPoints();
    }
}

