/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.research;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="novaeng.hypernet.research.ResearchCognitionData")
public class ResearchCognitionData {
    private final String researchName;
    private final String translatedName;
    private final ItemStack previewStack;
    private final float techLevel;
    private final double requiredPoints;
    private final double minComputationPointPerTick;
    private boolean hideByDefault = false;
    private final boolean cycleResearch;
    private final int maxCycle;
    private final List<String> descriptions;
    private final List<String> unlockedDescriptions;
    private final List<ResearchCognitionData> dependencies;
    private final Object2IntOpenHashMap<ResearchCognitionData> cycleDependencies = new Object2IntOpenHashMap();

    public ResearchCognitionData(String researchName, String translatedName, ItemStack previewStack, float techLevel, double requiredPoints, double minComputationPointPerTick, List<String> descriptions, List<String> unlockedDescriptions, List<ResearchCognitionData> dependencies) {
        this.researchName = researchName;
        this.previewStack = previewStack.func_190916_E() != 1 ? ItemUtils.copyStackWithSize((ItemStack)previewStack, (int)1) : previewStack;
        this.techLevel = techLevel;
        this.requiredPoints = requiredPoints;
        this.minComputationPointPerTick = minComputationPointPerTick;
        this.dependencies = dependencies;
        this.cycleResearch = false;
        this.maxCycle = 0;
        this.translatedName = translatedName;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.descriptions = descriptions;
            this.unlockedDescriptions = unlockedDescriptions;
        } else {
            this.descriptions = new ArrayList<String>();
            this.unlockedDescriptions = new ArrayList<String>();
        }
    }

    public ResearchCognitionData(String researchName, String translatedName, ItemStack previewStack, float techLevel, double requiredPoints, double minComputationPointPerTick, List<String> descriptions, List<String> unlockedDescriptions, List<ResearchCognitionData> dependencies, int maxCycle) {
        this.researchName = researchName;
        this.previewStack = previewStack.func_190916_E() != 1 ? ItemUtils.copyStackWithSize((ItemStack)previewStack, (int)1) : previewStack;
        this.techLevel = techLevel;
        this.requiredPoints = requiredPoints;
        this.minComputationPointPerTick = minComputationPointPerTick;
        this.dependencies = dependencies;
        this.cycleResearch = true;
        this.maxCycle = maxCycle;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.translatedName = translatedName;
            this.descriptions = descriptions;
            this.unlockedDescriptions = unlockedDescriptions;
        } else {
            this.translatedName = "";
            this.descriptions = new ArrayList<String>();
            this.unlockedDescriptions = new ArrayList<String>();
        }
    }

    @ZenMethod
    public static ResearchCognitionData create(String researchName, String translatedName, IItemStack previewStackCT, float techLevel, double requiredPoints, double minComputationPointPerTick, String[] descriptions, String[] unlockedDescriptions, String[] dependenciesArr) {
        List<ResearchCognitionData> dependencies = Arrays.stream(dependenciesArr).map(RegistryHyperNet::getResearchCognitionData).filter(Objects::nonNull).collect(Collectors.toList());
        return new ResearchCognitionData(researchName, translatedName, CraftTweakerMC.getItemStack((IItemStack)previewStackCT), techLevel, requiredPoints, minComputationPointPerTick, Arrays.asList(descriptions), Arrays.asList(unlockedDescriptions), dependencies);
    }

    @ZenMethod
    public static ResearchCognitionData createCycle(String researchName, String translatedName, IItemStack previewStackCT, float techLevel, double requiredPoints, double minComputationPointPerTick, String[] descriptions, String[] unlockedDescriptions, String[] dependenciesArr, int maxCycle) {
        List<ResearchCognitionData> dependencies = Arrays.stream(dependenciesArr).map(RegistryHyperNet::getResearchCognitionData).filter(Objects::nonNull).collect(Collectors.toList());
        return new ResearchCognitionData(researchName, translatedName, CraftTweakerMC.getItemStack((IItemStack)previewStackCT), techLevel, requiredPoints, minComputationPointPerTick, Arrays.asList(descriptions), Arrays.asList(unlockedDescriptions), dependencies, maxCycle);
    }

    @ZenMethod
    public ResearchCognitionData addCycleDependence(String researchName, int minCycle) {
        ResearchCognitionData data = RegistryHyperNet.getResearchCognitionData(researchName);
        if (data != null) {
            this.cycleDependencies.addTo((Object)data, minCycle);
        }
        return this;
    }

    @ZenMethod
    public ResearchCognitionData addCycleDependence(ResearchCognitionData data, int minCycle) {
        this.cycleDependencies.addTo((Object)data, minCycle);
        return this;
    }

    @ZenGetter(value="researchName")
    public String getResearchName() {
        return this.researchName;
    }

    @ZenGetter(value="translatedName")
    public String getTranslatedName() {
        return this.translatedName;
    }

    public ItemStack getPreviewStack() {
        return this.previewStack;
    }

    @ZenGetter(value="previewStack")
    public IItemStack getPreviewStackCT() {
        return CraftTweakerMC.getIItemStack((ItemStack)this.previewStack);
    }

    @ZenGetter(value="techLevel")
    public float getTechLevel() {
        return this.techLevel;
    }

    @ZenGetter(value="requiredPoints")
    public double getRequiredPoints() {
        return this.requiredPoints;
    }

    @ZenGetter(value="minComputationPointPerTick")
    public double getMinComputationPointPerTick() {
        return this.minComputationPointPerTick;
    }

    @ZenGetter(value="hideByDefault")
    public boolean isHideByDefault() {
        return this.hideByDefault;
    }

    @ZenMethod
    @ZenSetter(value="hideByDefault")
    public void setHideByDefault(boolean hideByDefault) {
        this.hideByDefault = hideByDefault;
    }

    public List<String> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    @ZenGetter(value="cycleResearch")
    public boolean isCycleResearch() {
        return this.cycleResearch;
    }

    @ZenGetter(value="maxCycle")
    public int getMaxCycle() {
        return this.maxCycle;
    }

    @ZenGetter(value="descriptions")
    public String[] getDescriptionsArray() {
        return this.descriptions.toArray(new String[0]);
    }

    public List<String> getUnlockedDescriptions() {
        return Collections.unmodifiableList(this.unlockedDescriptions);
    }

    @ZenGetter(value="unlockedDescriptions")
    public String[] getUnlockedDescriptionsArray() {
        return this.unlockedDescriptions.toArray(new String[0]);
    }

    public List<ResearchCognitionData> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public Object2IntOpenHashMap<ResearchCognitionData> getCycleDependencies() {
        return this.cycleDependencies;
    }

    public int hashCode() {
        return this.researchName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResearchCognitionData)) {
            return false;
        }
        ResearchCognitionData another = (ResearchCognitionData)obj;
        return this.researchName.equals(another.researchName);
    }
}

