/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old.machine;

import github.kasuminova.mmce.common.event.machine.MachineStructureUpdateEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFailureEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeFinishEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import github.kasuminova.novaeng.common.crafttweaker.expansion.RecipePrimerAssemblyLine;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeImpl;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftingStatus;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementIngredientArray;
import hellfirepvp.modularmachinery.common.crafting.requirement.RequirementItem;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.event.MMEvents;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.util.ResourceLocation;

public class AssemblyLine
extends NetNodeImpl {
    public static final String MACHINE_NAME = "assembly_line";
    protected final ChipManager chipManager = new ChipManager();
    private final Object2IntOpenHashMap<MachineRecipe> recipeItemLengths = new Object2IntOpenHashMap();

    public AssemblyLine(TileMultiblockMachineController owner) {
        super(owner);
        this.recipeItemLengths.defaultReturnValue(-1);
    }

    public static void registerNetNode() {
        ResourceLocation registryName = new ResourceLocation("modularmachinery", MACHINE_NAME);
        RegistryHyperNet.registerHyperNetNode(registryName, AssemblyLine.class);
        MMEvents.WAIT_FOR_MODIFY.add(() -> {
            DynamicMachine machine = MachineRegistry.getRegistry().getMachine(registryName);
            if (machine != null) {
                HyperNetHelper.addControllerGUIHyperNetInfo(machine, AssemblyLine.class);
            }
        });
        MMEvents.onStructureUpdate((String)MACHINE_NAME, event -> {
            AssemblyLine assemblyLine = NetNodeCache.getCache(event.getController(), AssemblyLine.class);
            if (assemblyLine != null) {
                assemblyLine.onAssemblyLineStructureUpdate((MachineStructureUpdateEvent)event);
            }
        });
    }

    public static boolean isNotAssemblyLine(TileMultiblockMachineController ctrl) {
        DynamicMachine foundMachine = ctrl.getFoundMachine();
        if (foundMachine == null) {
            return false;
        }
        return !RecipePrimerAssemblyLine.ASSEMBLY_LINE.equals((Object)foundMachine.getRegistryName());
    }

    @Override
    public void onMachineTick() {
        super.onMachineTick();
    }

    public void onAssemblyLineRecipeCheck(RecipeCheckEvent event) {
        if (!(event.getController() instanceof TileFactoryController)) {
            event.setFailed("\u88c5\u914d\u7ebf\u4e0d\u652f\u6301\u666e\u901a\u63a7\u5236\u5668\uff01");
        }
        if (this.chipManager.isLocked(0)) {
            event.setFailed("\u5176\u4ed6\u7ebf\u7a0b\u6b63\u5728\u4f7f\u7528\u88c5\u914d\u7ebf\u7247 #0\uff01");
        }
    }

    public void onAssemblyLineRecipePreTick(FactoryRecipeTickEvent event) {
        int using;
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        RecipeThread recipeThread = event.getRecipeThread();
        if (!this.chipManager.lock(recipeThread, using = this.getRequiredChipIndex(activeRecipe))) {
            event.setFailed(false, String.format("\u88c5\u914d\u7ebf\u7247 #%s \u5df2\u88ab\u9501\u5b9a\uff01", using));
        }
    }

    public void onAssemblyLineRecipePostTick(FactoryRecipeTickEvent event) {
        RecipeThread recipeThread = event.getRecipeThread();
        ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
        int using = this.getRequiredChipIndex(activeRecipe);
        if (!recipeThread.getStatus().isCrafting()) {
            this.chipManager.unlock(recipeThread);
        } else {
            recipeThread.setStatus(CraftingStatus.SUCCESS).setStatusInfo(String.format("\u5de5\u4f5c\u4e2d...\uff08\u5df2\u9501\u5b9a\u88c5\u914d\u7ebf\u7247 #%s\uff09", using));
        }
    }

    public void onAssemblyLineRecipeFinished(FactoryRecipeFinishEvent event) {
        this.chipManager.unlock(event.getRecipeThread());
    }

    public void onAssemblyLineRecipeFailure(FactoryRecipeFailureEvent event) {
        this.chipManager.unlock(event.getRecipeThread());
    }

    public void onAssemblyLineStructureUpdate(MachineStructureUpdateEvent event) {
        TileMultiblockMachineController ctrl = event.getController();
        IDynamicPatternInfo pattern = ctrl.getDynamicPattern("line");
        if (pattern != null) {
            ctrl.setExtraThreadCount(pattern.getSize());
        }
        this.chipManager.clean();
    }

    protected int getRecipeLength(MachineRecipe recipe) {
        int recipeLength = this.recipeItemLengths.getInt((Object)recipe);
        if (recipeLength == -1) {
            recipeLength = 0;
            for (ComponentRequirement req : recipe.getCraftingRequirements()) {
                if (!(req instanceof RequirementItem) && !(req instanceof RequirementIngredientArray)) continue;
                ++recipeLength;
            }
            this.recipeItemLengths.put((Object)recipe, recipeLength);
        }
        return recipeLength;
    }

    protected int getRequiredChipIndex(ActiveMachineRecipe activeRecipe) {
        int recipeLength = this.getRecipeLength(activeRecipe.getRecipe());
        float progress = (float)activeRecipe.getTick() / (float)activeRecipe.getTotalTick();
        return (int)((float)recipeLength * progress);
    }

    public static class ChipManager {
        private final Int2ObjectMap<RecipeThread> threadChipUsing = new Int2ObjectOpenHashMap();
        private final Object2IntOpenHashMap<RecipeThread> chipThreadUsing = new Object2IntOpenHashMap();

        public ChipManager() {
            this.chipThreadUsing.defaultReturnValue(-1);
        }

        public boolean lock(RecipeThread thread, int index) {
            int prevUsing = this.chipThreadUsing.getInt((Object)thread);
            if (prevUsing == index) {
                return true;
            }
            RecipeThread usingThread = (RecipeThread)this.threadChipUsing.get(index);
            if (usingThread != null && usingThread != thread && usingThread.getStatus().isCrafting()) {
                return false;
            }
            this.threadChipUsing.remove(prevUsing);
            this.threadChipUsing.put(index, (Object)thread);
            this.chipThreadUsing.put((Object)thread, index);
            return true;
        }

        public void unlock(RecipeThread thread) {
            int using = this.chipThreadUsing.removeInt((Object)thread);
            if (using != -1) {
                this.threadChipUsing.remove(using);
            }
        }

        public boolean isLocked(int index) {
            return this.threadChipUsing.containsKey(index);
        }

        public void clean() {
            this.chipThreadUsing.clear();
            this.threadChipUsing.clear();
        }
    }
}

