/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeStartEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeTickEvent;
import github.kasuminova.novaeng.common.crafttweaker.util.NovaEngUtils;
import github.kasuminova.novaeng.common.hypernet.old.Database;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import hellfirepvp.modularmachinery.common.machine.RecipeThread;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Collection;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.NetNodeImpl")
public class NetNodeImpl
extends NetNode {
    protected final Object2DoubleMap<RecipeThread> recipeConsumers = new Object2DoubleOpenHashMap();
    protected double computationPointConsumption = 0.0;

    public NetNodeImpl(TileMultiblockMachineController owner) {
        super(owner);
    }

    @Override
    public void onMachineTick() {
        super.onMachineTick();
        if (this.isWorking()) {
            if (this.owner.getTicksExisted() % 10 == 0) {
                double total = 0.0;
                DoubleIterator doubleIterator = this.recipeConsumers.values().iterator();
                while (doubleIterator.hasNext()) {
                    double value = (Double)doubleIterator.next();
                    total += value;
                }
                this.computationPointConsumption = total;
                this.recipeConsumers.clear();
            }
        } else {
            this.computationPointConsumption = 0.0;
        }
    }

    @ZenMethod
    public void checkComputationPoint(RecipeCheckEvent event, double pointRequired, ResearchCognitionData ... researchRequired) {
        if (this.centerPos == null || this.center == null) {
            event.setFailed("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        double generation = this.center.getComputationPointGeneration() - this.center.getComputationPointConsumption();
        if (generation < pointRequired) {
            event.setFailed("\u7b97\u529b\u4e0d\u8db3\uff01\u9884\u671f\uff1a" + NovaEngUtils.formatFLOPS(pointRequired) + "\uff0c\u5f53\u524d\uff1a" + NovaEngUtils.formatFLOPS(generation));
            return;
        }
        int currentParallelism = event.getActiveRecipe().getParallelism();
        if (currentParallelism > 1) {
            int max = (int)Math.min((double)currentParallelism, generation / pointRequired);
            event.setParallelism(max);
        }
    }

    @ZenMethod
    public void checkResearch(RecipeCheckEvent event, ResearchCognitionData ... researchRequired) {
        if (this.centerPos == null || this.center == null) {
            event.setFailed("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        Collection<Database> nodes = this.center.getNode(Database.class);
        if (nodes.isEmpty()) {
            event.setFailed("\u8ba1\u7b97\u7f51\u7edc\u4e2d\u672a\u627e\u5230\u6570\u636e\u5e93\uff01");
            return;
        }
        for (ResearchCognitionData researchCognitionData : researchRequired) {
            if (!nodes.stream().noneMatch(database -> database.hasResearchCognition(researchCognitionData))) continue;
            event.setFailed("\u7f3a\u5931\u7814\u7a76\uff1a" + researchCognitionData.getTranslatedName() + "\uff01");
            break;
        }
    }

    public void onRecipeStart(RecipeStartEvent event, double computation) {
        this.recipeConsumers.put((Object)event.getRecipeThread(), computation * (double)event.getActiveRecipe().getParallelism());
    }

    public void onRecipeStart(FactoryRecipeStartEvent event, double computation) {
        this.recipeConsumers.put((Object)event.getRecipeThread(), computation * (double)event.getActiveRecipe().getParallelism());
    }

    public void onRecipePreTick(RecipeTickEvent event, double computation, boolean triggerFailure) {
        if (this.centerPos == null) {
            event.setFailed(true, "\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.center == null) {
            event.preventProgressing("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        double required = computation * (double)event.getActiveRecipe().getParallelism();
        this.recipeConsumers.put((Object)event.getRecipeThread(), required);
        double consumed = this.center.consumeComputationPoint(required);
        if (consumed < required) {
            String failureMessage = String.format("\u7b97\u529b\u4e0d\u8db3\uff01\u9884\u671f\uff1a%s\uff0c\u5f53\u524d\uff1a%s", NovaEngUtils.formatFLOPS(required), NovaEngUtils.formatFLOPS(consumed));
            if (triggerFailure) {
                event.setFailed(event.getActiveRecipe().getRecipe().doesCancelRecipeOnPerTickFailure(), failureMessage);
            } else {
                event.preventProgressing(failureMessage);
            }
        }
    }

    public void onRecipePreTick(FactoryRecipeTickEvent event, double computation, boolean triggerFailure) {
        if (this.centerPos == null) {
            event.setFailed(true, "\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.center == null) {
            event.preventProgressing("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        double required = computation * (double)event.getActiveRecipe().getParallelism();
        this.recipeConsumers.put((Object)event.getRecipeThread(), required);
        double consumed = this.center.consumeComputationPoint(required);
        if (consumed < required) {
            String failureMessage = String.format("\u7b97\u529b\u4e0d\u8db3\uff01\u9884\u671f\uff1a%s\uff0c\u5f53\u524d\uff1a%s", NovaEngUtils.formatFLOPS(required), NovaEngUtils.formatFLOPS(consumed));
            if (triggerFailure) {
                event.setFailed(event.getActiveRecipe().getRecipe().doesCancelRecipeOnPerTickFailure(), failureMessage);
            } else {
                event.preventProgressing(failureMessage);
            }
        }
    }

    public void onRecipeFinished(RecipeThread thread) {
        this.recipeConsumers.removeDouble((Object)thread);
    }

    @Override
    public void readNBT(NBTTagCompound customData) {
        super.readNBT(customData);
        this.computationPointConsumption = customData.func_74769_h("c");
    }

    @Override
    public void writeNBT() {
        super.writeNBT();
        NBTTagCompound tag = this.owner.getCustomDataTag();
        tag.func_74780_a("c", this.computationPointConsumption);
    }

    @Override
    public double getComputationPointConsumption() {
        return this.computationPointConsumption;
    }
}

