/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import github.kasuminova.mmce.common.helper.IMachineController;
import github.kasuminova.novaeng.common.crafttweaker.hypernet.HyperNetHelper;
import github.kasuminova.novaeng.common.hypernet.old.ComputationCenter;
import github.kasuminova.novaeng.common.hypernet.old.misc.ConnectResult;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.NetNode")
public abstract class NetNode {
    protected final TileMultiblockMachineController owner;
    protected ComputationCenter center = null;
    protected BlockPos centerPos = null;

    public NetNode(TileMultiblockMachineController owner) {
        this.owner = owner;
    }

    @ZenMethod
    public void onMachineTick() {
        if (this.owner.getTicksExisted() % 20 != 0) {
            return;
        }
        if (this.isConnected()) {
            this.disconnect();
            this.connectToCenter();
        }
    }

    @ZenMethod
    public boolean connectTo(IBlockPos pos) {
        return this.connectTo(CraftTweakerMC.getBlockPos((IBlockPos)pos)).isSuccess();
    }

    public ConnectResult connectTo(BlockPos pos) {
        this.centerPos = pos;
        if (pos == null) {
            this.writeNBT();
            return ConnectResult.UNKNOWN_CENTER;
        }
        this.disconnect();
        ConnectResult result = this.connectToCenter();
        if (result.isSuccess()) {
            return result;
        }
        this.writeNBT();
        return result;
    }

    public void disconnect() {
        if (this.center != null) {
            this.center.onDisconnect(this.owner, this);
            this.center = null;
        }
    }

    @ZenMethod
    protected ConnectResult connectToCenter() {
        this.center = null;
        if (!this.owner.func_145831_w().func_175667_e(this.centerPos)) {
            return ConnectResult.UNKNOWN_CENTER;
        }
        TileEntity te = this.owner.func_145831_w().func_175625_s(this.centerPos);
        if (!(te instanceof TileMultiblockMachineController)) {
            return ConnectResult.UNKNOWN_CENTER;
        }
        TileMultiblockMachineController ctrl = (TileMultiblockMachineController)te;
        if (!HyperNetHelper.isComputationCenter(ctrl)) {
            return ConnectResult.UNKNOWN_CENTER;
        }
        ConnectResult result = ComputationCenter.from((IMachineController)ctrl).onConnect(this.owner, this);
        switch (result) {
            case NODE_TYPE_REACHED_MAX_PRESENCES: 
            case CENTER_REACHED_CONNECTION_LIMIT: {
                this.centerPos = null;
            }
        }
        this.writeNBT();
        return result;
    }

    @ZenGetter(value="working")
    public boolean isWorking() {
        return this.owner.isWorking();
    }

    public double requireComputationPoint(double maxGeneration, boolean doCalculate) {
        return 0.0;
    }

    @ZenMethod
    public double getComputationPointProvision(double maxGeneration) {
        return 0.0;
    }

    @ZenGetter(value="computationPointConsumption")
    public double getComputationPointConsumption() {
        return 0.0;
    }

    @ZenMethod
    public final void readNBT() {
        this.readNBT(this.owner.getCustomDataTag());
    }

    public void readNBT(NBTTagCompound customData) {
        this.centerPos = null;
        this.center = null;
        if (!customData.func_74764_b("centerPos")) {
            return;
        }
        this.centerPos = BlockPos.func_177969_a((long)customData.func_74763_f("centerPos"));
    }

    @ZenMethod
    public void writeNBT() {
        this.writeNBT(this.owner.getCustomDataTag());
    }

    public void writeNBT(NBTTagCompound tag) {
        if (this.centerPos != null) {
            tag.func_74772_a("centerPos", this.centerPos.func_177986_g());
        }
    }

    @ZenGetter(value="maxNodePresences")
    public int getNodeMaxPresences() {
        return 1000;
    }

    @ZenGetter(value="center")
    public ComputationCenter getCenter() {
        return this.center;
    }

    public void onConnected(@Nonnull ComputationCenter center) {
        this.center = center;
    }

    @ZenGetter(value="connected")
    public boolean isConnected() {
        return this.centerPos != null;
    }

    public TileMultiblockMachineController getOwner() {
        return this.owner;
    }
}

