/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.novaeng.common.hypernet.old.DatabaseType;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.research.ResearchCognitionData;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.Database")
public class Database
extends NetNode {
    private final Set<ResearchCognitionData> storedResearchCognition = new HashSet<ResearchCognitionData>();
    private final Object2DoubleOpenHashMap<ResearchCognitionData> researchingCognition = new Object2DoubleOpenHashMap();
    private final DatabaseType type;

    public Database(TileMultiblockMachineController owner) {
        super(owner);
        this.type = RegistryHyperNet.getDatabaseType(Objects.requireNonNull(owner.getFoundMachine()).getRegistryName().func_110623_a());
        this.researchingCognition.defaultReturnValue(-1.0);
    }

    @ZenMethod
    public void onWorkingTick(FactoryRecipeTickEvent event) {
        event.getActiveRecipe().setTick(0);
        if (this.centerPos == null) {
            event.setFailed(true, "\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.center == null) {
            event.preventProgressing("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.owner.getTicksExisted() % 40 == 0) {
            return;
        }
        FactoryRecipeThread thread = event.getFactoryRecipeThread();
        float energyUsage = Math.max(1.0f, 1.0f + (float)this.storedResearchCognition.size() * 0.1f);
        thread.addModifier("energy", new RecipeModifier((RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, energyUsage, 1, false));
    }

    @Override
    public boolean isWorking() {
        TileMultiblockMachineController tileMultiblockMachineController = this.owner;
        if (!(tileMultiblockMachineController instanceof TileFactoryController)) {
            return false;
        }
        TileFactoryController factory = (TileFactoryController)tileMultiblockMachineController;
        FactoryRecipeThread thread = (FactoryRecipeThread)factory.getCoreRecipeThreads().get("novaeng.hypernet.data_forwarding_processor");
        return this.owner.isWorking() && thread != null && thread.isWorking();
    }

    @Override
    public void readNBT(NBTTagCompound customData) {
        int bound;
        super.readNBT(customData);
        this.storedResearchCognition.clear();
        if (customData.func_74764_b("storedResearchCognition")) {
            NBTTagList tagList = customData.func_150295_c("storedResearchCognition", 8);
            bound = tagList.func_74745_c();
            IntStream.range(0, bound).mapToObj(arg_0 -> ((NBTTagList)tagList).func_150307_f(arg_0)).map(RegistryHyperNet::getResearchCognitionData).filter(Objects::nonNull).forEach(this.storedResearchCognition::add);
        }
        this.researchingCognition.clear();
        if (customData.func_74764_b("researchingCognition")) {
            NBTTagList researching = customData.func_150295_c("researchingCognition", 10);
            bound = researching.func_74745_c();
            IntStream.range(0, bound).mapToObj(arg_0 -> ((NBTTagList)researching).func_150305_b(arg_0)).forEach(compound -> {
                ResearchCognitionData data = RegistryHyperNet.getResearchCognitionData(compound.func_74779_i("researchName"));
                if (data != null) {
                    this.researchingCognition.put((Object)data, compound.func_74769_h("progress"));
                }
            });
        }
    }

    @Override
    public void writeNBT() {
        super.writeNBT();
        NBTTagCompound tag = this.owner.getCustomDataTag();
        NBTTagList stored = new NBTTagList();
        for (ResearchCognitionData data2 : this.storedResearchCognition) {
            NBTTagString tagStr = new NBTTagString(data2.getResearchName());
            stored.func_74742_a((NBTBase)tagStr);
        }
        NBTTagList researching = new NBTTagList();
        this.researchingCognition.forEach((data, progress) -> {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("researchName", data.getResearchName());
            compound.func_74780_a("progress", progress.doubleValue());
            researching.func_74742_a((NBTBase)compound);
        });
        tag.func_74782_a("storedResearchCognition", (NBTBase)stored);
        tag.func_74782_a("researchingCognition", (NBTBase)researching);
    }

    @ZenMethod
    public boolean hasResearchCognition(String researchName) {
        ResearchCognitionData data = RegistryHyperNet.getResearchCognitionData(researchName);
        return data != null && this.hasResearchCognition(data);
    }

    @ZenMethod
    public boolean hasResearchCognition(ResearchCognitionData research) {
        return this.isWorking() && research != null && this.storedResearchCognition.contains(research);
    }

    @ZenMethod
    public double getResearchingData(ResearchCognitionData data) {
        return this.isWorking() ? this.researchingCognition.getDouble((Object)data) : -1.0;
    }

    @ZenMethod
    public boolean writeResearchingData(ResearchCognitionData data, double progress) {
        if (!this.hasDatabaseSpace(data)) {
            return false;
        }
        this.researchingCognition.put((Object)data, progress);
        this.writeNBT();
        return true;
    }

    @ZenMethod
    public boolean hasDatabaseSpace() {
        int stored;
        int maxStoreSize = this.type.getMaxResearchDataStoreSize();
        return maxStoreSize > (stored = this.storedResearchCognition.size());
    }

    @ZenMethod
    public boolean hasDatabaseSpace(@Nullable ResearchCognitionData toStore) {
        int maxStoreSize = this.type.getMaxResearchDataStoreSize();
        int stored = this.storedResearchCognition.size();
        int researching = this.researchingCognition.size();
        if (this.researchingCognition.containsKey((Object)toStore)) {
            --researching;
        }
        return maxStoreSize > stored + researching;
    }

    @ZenMethod
    public boolean storeResearchCognitionData(ResearchCognitionData data) {
        if (!this.hasDatabaseSpace(data)) {
            return false;
        }
        this.storedResearchCognition.add(data);
        this.writeNBT();
        return true;
    }

    @ZenGetter(value="storedResearchCognition")
    public ResearchCognitionData[] getStoredResearchCognitionArr() {
        return this.storedResearchCognition.toArray(new ResearchCognitionData[0]);
    }

    @ZenMethod
    public double getResearchingCognitionProgress(String researchName) {
        return (Double)this.researchingCognition.getOrDefault((Object)RegistryHyperNet.getResearchCognitionData(researchName), (Object)0.0);
    }

    public Object2DoubleOpenHashMap<ResearchCognitionData> getAllResearchingCognition() {
        return this.isWorking() ? this.researchingCognition : new Object2DoubleOpenHashMap();
    }

    public Set<ResearchCognitionData> getStoredResearchCognition() {
        return this.isWorking() ? this.storedResearchCognition : Collections.emptySet();
    }

    @ZenGetter(value="type")
    public DatabaseType getType() {
        return this.type;
    }

    public Status createStatus() {
        return new Status(this.type, this.storedResearchCognition.size(), this.researchingCognition.size());
    }

    public static class Status {
        private final DatabaseType type;
        private final int storedCognition;
        private final int researchingCognition;

        public Status(DatabaseType type, int storedCognition, int researchingCognition) {
            this.type = type;
            this.storedCognition = storedCognition;
            this.researchingCognition = researchingCognition;
        }

        public static Status readFromNBT(NBTTagCompound tag) {
            if (!(tag.func_74764_b("t") && tag.func_74764_b("s") && tag.func_74764_b("r"))) {
                return null;
            }
            DatabaseType type = RegistryHyperNet.getDatabaseType(tag.func_74779_i("t"));
            if (type == null) {
                return null;
            }
            return new Status(type, tag.func_74762_e("s"), tag.func_74762_e("r"));
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("t", this.type.getTypeName());
            tag.func_74768_a("s", this.storedCognition);
            tag.func_74768_a("r", this.researchingCognition);
            return tag;
        }

        public boolean hasDatabaseSpace() {
            return this.type.getMaxResearchDataStoreSize() > this.storedCognition + this.researchingCognition;
        }

        public DatabaseType getType() {
            return this.type;
        }

        public int getStoredCognition() {
            return this.storedCognition;
        }

        public int getResearchingCognition() {
            return this.researchingCognition;
        }
    }
}

