/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import github.kasuminova.novaeng.common.hypernet.old.DataProcessor;
import github.kasuminova.novaeng.common.hypernet.old.NetNodeCache;
import github.kasuminova.novaeng.common.hypernet.old.base.NetNodeType;
import hellfirepvp.modularmachinery.common.crafting.ActiveMachineRecipe;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.MachineModifier;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipeBuilder;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.RecipePrimer;
import hellfirepvp.modularmachinery.common.integration.crafttweaker.event.MMEvents;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.FMLCommonHandler;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="novaeng.hypernet.DataProcessorType")
public class DataProcessorType
extends NetNodeType {
    public static final String PROCESSOR_WORKING_THREAD_NAME = "novaeng.hypernet.data_processor.compute_scheduler";
    public static final String PROCESSOR_RADIATOR_THREAD_NAME = "novaeng.hypernet.data_processor.radiator";
    private final int heatDistribution;
    private final int overheatThreshold;
    private final List<Tuple<Tuple<IIngredient[], IIngredient[]>, Integer>> radiatorIngredientList = new ArrayList<Tuple<Tuple<IIngredient[], IIngredient[]>, Integer>>();
    private String dynamicPatternName = "";

    public DataProcessorType(String typeName, long energyUsage, int heatDistribution, int overheatThreshold) {
        super(typeName, energyUsage);
        this.heatDistribution = heatDistribution;
        this.overheatThreshold = overheatThreshold;
    }

    @ZenMethod
    public static DataProcessorType create(String typeName, long energyUsage, int heatDistribution, int overheatThreshold) {
        return new DataProcessorType(typeName, energyUsage, heatDistribution, overheatThreshold);
    }

    public void registerRecipesAndThreads() {
        String name = this.typeName;
        MachineModifier.addCoreThread((String)name, (FactoryRecipeThread)FactoryRecipeThread.createCoreThread((String)PROCESSOR_WORKING_THREAD_NAME));
        if (!this.radiatorIngredientList.isEmpty()) {
            MachineModifier.addCoreThread((String)name, (FactoryRecipeThread)FactoryRecipeThread.createCoreThread((String)PROCESSOR_RADIATOR_THREAD_NAME));
        }
        MMEvents.onStructureUpdate((String)name, event -> {
            DataProcessor processor = NetNodeCache.getCache(event.getController(), DataProcessor.class);
            if (processor != null) {
                processor.onStructureUpdate();
            }
        });
        RecipeBuilder.newBuilder((String)(name + "_working"), (String)name, (int)20, (int)100, (boolean)false).addEnergyPerTickInput(this.energyUsage).addPostCheckHandler(event -> {
            DataProcessor processor = NetNodeCache.getCache(event.getController(), DataProcessor.class);
            if (processor != null) {
                processor.onRecipeCheck((RecipeCheckEvent)event);
            }
        }).addFactoryPreTickHandler(event -> {
            DataProcessor processor = NetNodeCache.getCache(event.getController(), DataProcessor.class);
            if (processor != null) {
                processor.onWorkingTick((FactoryRecipeTickEvent)event);
            }
        }).addRecipeTooltip(new String[]{"novaeng.hypernet.data_processor.working.tooltip.0", "novaeng.hypernet.data_processor.working.tooltip.1"}).setThreadName(PROCESSOR_WORKING_THREAD_NAME).setParallelized(false).build();
        int counter = 0;
        for (Tuple<Tuple<IIngredient[], IIngredient[]>, Integer> radiatorIngredient : this.radiatorIngredientList) {
            String[] stringArray;
            Tuple io = (Tuple)radiatorIngredient.func_76341_a();
            IIngredient[] input = (IIngredient[])io.func_76341_a();
            IIngredient[] output = (IIngredient[])io.func_76340_b();
            int heatDistribution = (Integer)radiatorIngredient.func_76340_b();
            RecipePrimer recipePrimer = RecipeBuilder.newBuilder((String)(name + "_heat_dist_" + counter), (String)name, (int)1, (int)(101 + counter), (boolean)false).addEnergyPerTickInput(this.energyUsage / 2L).addInputs(input).addOutputs(output).addPostCheckHandler(event -> {
                DataProcessor processor = NetNodeCache.getCache(event.getController(), DataProcessor.class);
                if (processor == null) {
                    event.setFailed("?");
                    return;
                }
                processor.heatDistributionRecipeCheck((RecipeCheckEvent)event, heatDistribution);
                if (!event.isFailure() && !this.dynamicPatternName.isEmpty()) {
                    ActiveMachineRecipe activeRecipe = event.getActiveRecipe();
                    int parallelism = activeRecipe.getParallelism();
                    IDynamicPatternInfo dynamicPattern = event.getController().getDynamicPattern(this.dynamicPatternName);
                    if (dynamicPattern != null) {
                        int storedHU = processor.getStoredHU();
                        int maxParallelism = Math.min(storedHU / heatDistribution, activeRecipe.getMaxParallelism());
                        if (parallelism > dynamicPattern.getSize() || parallelism > maxParallelism) {
                            event.setParallelism(Math.min(dynamicPattern.getSize(), maxParallelism));
                        }
                    } else if (parallelism > 1) {
                        event.setParallelism(1);
                    }
                }
            }).addFactoryFinishHandler(event -> {
                DataProcessor processor = NetNodeCache.getCache(event.getController(), DataProcessor.class);
                if (processor != null) {
                    processor.setStoredHU(processor.getStoredHU() - heatDistribution * event.getActiveRecipe().getParallelism());
                }
            });
            if (FMLCommonHandler.instance().getSide().isClient()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = I18n.func_135052_a((String)"novaeng.hypernet.radiator.tooltip", (Object[])new Object[]{heatDistribution * 20});
            } else {
                stringArray = new String[]{};
            }
            recipePrimer.addRecipeTooltip(stringArray).setThreadName(PROCESSOR_RADIATOR_THREAD_NAME).build();
            ++counter;
        }
    }

    @ZenMethod
    public DataProcessorType addRadiatorIngredient(int heatDistribution, IIngredient[] ingredients, IIngredient[] outputs) {
        this.radiatorIngredientList.add((Tuple<Tuple<IIngredient[], IIngredient[]>, Integer>)new Tuple((Object)new Tuple((Object)ingredients, (Object)outputs), (Object)heatDistribution));
        return this;
    }

    @ZenGetter(value="heatDistribution")
    public int getHeatDistribution() {
        return this.heatDistribution;
    }

    @ZenGetter(value="overheatThreshold")
    public int getOverheatThreshold() {
        return this.overheatThreshold;
    }

    @ZenGetter(value="dynamicPatternName")
    public String getDynamicPatternName() {
        return this.dynamicPatternName;
    }

    @ZenMethod
    public DataProcessorType setDynamicPatternName(String dynamicPatternName) {
        this.dynamicPatternName = dynamicPatternName;
        return this;
    }
}

