/*
 * Decompiled with CFR 0.152.
 */
package github.kasuminova.novaeng.common.hypernet.old;

import crafttweaker.annotations.ZenRegister;
import github.kasuminova.mmce.common.event.recipe.FactoryRecipeTickEvent;
import github.kasuminova.mmce.common.event.recipe.RecipeCheckEvent;
import github.kasuminova.mmce.common.helper.IDynamicPatternInfo;
import github.kasuminova.mmce.common.util.concurrent.Queues;
import github.kasuminova.novaeng.common.handler.HyperNetEventHandler;
import github.kasuminova.novaeng.common.hypernet.old.DataProcessorType;
import github.kasuminova.novaeng.common.hypernet.old.NetNode;
import github.kasuminova.novaeng.common.hypernet.old.upgrade.ProcessorModuleCPU;
import github.kasuminova.novaeng.common.hypernet.old.upgrade.ProcessorModuleRAM;
import github.kasuminova.novaeng.common.registry.RegistryHyperNet;
import hellfirepvp.modularmachinery.common.crafting.requirement.type.RequirementType;
import hellfirepvp.modularmachinery.common.lib.RequirementTypesMM;
import hellfirepvp.modularmachinery.common.machine.IOType;
import hellfirepvp.modularmachinery.common.machine.factory.FactoryRecipeThread;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.tiles.TileFactoryController;
import hellfirepvp.modularmachinery.common.tiles.base.TileMultiblockMachineController;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.nbt.NBTTagCompound;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="novaeng.hypernet.DataProcessor")
public class DataProcessor
extends NetNode {
    private final Lock lock = new ReentrantLock();
    private final Queue<Long> recentEnergyUsage = Queues.createConcurrentQueue();
    private final Queue<Double> recentCalculation = Queues.createConcurrentQueue();
    private final DataProcessorType type;
    private final LinkedList<Double> computationalLoadHistory = new LinkedList();
    private final List<ProcessorModuleCPU> moduleCPUS = new CopyOnWriteArrayList<ProcessorModuleCPU>();
    private final List<ProcessorModuleRAM> moduleRAMS = new CopyOnWriteArrayList<ProcessorModuleRAM>();
    private volatile int dynamicPatternSize = 0;
    private volatile double maxGeneration = 0.0;
    private final AtomicReference<Double> generated = new AtomicReference<Double>(0.0);
    private int storedHU = 0;
    private boolean overheat = false;
    private double computationalLoadHistoryCache = 0.0;
    private double computationalLoad = 0.0;

    public DataProcessor(TileMultiblockMachineController owner) {
        super(owner);
        this.type = RegistryHyperNet.getDataProcessorType(Objects.requireNonNull(owner.getFoundMachine()).getRegistryName().func_110623_a());
    }

    @ZenMethod
    public void onRecipeCheck(RecipeCheckEvent event) {
        if (this.centerPos == null || this.center == null) {
            event.setFailed("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return;
        }
        if (this.overheat) {
            event.setFailed("\u5904\u7406\u5668\u8fc7\u70ed\uff01");
            return;
        }
        if (this.moduleCPUS.isEmpty() && this.moduleRAMS.isEmpty()) {
            event.setFailed("\u672a\u627e\u5230\u5904\u7406\u5668\u548c\u5185\u5b58\u6a21\u5757\uff01");
            return;
        }
        if (this.moduleCPUS.isEmpty()) {
            event.setFailed("\u81f3\u5c11\u9700\u8981\u5b89\u88c5\u4e00\u4e2a CPU \u6216 GPU \u6a21\u5757\uff01");
            return;
        }
        if (this.moduleRAMS.isEmpty()) {
            event.setFailed("\u81f3\u5c11\u9700\u8981\u5b89\u88c5\u4e00\u4e2a\u5185\u5b58\u6a21\u5757\uff01");
        }
    }

    @ZenMethod
    public void heatDistributionRecipeCheck(RecipeCheckEvent event, int heatDistribution) {
        if (this.storedHU - heatDistribution < 0) {
            event.setFailed("novaeng.hypernet.craftcheck.heat_distribution.failed");
        }
    }

    @ZenMethod
    public void onWorkingTick(FactoryRecipeTickEvent event) {
        Long usage;
        event.getActiveRecipe().setTick(0);
        if (this.workingCheck(event)) {
            return;
        }
        long baseEnergyUsage = this.type.getEnergyUsage();
        long energyUsage = 0L;
        while ((usage = this.recentEnergyUsage.poll()) != null) {
            energyUsage += usage.longValue();
        }
        float heatPercent = this.getOverHeatPercent();
        energyUsage = heatPercent <= 0.1f ? (energyUsage += baseEnergyUsage / 10L * (long)this.dynamicPatternSize > 0L ? (long)this.dynamicPatternSize : 1L) : (heatPercent <= 0.5f ? (energyUsage += baseEnergyUsage / 5L * (long)this.dynamicPatternSize > 0L ? (long)this.dynamicPatternSize : 1L) : (heatPercent <= 0.75f ? (energyUsage += baseEnergyUsage / 2L * (long)this.dynamicPatternSize > 0L ? (long)this.dynamicPatternSize : 1L) : (energyUsage += baseEnergyUsage * (long)this.dynamicPatternSize > 0L ? (long)this.dynamicPatternSize : 1L)));
        float mul = (float)((double)(energyUsage + baseEnergyUsage) / (double)baseEnergyUsage);
        event.getRecipeThread().addModifier("energy", new RecipeModifier((RequirementType)RequirementTypesMM.REQUIREMENT_ENERGY, IOType.INPUT, mul, 1, false));
    }

    protected boolean workingCheck(FactoryRecipeTickEvent event) {
        if (this.centerPos == null) {
            event.setFailed(true, "\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return true;
        }
        if (this.center == null) {
            event.preventProgressing("\u672a\u8fde\u63a5\u81f3\u8ba1\u7b97\u7f51\u7edc\uff01");
            return true;
        }
        if (this.overheat) {
            event.setFailed(true, "\u5904\u7406\u5668\u8fc7\u70ed\uff01");
            return true;
        }
        if (this.moduleCPUS.isEmpty() && this.moduleRAMS.isEmpty()) {
            event.setFailed(true, "\u672a\u627e\u5230\u5904\u7406\u5668\u548c\u5185\u5b58\u6a21\u5757\uff01");
            return true;
        }
        if (this.moduleCPUS.isEmpty()) {
            event.setFailed(true, "\u81f3\u5c11\u9700\u8981\u5b89\u88c5\u4e00\u4e2a CPU \u6216 GPU \u6a21\u5757\uff01");
            return true;
        }
        if (this.moduleRAMS.isEmpty()) {
            event.setFailed(true, "\u81f3\u5c11\u9700\u8981\u5b89\u88c5\u4e00\u4e2a\u5185\u5b58\u6a21\u5757\uff01");
            return true;
        }
        return false;
    }

    @Override
    @ZenMethod
    public void onMachineTick() {
        super.onMachineTick();
        if (!this.isWorking()) {
            this.generated.set(0.0);
            this.computationalLoad = 0.0;
            this.computationalLoadHistoryCache = 0.0;
            this.computationalLoadHistory.clear();
        } else {
            Double calculation;
            double totalCalculation = 0.0;
            while ((calculation = this.recentCalculation.poll()) != null) {
                totalCalculation += calculation.doubleValue();
            }
            this.computationalLoadHistory.addFirst(totalCalculation);
            this.computationalLoadHistoryCache += totalCalculation;
            if (this.computationalLoadHistory.size() > 100) {
                this.computationalLoadHistoryCache -= this.computationalLoadHistory.pollLast().doubleValue();
            }
            this.computationalLoad = this.computationalLoadHistoryCache / (double)this.computationalLoadHistory.size();
            HyperNetEventHandler.addTickStartAction(() -> this.generated.set(this.maxGeneration));
        }
        if (this.owner.getTicksExisted() % 20 == 0) {
            this.maxGeneration = this.getComputationPointProvision(1.6777215E7);
            IDynamicPatternInfo dynamicPattern = this.owner.getDynamicPattern(this.type.getDynamicPatternName());
            this.dynamicPatternSize = dynamicPattern != null ? dynamicPattern.getSize() : 0;
            this.writeNBT();
        }
        if (this.storedHU > 0) {
            int heatDist = this.calculateHeatDist();
            this.storedHU -= Math.min(heatDist, this.storedHU);
            if (this.storedHU <= 0) {
                this.overheat = false;
            }
            this.maxGeneration = this.getComputationPointProvision(1.6777215E7);
            this.writeNBT();
        }
    }

    @ZenMethod
    public void onStructureUpdate() {
        try {
            this.lock.lock();
            this.moduleCPUS.clear();
            this.moduleRAMS.clear();
            this.moduleCPUS.addAll(ProcessorModuleCPU.filter(this.owner.getFoundUpgrades().values()));
            this.moduleRAMS.addAll(ProcessorModuleRAM.filter(this.owner.getFoundUpgrades().values()));
        }
        finally {
            this.lock.unlock();
        }
    }

    private int calculateHeatDist() {
        float heatPercent = this.getOverHeatPercent();
        float heatDist = this.type.getHeatDistribution();
        if (this.dynamicPatternSize > 1) {
            heatDist *= (float)this.dynamicPatternSize;
        }
        heatDist = heatPercent <= 0.25f ? (heatDist *= 0.25f) : (heatPercent <= 0.75f ? (heatDist *= 0.25f + heatPercent) : (heatDist *= 1.0f));
        return (int)heatDist;
    }

    @Override
    public double requireComputationPoint(double maxGeneration, boolean doCalculate) {
        if (!this.isConnected() || this.center == null || !this.isWorking()) {
            return 0.0;
        }
        double[] polledCounter = new double[]{0.0};
        this.generated.updateAndGet(generated -> {
            if (generated < maxGeneration) {
                polledCounter[0] = generated;
                return 0.0;
            }
            polledCounter[0] = maxGeneration;
            return generated - maxGeneration;
        });
        if (polledCounter[0] <= 0.0) {
            return 0.0;
        }
        double maxCanGenerated = polledCounter[0];
        double generated2 = this.calculateComputationPointProvision(maxCanGenerated, doCalculate);
        if (doCalculate) {
            this.doHeatGeneration(generated2);
            this.generated.updateAndGet(counter -> counter + (maxCanGenerated - generated2));
        }
        return generated2;
    }

    @Override
    public boolean isWorking() {
        TileMultiblockMachineController tileMultiblockMachineController = this.owner;
        if (!(tileMultiblockMachineController instanceof TileFactoryController)) {
            return false;
        }
        TileFactoryController factory = (TileFactoryController)tileMultiblockMachineController;
        FactoryRecipeThread thread = (FactoryRecipeThread)factory.getCoreRecipeThreads().get("novaeng.hypernet.data_processor.compute_scheduler");
        return this.owner.isWorking() && thread != null && thread.isWorking();
    }

    @ZenGetter(value="maxGeneration")
    public double getMaxGeneration() {
        return this.maxGeneration;
    }

    public float getEfficiency() {
        float overHeatPercent = this.getOverHeatPercent();
        return overHeatPercent >= 0.85f ? (1.0f - overHeatPercent) / 0.15f : 1.0f;
    }

    @ZenGetter(value="overHeatPercent")
    public float getOverHeatPercent() {
        return this.overheat ? 1.0f : (float)this.storedHU / (float)this.type.getOverheatThreshold();
    }

    public void doHeatGeneration(double computationPointGeneration) {
        this.storedHU += (int)(computationPointGeneration * 2.0);
        if (this.storedHU >= this.type.getOverheatThreshold()) {
            this.overheat = true;
        }
    }

    public double calculateComputationPointProvision(double maxGeneration, boolean doCalculate) {
        double generated;
        if (this.overheat || !this.isWorking()) {
            return 0.0;
        }
        if (this.owner.getFoundUpgrades().isEmpty()) {
            return 0.0;
        }
        if (this.moduleCPUS.isEmpty()) {
            return 0.0;
        }
        if (this.moduleRAMS.isEmpty()) {
            return 0.0;
        }
        long totalEnergyConsumption = 0L;
        double maxGen = maxGeneration * (double)this.getEfficiency();
        double generationLimit = 0.0;
        double totalGenerated = 0.0;
        for (ProcessorModuleRAM ram : this.moduleRAMS) {
            generated = ram.calculate(doCalculate, maxGen - generationLimit);
            generationLimit += generated;
            if (!doCalculate) continue;
            totalEnergyConsumption += (long)(generated / ram.getComputationPointGenerationLimit() * (double)ram.getEnergyConsumption());
        }
        for (ProcessorModuleCPU cpu : this.moduleCPUS) {
            generated = cpu.calculate(doCalculate, generationLimit - totalGenerated);
            totalGenerated += generated;
            if (doCalculate) {
                totalEnergyConsumption += (long)(generated / cpu.getComputationPointGeneration() * (double)cpu.getEnergyConsumption());
            }
            if (!(totalGenerated >= generationLimit)) continue;
            break;
        }
        if (doCalculate) {
            this.recentCalculation.offer(totalGenerated);
            this.recentEnergyUsage.offer(totalEnergyConsumption);
        }
        return totalGenerated;
    }

    @Override
    public void readNBT(NBTTagCompound customData) {
        super.readNBT(customData);
        this.storedHU = customData.func_74762_e("storedHU");
        if (customData.func_74764_b("overheat")) {
            this.overheat = customData.func_74767_n("overheat");
        }
        this.computationalLoad = customData.func_74760_g("computationalLoad");
        this.maxGeneration = customData.func_74760_g("maxGeneration");
    }

    @Override
    public void writeNBT() {
        super.writeNBT();
        NBTTagCompound tag = this.owner.getCustomDataTag();
        tag.func_74768_a("storedHU", this.storedHU);
        tag.func_74757_a("overheat", this.overheat);
        tag.func_74780_a("computationalLoad", this.computationalLoad);
        tag.func_74780_a("maxGeneration", this.maxGeneration);
    }

    @Override
    public double getComputationPointProvision(double maxGeneration) {
        return this.calculateComputationPointProvision(maxGeneration, false);
    }

    @ZenGetter(value="computationalLoad")
    public double getComputationalLoad() {
        return this.computationalLoad;
    }

    @ZenGetter(value="type")
    public DataProcessorType getType() {
        return this.type;
    }

    @ZenGetter(value="storedHU")
    public int getStoredHU() {
        return this.storedHU;
    }

    @ZenSetter(value="storedHU")
    public void setStoredHU(int storedHU) {
        this.storedHU = storedHU;
        this.writeNBT();
    }

    @ZenGetter(value="overheat")
    public boolean isOverheat() {
        return this.overheat;
    }
}

